/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.qt.core.pdom;

import org.eclipse.cdt.internal.core.pdom.db.IString;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.qt.core.pdom.IQtPDOMCodec;
import org.eclipse.cdt.internal.qt.core.pdom.QtPDOMArray;
import org.eclipse.cdt.internal.qt.core.pdom.QtPDOMBinding;
import org.eclipse.cdt.internal.qt.core.pdom.QtPDOMLinkage;
import org.eclipse.cdt.internal.qt.core.pdom.QtPDOMNodeType;
import org.eclipse.cdt.internal.qt.core.pdom.QtPDOMQObject;
import org.eclipse.cdt.internal.qt.core.pdom.QtPropertyName;
import org.eclipse.cdt.qt.core.QtPlugin;
import org.eclipse.cdt.qt.core.index.IQProperty;
import org.eclipse.core.runtime.CoreException;

public class QtPDOMProperty
extends QtPDOMBinding {
    private static int offsetInitializer = QtPDOMBinding.Field.Last.offset;

    public QtPDOMProperty(QtPDOMLinkage linkage, long record) {
        super(linkage, record);
    }

    public QtPDOMProperty(QtPDOMLinkage linkage, PDOMBinding parent, QtPropertyName qtName) throws CoreException {
        super(linkage, (PDOMNode)parent, qtName);
        this.setType(qtName.getType());
        if (parent instanceof QtPDOMQObject) {
            ((QtPDOMQObject)parent).addChild((PDOMNode)this);
        }
    }

    @Override
    protected int getRecordSize() {
        return Field.Last.offset;
    }

    public int getNodeType() {
        return QtPDOMNodeType.QProperty.Type;
    }

    public void delete() throws CoreException {
        long fieldRec = this.getDB().getRecPtr(Field.Type.getRecord(this.record));
        if (fieldRec != 0L) {
            this.getDB().getString(fieldRec).delete();
        }
        this.getDB().putRecPtr(Field.Type.getRecord(this.record), 0L);
    }

    public void setType(String type) throws CoreException {
        long rec = this.getDB().getRecPtr(Field.Type.getRecord(this.record));
        if (rec != 0L) {
            IString typeStr = this.getDB().getString(rec);
            if (type == null) {
                typeStr.delete();
                return;
            }
            if (type.equals(typeStr.getString())) {
                return;
            }
        }
        this.getDB().putRecPtr(Field.Type.getRecord(this.record), this.getDB().newString(type).getRecord());
    }

    public String getType() throws CoreException {
        long rec = this.getDB().getRecPtr(Field.Type.getRecord(this.record));
        if (rec == 0L) {
            return null;
        }
        return this.getDB().getString(rec).getString();
    }

    public void setAttributes(Attribute[] attributes) throws CoreException {
        long rec = this.getDB().getRecPtr(Field.Attributes.getRecord(this.record));
        QtPDOMArray<Attribute> pdomArray = new QtPDOMArray<Attribute>(this.getQtLinkage(), Attribute.Codec, rec);
        rec = pdomArray.set(attributes);
        this.getDB().putRecPtr(Field.Attributes.getRecord(this.record), rec);
    }

    public Attribute[] getAttributes() throws CoreException {
        long rec = this.getDB().getRecPtr(Field.Attributes.getRecord(this.record));
        QtPDOMArray pdomArray = new QtPDOMArray(this.getQtLinkage(), Attribute.Codec, rec);
        return (Attribute[])pdomArray.get();
    }

    public static class Attribute {
        public final IQProperty.Attribute attr;
        public final String value;
        public final long cppRecord;
        private static final IQtPDOMCodec<Attribute> Codec = new IQtPDOMCodec<Attribute>(){

            @Override
            public int getElementSize() {
                return 9;
            }

            public Attribute[] allocArray(int count) {
                return new Attribute[count];
            }

            @Override
            public Attribute decode(QtPDOMLinkage linkage, long record) throws CoreException {
                byte attrId = linkage.getDB().getByte(record);
                long valRec = linkage.getDB().getRecPtr(record + 1L);
                long cppRec = linkage.getDB().getRecPtr(record + 1L + 4L);
                if (attrId < 0 || attrId >= IQProperty.Attribute.values().length) {
                    throw QtPlugin.coreException("invalid QProperty attribute id read from datbase, was " + attrId);
                }
                IQProperty.Attribute attr = IQProperty.Attribute.values()[attrId];
                String val = valRec == 0L ? "" : linkage.getDB().getString(valRec).getString();
                return new Attribute(attr, val, cppRec);
            }

            @Override
            public void encode(QtPDOMLinkage linkage, long record, Attribute element) throws CoreException {
                linkage.getDB().putByte(record, (byte)element.attr.ordinal());
                long rec = linkage.getDB().getRecPtr(record + 1L);
                if (rec != 0L) {
                    linkage.getDB().getString(rec).delete();
                }
                if (element == null || element.value == null) {
                    linkage.getDB().putRecPtr(record + 1L, 0L);
                } else {
                    linkage.getDB().putRecPtr(record + 1L, linkage.getDB().newString(element.value).getRecord());
                }
                linkage.getDB().putRecPtr(record + 1L + 4L, element.cppRecord);
            }
        };

        public Attribute(IQProperty.Attribute attr, String value) {
            this.attr = attr;
            this.value = value;
            this.cppRecord = 0L;
        }

        public Attribute(IQProperty.Attribute attr, String value, PDOMBinding cppBinding) {
            this.attr = attr;
            this.value = value;
            this.cppRecord = cppBinding == null ? 0L : cppBinding.getRecord();
        }

        private Attribute(IQProperty.Attribute attr, String value, long cppRecord) {
            this.attr = attr;
            this.value = value;
            this.cppRecord = cppRecord;
        }
    }

    protected static enum Field {
        Type(4),
        Attributes(4),
        Last(0);

        public final int offset = QtPDOMProperty.access$0();

        private Field(int sizeof) {
            offsetInitializer = offsetInitializer + sizeof;
        }

        public long getRecord(long baseRec) {
            return baseRec + (long)this.offset;
        }
    }
}

