/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.arduino.core.internal.board;

import java.nio.file.Path;
import java.util.List;
import java.util.Properties;
import org.eclipse.cdt.arduino.core.internal.Activator;
import org.eclipse.cdt.arduino.core.internal.ArduinoPreferences;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoPackage;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoToolSystem;
import org.eclipse.cdt.arduino.core.internal.build.ArduinoBuildConfiguration;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ArduinoTool {
    private String name;
    private String version;
    private List<ArduinoToolSystem> systems;
    private transient ArduinoPackage pkg;

    public void setOwner(ArduinoPackage pkg) {
        this.pkg = pkg;
        for (ArduinoToolSystem system : this.systems) {
            system.setOwner(this);
        }
    }

    public ArduinoPackage getPackage() {
        return this.pkg;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public List<ArduinoToolSystem> getSystems() {
        return this.systems;
    }

    public Path getInstallPath() {
        return ArduinoPreferences.getArduinoHome().resolve("tools").resolve(this.pkg.getName()).resolve(this.name).resolve(this.version);
    }

    public boolean isInstalled() {
        return this.getInstallPath().toFile().exists();
    }

    public IStatus install(IProgressMonitor monitor) {
        if (this.isInstalled()) {
            return Status.OK_STATUS;
        }
        for (ArduinoToolSystem system : this.systems) {
            if (!system.isApplicable()) continue;
            return system.install(monitor);
        }
        return new Status(4, Activator.getId(), "No valid system found for " + this.name);
    }

    public Properties getToolProperties() {
        Properties properties = new Properties();
        properties.put("runtime.tools." + this.name + ".path", ArduinoBuildConfiguration.pathString(this.getInstallPath()));
        properties.put("runtime.tools." + this.name + '-' + this.version + ".path", ArduinoBuildConfiguration.pathString(this.getInstallPath()));
        return properties;
    }
}

