/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.arduino.core.internal.build;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.arduino.core.internal.Activator;
import org.eclipse.cdt.arduino.core.internal.build.ArduinoBuildConfiguration;
import org.eclipse.cdt.arduino.core.internal.console.ArduinoConsoleService;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ArduinoBuilder
extends IncrementalProjectBuilder {
    public static final String ID = String.valueOf(Activator.getId()) + ".arduinoBuilder";

    protected IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        IProject project = this.getProject();
        try {
            project.deleteMarkers("org.eclipse.cdt.core.problem", true, 2);
            ArduinoConsoleService consoleService = Activator.getConsoleService();
            consoleService.writeOutput(String.format("\nBuilding %s\n", project.getName()));
            ArduinoBuildConfiguration config = (ArduinoBuildConfiguration)this.getBuildConfig().getAdapter(ArduinoBuildConfiguration.class);
            config.generateMakeFile(monitor);
            ProcessBuilder processBuilder = new ProcessBuilder(new String[0]).command(config.getBuildCommand()).directory(config.getBuildDirectory());
            config.setEnvironment(processBuilder.environment());
            Process process = processBuilder.start();
            consoleService.monitor(process, config.getBuildConsoleParsers(), config.getBuildFolder());
            if (process.exitValue() == 0) {
                this.showSizes(config, consoleService);
            }
            config.getBuildFolder().refreshLocal(2, monitor);
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, Activator.getId(), "Build error", (Throwable)e));
        }
        return new IProject[]{project};
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        try {
            IProject project = this.getProject();
            project.deleteMarkers("org.eclipse.cdt.core.problem", true, 2);
            ArduinoConsoleService consoleService = Activator.getConsoleService();
            consoleService.writeOutput(String.format("\nCleaning %s\n", project.getName()));
            ArduinoBuildConfiguration config = (ArduinoBuildConfiguration)this.getBuildConfig().getAdapter(ArduinoBuildConfiguration.class);
            ProcessBuilder processBuilder = new ProcessBuilder(new String[0]).command(config.getCleanCommand()).directory(config.getBuildDirectory());
            config.setEnvironment(processBuilder.environment());
            Process process = processBuilder.start();
            consoleService.monitor(process, config.getBuildConsoleParsers(), config.getBuildFolder());
            config.getBuildFolder().refreshLocal(2, monitor);
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, Activator.getId(), "Build error", (Throwable)e));
        }
    }

    private void showSizes(ArduinoBuildConfiguration config, ArduinoConsoleService console) throws CoreException {
        try {
            Pattern dataSizePattern;
            int codeSize = -1;
            int dataSize = -1;
            String codeSizeRegex = config.getCodeSizeRegex();
            Pattern codeSizePattern = codeSizeRegex != null ? Pattern.compile(codeSizeRegex) : null;
            String dataSizeRegex = config.getDataSizeRegex();
            Pattern pattern = dataSizePattern = dataSizeRegex != null ? Pattern.compile(dataSizeRegex) : null;
            if (codeSizePattern == null && dataSizePattern == null) {
                return;
            }
            int maxCodeSize = config.getMaxCodeSize();
            int maxDataSize = config.getMaxDataSize();
            ProcessBuilder processBuilder = new ProcessBuilder(new String[0]).command(config.getSizeCommand()).directory(config.getBuildDirectory()).redirectErrorStream(true);
            config.setEnvironment(processBuilder.environment());
            Process process = processBuilder.start();
            Throwable throwable = null;
            Object var14_16 = null;
            try (BufferedReader processOut = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line = processOut.readLine();
                while (line != null) {
                    Matcher matcher;
                    if (codeSizePattern != null && (matcher = codeSizePattern.matcher(line)).matches()) {
                        codeSize += Integer.parseInt(matcher.group(1));
                    }
                    if (dataSizePattern != null && (matcher = dataSizePattern.matcher(line)).matches()) {
                        dataSize += Integer.parseInt(matcher.group(1));
                    }
                    line = processOut.readLine();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            console.writeOutput("Program store usage: " + codeSize);
            if (maxCodeSize > 0) {
                console.writeOutput(" of maximum " + maxCodeSize);
            }
            console.writeOutput(" bytes\n");
            if (maxDataSize >= 0) {
                console.writeOutput("Initial RAM usage: " + dataSize);
                if (maxCodeSize > 0) {
                    console.writeOutput(" of maximum " + maxDataSize);
                }
                console.writeOutput(" bytes\n");
            }
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, Activator.getId(), "Checking sizes", (Throwable)e));
        }
    }
}

