/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.arduino.ui.internal.preferences;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.cdt.arduino.core.internal.ArduinoPreferences;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoBoard;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoManager;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoPlatform;
import org.eclipse.cdt.arduino.ui.internal.Activator;
import org.eclipse.cdt.arduino.ui.internal.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class ArduinoBoardsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Table table;
    private Button installButton;
    private Set<ArduinoBoard> toInstall = new HashSet<ArduinoBoard>();

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite control = new Composite(parent, 0);
        control.setLayout((Layout)new GridLayout());
        Text desc = new Text(control, 72);
        GridData layoutData = new GridData(4, 4, true, false);
        layoutData.widthHint = 500;
        desc.setLayoutData((Object)layoutData);
        desc.setBackground(parent.getBackground());
        desc.setText(Messages.ArduinoBoardsPreferencePage_desc);
        Composite comp = new Composite(control, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite tableComp = new Composite(comp, 0);
        tableComp.setLayoutData((Object)new GridData(4, 4, true, true));
        this.table = new Table(tableComp, 68100);
        this.table.setLayoutData((Object)new GridData(4, 4, true, true));
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        TableColumn packageColumn = new TableColumn(this.table, 16384);
        packageColumn.setText("Board");
        TableColumn platformColumn = new TableColumn(this.table, 16384);
        platformColumn.setText("Platform");
        TableColumn installedColumn = new TableColumn(this.table, 16384);
        installedColumn.setText("Installed");
        TableColumnLayout tableLayout = new TableColumnLayout();
        tableLayout.setColumnData((Widget)packageColumn, (ColumnLayoutData)new ColumnWeightData(5, 150, true));
        tableLayout.setColumnData((Widget)platformColumn, (ColumnLayoutData)new ColumnWeightData(5, 150, true));
        tableLayout.setColumnData((Widget)installedColumn, (ColumnLayoutData)new ColumnWeightData(2, 75, true));
        tableComp.setLayout((Layout)tableLayout);
        this.table.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ArduinoBoardsPreferencePage.this.updateButtons();
            }
        });
        Composite buttonComp = new Composite(comp, 0);
        buttonComp.setLayout((Layout)new GridLayout());
        buttonComp.setLayoutData((Object)new GridData(1, 1, false, false));
        this.installButton = new Button(buttonComp, 8);
        this.installButton.setLayoutData((Object)new GridData(4, 1, true, false));
        this.installButton.setText("Install");
        this.installButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TableItem[] tableItemArray = ArduinoBoardsPreferencePage.this.table.getSelection();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    ArduinoBoard board = (ArduinoBoard)item.getData();
                    ArduinoBoardsPreferencePage.this.toInstall.add(board);
                    item.setText(2, "selected");
                    ArduinoBoardsPreferencePage.this.updateButtons();
                    ++n2;
                }
            }
        });
        this.updateTable();
        this.updateButtons();
        return control;
    }

    private void updateTable() {
        if (this.table == null || this.table.isDisposed()) {
            return;
        }
        this.table.removeAll();
        try {
            List boards = ArduinoManager.instance.getBoards();
            Collections.sort(boards, new Comparator<ArduinoBoard>(){

                @Override
                public int compare(ArduinoBoard o1, ArduinoBoard o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            for (ArduinoBoard board : boards) {
                TableItem item = new TableItem(this.table, 0);
                item.setData((Object)board);
                item.setText(0, board.getName());
                item.setText(1, board.getPlatform().getName());
                String msg = this.toInstall.contains(board) ? "selected" : (board.getPlatform().isInstalled() ? "yes" : "no");
                item.setText(2, msg);
            }
        }
        catch (CoreException e) {
            Activator.log((Exception)((Object)e));
        }
    }

    private void updateButtons() {
        if (this.table == null || this.table.isDisposed()) {
            return;
        }
        boolean enable = false;
        TableItem[] tableItemArray = this.table.getSelection();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            ArduinoPlatform platform;
            TableItem item = tableItemArray[n2];
            ArduinoBoard board = (ArduinoBoard)item.getData();
            if (!this.toInstall.contains(board) && !(platform = board.getPlatform()).isInstalled()) {
                enable = true;
            }
            ++n2;
        }
        this.installButton.setEnabled(enable);
    }

    public boolean performOk() {
        File acceptedFile = ArduinoPreferences.getArduinoHome().resolve(".accepted").toFile();
        if (!acceptedFile.exists()) {
            String message = "Do you accept the licenses for the Arduino SDK and libraries? Information on the licenses can be found at arduino.cc web site.";
            MessageDialog dialog = new MessageDialog(this.getShell(), "Arduino License", null, message, 3, new String[]{"Accept", "Decline"}, 0);
            int rc = dialog.open();
            if (rc == 0) {
                try {
                    acceptedFile.createNewFile();
                }
                catch (IOException e) {
                    Activator.log(e);
                }
            } else {
                return false;
            }
        }
        new Job("Installing Arduino Board Platforms"){

            protected IStatus run(IProgressMonitor monitor) {
                HashSet<ArduinoPlatform> platforms = new HashSet<ArduinoPlatform>();
                for (ArduinoBoard board : ArduinoBoardsPreferencePage.this.toInstall) {
                    platforms.add(board.getPlatform());
                }
                MultiStatus status = new MultiStatus("org.eclipse.cdt.arduino.ui", 0, "Installing Arduino Board Platforms", null);
                for (ArduinoPlatform platform : platforms) {
                    status.add(platform.install(monitor));
                }
                ArduinoBoardsPreferencePage.this.toInstall.clear();
                if (ArduinoBoardsPreferencePage.this.table != null && !ArduinoBoardsPreferencePage.this.table.isDisposed()) {
                    ArduinoBoardsPreferencePage.this.table.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            ArduinoBoardsPreferencePage.this.updateTable();
                        }
                    });
                }
                return status;
            }
        }.schedule();
        return true;
    }
}

