/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.arduino.ui.internal.project;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoLibrary;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoManager;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoPlatform;
import org.eclipse.cdt.arduino.core.internal.board.LibraryIndex;
import org.eclipse.cdt.arduino.core.internal.build.ArduinoBuildConfiguration;
import org.eclipse.cdt.arduino.ui.internal.Activator;
import org.eclipse.cdt.arduino.ui.internal.Messages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.dialogs.PropertyPage;

public class LibrariesPropertyPage
extends PropertyPage {
    private FilteredTree filteredTree;

    protected Control createContents(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout());
        Text desc = new Text(comp, 72);
        GridData layoutData = new GridData(16384, 4, true, false);
        layoutData.widthHint = 500;
        desc.setLayoutData((Object)layoutData);
        desc.setBackground(parent.getBackground());
        desc.setText(Messages.LibrariesPropertyPage_desc);
        this.filteredTree = new FilteredTree(comp, 2848, new PatternFilter(){

            protected boolean isLeafMatch(Viewer viewer, Object element) {
                if (element instanceof String) {
                    return this.wordMatches((String)element);
                }
                if (element instanceof ArduinoLibrary) {
                    ArduinoLibrary lib = (ArduinoLibrary)element;
                    return this.wordMatches(lib.getName()) || this.wordMatches(lib.getSentence()) || this.wordMatches(lib.getParagraph());
                }
                return false;
            }
        }, true){

            protected TreeViewer doCreateTreeViewer(Composite parent, int style) {
                return new ContainerCheckedTreeViewer(parent, style);
            }
        };
        this.filteredTree.setLayoutData((Object)new GridData(4, 4, true, true));
        ContainerCheckedTreeViewer viewer = (ContainerCheckedTreeViewer)this.filteredTree.getViewer();
        Tree tree = viewer.getTree();
        tree.setHeaderVisible(true);
        TreeColumn column1 = new TreeColumn(tree, 16384);
        column1.setText("Name");
        column1.setWidth(200);
        TreeColumn column2 = new TreeColumn(tree, 16384);
        column2.setText("Description");
        column2.setWidth(200);
        viewer.setContentProvider((IContentProvider)new ContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        try {
            viewer.setInput((Object)ArduinoManager.instance.getLibraryIndex());
            IProject project = (IProject)this.getElement().getAdapter(IProject.class);
            Collection libraries = ArduinoManager.instance.getLibraries(project);
            for (ArduinoLibrary lib : libraries) {
                viewer.setChecked((Object)lib, true);
            }
        }
        catch (CoreException e) {
            Activator.log((Exception)((Object)e));
        }
        return comp;
    }

    private IProject getProject() {
        return (IProject)this.getElement().getAdapter(IProject.class);
    }

    private ArduinoPlatform getPlatform() throws CoreException {
        return ((ArduinoBuildConfiguration)this.getProject().getActiveBuildConfig().getAdapter(ArduinoBuildConfiguration.class)).getBoard().getPlatform();
    }

    public boolean performOk() {
        ArrayList<ArduinoLibrary> libs = new ArrayList<ArduinoLibrary>();
        TreeItem[] treeItemArray = this.filteredTree.getViewer().getTree().getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem categoryItem = treeItemArray[n2];
            TreeItem[] treeItemArray2 = categoryItem.getItems();
            int n3 = treeItemArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                TreeItem libItem = treeItemArray2[n4];
                ArduinoLibrary lib = (ArduinoLibrary)libItem.getData();
                if (libItem.getChecked()) {
                    libs.add(lib);
                }
                ++n4;
            }
            ++n2;
        }
        try {
            ArduinoManager.instance.setLibraries(this.getProject(), libs);
        }
        catch (CoreException e) {
            Activator.log((Exception)((Object)e));
        }
        return true;
    }

    private class ContentProvider
    implements ITreeContentProvider {
        private LibraryIndex index;

        private ContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.index = (LibraryIndex)newInput;
        }

        public void dispose() {
        }

        public boolean hasChildren(Object element) {
            if (element instanceof LibraryIndex) {
                return true;
            }
            if (element instanceof String) {
                return true;
            }
            if (element instanceof ArduinoLibrary) {
                return false;
            }
            return false;
        }

        public Object getParent(Object element) {
            if (element instanceof ArduinoLibrary) {
                ArduinoLibrary lib = (ArduinoLibrary)element;
                String category = lib.getCategory();
                return category != null ? category : "Uncategorized";
            }
            if (element instanceof String || element instanceof ArduinoPlatform) {
                return this.index;
            }
            return null;
        }

        public Object[] getElements(Object inputElement) {
            HashSet<String> categories = new HashSet<String>();
            categories.addAll(((LibraryIndex)inputElement).getCategories());
            try {
                for (ArduinoLibrary lib : LibrariesPropertyPage.this.getPlatform().getLibraries()) {
                    String category = lib.getCategory();
                    categories.add(category != null ? category : "Uncategorized");
                }
            }
            catch (CoreException e) {
                Activator.log((Exception)((Object)e));
            }
            return categories.toArray();
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof String) {
                String category = (String)parentElement;
                ArrayList<ArduinoLibrary> libs = new ArrayList<ArduinoLibrary>();
                libs.addAll(this.index.getLibraries(category));
                try {
                    for (ArduinoLibrary lib : LibrariesPropertyPage.this.getPlatform().getLibraries()) {
                        String cat = lib.getCategory();
                        if (cat != null) {
                            if (!cat.equals(category)) continue;
                            libs.add(lib);
                            continue;
                        }
                        if (!category.equals("Uncategorized")) continue;
                        libs.add(lib);
                    }
                }
                catch (CoreException e) {
                    Activator.log((Exception)((Object)e));
                }
                return libs.toArray();
            }
            return new Object[0];
        }
    }

    private static class LabelProvider
    extends BaseLabelProvider
    implements ITableLabelProvider {
        private LabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof String) {
                return columnIndex == 0 ? (String)element : null;
            }
            if (element instanceof ArduinoLibrary) {
                switch (columnIndex) {
                    case 0: {
                        return ((ArduinoLibrary)element).getName();
                    }
                    case 1: {
                        return ((ArduinoLibrary)element).getSentence();
                    }
                }
                return null;
            }
            return null;
        }
    }
}

