/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.arduino.core.internal;

import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.cdt.arduino.core.internal.Activator;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;

public class ArduinoPreferences {
    private static final String ARDUINO_HOME = "arduinoHome";
    private static final String BOARD_URLS = "boardUrls";
    private static final String defaultHome = Paths.get(System.getProperty("user.home"), ".arduinocdt").toString();
    private static final String defaultBoardUrls = "http://downloads.arduino.cc/packages/package_index.json\nhttp://arduino.esp8266.com/stable/package_esp8266com_index.json\nhttps://adafruit.github.io/arduino-board-index/package_adafruit_index.json";

    private static IEclipsePreferences getPrefs() {
        return InstanceScope.INSTANCE.getNode(Activator.getId());
    }

    public static Path getArduinoHome() {
        return Paths.get(ArduinoPreferences.getPrefs().get(ARDUINO_HOME, defaultHome), new String[0]);
    }

    public static String getBoardUrls() {
        return ArduinoPreferences.getPrefs().get(BOARD_URLS, defaultBoardUrls);
    }

    public static void setBoardUrls(String boardUrls) {
        IEclipsePreferences prefs = ArduinoPreferences.getPrefs();
        prefs.put(BOARD_URLS, boardUrls);
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            Activator.log((Exception)((Object)e));
        }
    }

    public static String getDefaultBoardUrls() {
        return defaultBoardUrls;
    }
}

