/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.arduino.core.internal.launch;

import java.io.IOException;
import org.eclipse.cdt.arduino.core.internal.Activator;
import org.eclipse.cdt.arduino.core.internal.Messages;
import org.eclipse.cdt.arduino.core.internal.build.ArduinoBuildConfiguration;
import org.eclipse.cdt.arduino.core.internal.launch.ArduinoLaunch;
import org.eclipse.cdt.arduino.core.internal.remote.ArduinoRemoteConnection;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteConnectionType;
import org.eclipse.remote.core.IRemoteServicesManager;

public class ArduinoLaunchConfigurationDelegate
extends LaunchConfigurationDelegate {
    public static final String TYPE_ID = "org.eclipse.cdt.arduino.core.launchConfigurationType";
    public static final String CONNECTION_NAME = String.valueOf(Activator.getId()) + ".connectionName";

    private static IRemoteConnection getTarget(ILaunchConfiguration configuration) throws CoreException {
        IRemoteServicesManager remoteManager = Activator.getService(IRemoteServicesManager.class);
        IRemoteConnectionType connectionType = remoteManager.getConnectionType("org.eclipse.cdt.arduino.core.connectionType");
        String connectionName = configuration.getAttribute(CONNECTION_NAME, "");
        return connectionType.getConnection(connectionName);
    }

    public ILaunch getLaunch(ILaunchConfiguration configuration, String mode) throws CoreException {
        return new ArduinoLaunch(configuration, mode, null, ArduinoLaunchConfigurationDelegate.getTarget(configuration));
    }

    public boolean buildForLaunch(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        IRemoteConnection target = ArduinoLaunchConfigurationDelegate.getTarget(configuration);
        if (target != null) {
            ArduinoRemoteConnection arduinoTarget = (ArduinoRemoteConnection)target.getService(ArduinoRemoteConnection.class);
            IProject project = configuration.getMappedResources()[0].getProject();
            ArduinoBuildConfiguration arduinoConfig = ArduinoBuildConfiguration.getConfig(project, arduinoTarget, monitor);
            arduinoConfig.setActive(monitor);
        }
        return super.buildForLaunch(configuration, mode, monitor);
    }

    protected IProject[] getBuildOrder(ILaunchConfiguration configuration, String mode) throws CoreException {
        IProject project = configuration.getMappedResources()[0].getProject();
        return new IProject[]{project};
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        try {
            IRemoteConnection target = ArduinoLaunchConfigurationDelegate.getTarget(configuration);
            if (target == null) {
                throw new CoreException((IStatus)new Status(4, Activator.getId(), Messages.ArduinoLaunchConfigurationDelegate_2));
            }
            ArduinoRemoteConnection arduinoTarget = (ArduinoRemoteConnection)target.getService(ArduinoRemoteConnection.class);
            IProject project = (IProject)configuration.getMappedResources()[0];
            ArduinoBuildConfiguration arduinoConfig = ArduinoBuildConfiguration.getConfig(project, arduinoTarget, monitor);
            String[] uploadCmd = arduinoConfig.getUploadCommand(arduinoTarget.getPortName());
            StringBuffer cmdStr = new StringBuffer(uploadCmd[0]);
            int i = 1;
            while (i < uploadCmd.length) {
                cmdStr.append(' ');
                cmdStr.append(uploadCmd[i]);
                ++i;
            }
            ((ArduinoLaunch)launch).start();
            ProcessBuilder processBuilder = new ProcessBuilder(uploadCmd).directory(arduinoConfig.getBuildDirectory());
            arduinoConfig.setEnvironment(processBuilder.environment());
            Process process = processBuilder.start();
            DebugPlugin.newProcess((ILaunch)launch, (Process)process, (String)cmdStr.toString());
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, Activator.getId(), e.getLocalizedMessage(), (Throwable)e));
        }
    }
}

