/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.arduino.ui.internal.preferences;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.cdt.arduino.core.internal.ArduinoPreferences;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoManager;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoPackage;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoPlatform;
import org.eclipse.cdt.arduino.core.internal.board.PackageIndex;
import org.eclipse.cdt.arduino.ui.internal.Activator;
import org.eclipse.cdt.arduino.ui.internal.Messages;
import org.eclipse.cdt.arduino.ui.internal.preferences.PlatformDetailsDialog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class ArduinoPlatformsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Table table;
    private Button installButton;
    private Button uninstallButton;
    private Button detailButton;
    private Collection<ArduinoPlatform> toInstall = new HashSet<ArduinoPlatform>();
    private Collection<ArduinoPlatform> toUninstall = new HashSet<ArduinoPlatform>();
    private static ArduinoManager manager = Activator.getService(ArduinoManager.class);

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite control = new Composite(parent, 0);
        control.setLayout((Layout)new GridLayout());
        Text desc = new Text(control, 72);
        GridData layoutData = new GridData(4, 4, true, false);
        layoutData.widthHint = 500;
        desc.setLayoutData((Object)layoutData);
        desc.setBackground(parent.getBackground());
        desc.setText(Messages.ArduinoPlatformsPreferencePage_0);
        Composite comp = new Composite(control, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite tableComp = new Composite(comp, 0);
        tableComp.setLayoutData((Object)new GridData(4, 4, true, true));
        this.table = new Table(tableComp, 68100);
        this.table.setLayoutData((Object)new GridData(4, 4, true, true));
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        TableColumn platformColumn = new TableColumn(this.table, 16384);
        platformColumn.setText(Messages.ArduinoPlatformsPreferencePage_1);
        TableColumn installedColumn = new TableColumn(this.table, 16384);
        installedColumn.setText(Messages.ArduinoPlatformsPreferencePage_2);
        TableColumn availableColumn = new TableColumn(this.table, 16384);
        availableColumn.setText(Messages.ArduinoPlatformsPreferencePage_3);
        TableColumnLayout tableLayout = new TableColumnLayout();
        tableLayout.setColumnData((Widget)platformColumn, (ColumnLayoutData)new ColumnWeightData(5, 150, true));
        tableLayout.setColumnData((Widget)installedColumn, (ColumnLayoutData)new ColumnWeightData(2, 75, true));
        tableLayout.setColumnData((Widget)availableColumn, (ColumnLayoutData)new ColumnWeightData(2, 75, true));
        tableComp.setLayout((Layout)tableLayout);
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] selection = ArduinoPlatformsPreferencePage.this.table.getSelection();
                if (selection.length > 0) {
                    TableItem item = selection[0];
                    ArduinoPlatformsPreferencePage.this.detailButton.setEnabled(true);
                    ArduinoPlatform aplat = (ArduinoPlatform)item.getData();
                    ArduinoPlatform iplat = (ArduinoPlatform)aplat.getPackage().getInstalledPlatforms().get(aplat.getName());
                    if (iplat == null) {
                        ArduinoPlatformsPreferencePage.this.installButton.setEnabled(true);
                        ArduinoPlatformsPreferencePage.this.installButton.setText(Messages.ArduinoPlatformsPreferencePage_4);
                        ArduinoPlatformsPreferencePage.this.uninstallButton.setEnabled(false);
                    } else {
                        ArduinoPlatformsPreferencePage.this.installButton.setText(Messages.ArduinoPlatformsPreferencePage_5);
                        if (!aplat.getVersion().equals(iplat.getVersion())) {
                            ArduinoPlatformsPreferencePage.this.installButton.setEnabled(true);
                        } else {
                            ArduinoPlatformsPreferencePage.this.installButton.setEnabled(false);
                        }
                        ArduinoPlatformsPreferencePage.this.uninstallButton.setEnabled(true);
                    }
                } else {
                    ArduinoPlatformsPreferencePage.this.detailButton.setEnabled(false);
                    ArduinoPlatformsPreferencePage.this.installButton.setEnabled(false);
                    ArduinoPlatformsPreferencePage.this.uninstallButton.setEnabled(false);
                }
            }
        });
        Composite buttonComp = new Composite(comp, 0);
        buttonComp.setLayout((Layout)new GridLayout());
        buttonComp.setLayoutData((Object)new GridData(1, 1, false, false));
        this.detailButton = new Button(buttonComp, 8);
        this.detailButton.setLayoutData((Object)new GridData(4, 1, true, false));
        this.detailButton.setText(Messages.ArduinoPlatformsPreferencePage_6);
        this.detailButton.setEnabled(false);
        this.detailButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] selection = ArduinoPlatformsPreferencePage.this.table.getSelection();
                ArduinoPlatform platform = (ArduinoPlatform)selection[0].getData();
                PlatformDetailsDialog dialog = new PlatformDetailsDialog(ArduinoPlatformsPreferencePage.this.getShell(), platform);
                dialog.open();
            }
        });
        this.installButton = new Button(buttonComp, 8);
        this.installButton.setLayoutData((Object)new GridData(4, 1, true, false));
        this.installButton.setText(Messages.ArduinoPlatformsPreferencePage_7);
        this.installButton.setEnabled(false);
        this.installButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] selection = ArduinoPlatformsPreferencePage.this.table.getSelection();
                if (selection.length > 0) {
                    TableItem item = selection[0];
                    ArduinoPlatformsPreferencePage.this.toInstall.add((ArduinoPlatform)item.getData());
                    item.setImage(Activator.getDefault().getImageRegistry().get("org.eclipse.cdt.arduino.ui.add"));
                }
            }
        });
        this.uninstallButton = new Button(buttonComp, 8);
        this.uninstallButton.setLayoutData((Object)new GridData(4, 1, true, false));
        this.uninstallButton.setText(Messages.ArduinoPlatformsPreferencePage_8);
        this.uninstallButton.setEnabled(false);
        this.uninstallButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] selection = ArduinoPlatformsPreferencePage.this.table.getSelection();
                if (selection.length > 0) {
                    TableItem item = selection[0];
                    ArduinoPlatformsPreferencePage.this.toUninstall.add((ArduinoPlatform)item.getData());
                    item.setImage(Activator.getDefault().getImageRegistry().get("org.eclipse.cdt.arduino.ui.delete"));
                }
            }
        });
        this.populateTable();
        return control;
    }

    private void populateTable() {
        this.table.removeAll();
        for (PackageIndex packageIndex : manager.getPackageIndices()) {
            for (ArduinoPackage pkg : packageIndex.getPackages()) {
                Map available = pkg.getAvailablePlatforms();
                Map installed = pkg.getInstalledPlatforms();
                ArrayList names = new ArrayList(available.keySet());
                Collections.sort(names);
                for (String name : names) {
                    TableItem item = new TableItem(this.table, 0);
                    item.setText(0, name);
                    ArduinoPlatform iplat = (ArduinoPlatform)installed.get(name);
                    item.setText(1, iplat != null ? iplat.getVersion() : "---");
                    ArduinoPlatform aplat = (ArduinoPlatform)available.get(name);
                    item.setText(2, aplat.getVersion());
                    item.setData((Object)aplat);
                }
            }
        }
    }

    public boolean performOk() {
        File acceptedFile = ArduinoPreferences.getArduinoHome().resolve(".accepted").toFile();
        if (!acceptedFile.exists()) {
            String message = String.valueOf(Messages.ArduinoPlatformsPreferencePage_9) + Messages.ArduinoPlatformsPreferencePage_10;
            MessageDialog dialog = new MessageDialog(this.getShell(), Messages.ArduinoPlatformsPreferencePage_11, null, message, 3, new String[]{Messages.ArduinoPlatformsPreferencePage_12, Messages.ArduinoPlatformsPreferencePage_13}, 0);
            int rc = dialog.open();
            if (rc == 0) {
                try {
                    acceptedFile.createNewFile();
                }
                catch (IOException e) {
                    Activator.log(e);
                }
            } else {
                return false;
            }
        }
        new Job(Messages.ArduinoPlatformsPreferencePage_14){

            protected IStatus run(IProgressMonitor monitor) {
                MultiStatus status = new MultiStatus("org.eclipse.cdt.arduino.ui", 0, Messages.ArduinoPlatformsPreferencePage_15, null);
                for (ArduinoPlatform platform : ArduinoPlatformsPreferencePage.this.toUninstall) {
                    status.add(platform.uninstall(monitor));
                }
                ArduinoPlatformsPreferencePage.this.toUninstall.clear();
                for (ArduinoPlatform platform : ArduinoPlatformsPreferencePage.this.toInstall) {
                    status.add(platform.install(monitor));
                }
                ArduinoPlatformsPreferencePage.this.toInstall.clear();
                if (ArduinoPlatformsPreferencePage.this.table != null && !ArduinoPlatformsPreferencePage.this.table.isDisposed()) {
                    ArduinoPlatformsPreferencePage.this.table.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            ArduinoPlatformsPreferencePage.this.populateTable();
                        }
                    });
                }
                return status;
            }
        }.schedule();
        return true;
    }
}

