/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.autotools.core;

import java.lang.reflect.Method;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.IErrorParser;
import org.eclipse.cdt.core.ProblemMarkerInfo;
import org.eclipse.cdt.internal.autotools.core.AutotoolsProblemMarkerInfo;
import org.eclipse.cdt.internal.autotools.core.ErrorParserManager;
import org.eclipse.cdt.internal.autotools.core.MarkerGenerator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class ErrorParser
extends MarkerGenerator
implements IErrorParser {
    public static final String ID = "org.eclipse.cdt.autotools.core.errorParser";
    private Pattern pkgconfigError = Pattern.compile(".*?(configure:\\s+error:\\s+Package requirements\\s+\\((.*?)\\)\\s+were not met).*");
    private Pattern genconfigError = Pattern.compile(".*?configure:\\s+error:\\s+(.*)");
    private Pattern checkingFail = Pattern.compile("checking for (.*)\\.\\.\\. no");
    private Pattern changingConfigDirectory = Pattern.compile("Configuring in (.*)");
    private IPath buildDir;
    private IPath sourcePath;
    private IProject project;

    public ErrorParser() {
    }

    public ErrorParser(IPath sourcePath, IPath buildPath) {
        this.buildDir = buildPath;
        this.sourcePath = sourcePath;
    }

    public boolean processLine(String line, org.eclipse.cdt.core.ErrorParserManager eoParser) {
        AutotoolsProblemMarkerInfo marker;
        if (this.project == null) {
            this.project = eoParser.getProject();
        }
        if (this.buildDir == null) {
            this.buildDir = new Path(eoParser.getWorkingDirectoryURI().getPath());
        }
        if (this.sourcePath == null) {
            this.sourcePath = eoParser.getProject().getLocation();
        }
        if ((marker = this.processLine(line)) != null) {
            Method method = eoParser.getClass().getMethod("addProblemMarker", ProblemMarkerInfo.class);
            try {
                method.invoke((Object)eoParser, marker);
                return true;
            }
            catch (Exception e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (SecurityException e2) {
                    return false;
                }
                catch (NoSuchMethodException e3) {
                    return false;
                }
            }
        }
        return false;
    }

    public boolean processLine(String line, ErrorParserManager eoParser) {
        AutotoolsProblemMarkerInfo marker;
        if (this.project == null) {
            this.project = eoParser.getProject();
        }
        if ((marker = this.processLine(line)) != null) {
            eoParser.addProblemMarker(marker);
            return true;
        }
        return false;
    }

    public AutotoolsProblemMarkerInfo processLine(String line) {
        AutotoolsProblemMarkerInfo.Type type;
        Matcher m = this.changingConfigDirectory.matcher(line);
        if (m.matches()) {
            this.buildDir = this.buildDir.append(m.group(1));
            this.sourcePath = this.sourcePath.append(m.group(1));
            return null;
        }
        m = this.pkgconfigError.matcher(line);
        if (m.matches()) {
            return new AutotoolsProblemMarkerInfo((IResource)this.getProject(), -1, m.group(1), 3, null, null, m.group(2), AutotoolsProblemMarkerInfo.Type.PACKAGE);
        }
        m = this.genconfigError.matcher(line);
        if (m.matches()) {
            return new AutotoolsProblemMarkerInfo((IResource)this.getProject(), -1, m.group(1), 3, null, AutotoolsProblemMarkerInfo.Type.GENERIC);
        }
        m = this.checkingFail.matcher(line);
        if (m.matches() && (type = this.getCheckType(m.group(1))) != null) {
            return new AutotoolsProblemMarkerInfo((IResource)this.getProject(), "Missing " + (Object)((Object)type) + " " + m.group(1), 0, m.group(1), type);
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    private AutotoolsProblemMarkerInfo.Type getCheckType(String name) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [23[DOLOOP]], but top level block is 31[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private int getErrorConfigLineNumber(String name) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 16[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public IProject getProject() {
        return this.project;
    }
}

