/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.pty;

import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.cdt.utils.pty.PTY;
import org.eclipse.core.runtime.Platform;

public class PTYOutputStream
extends OutputStream {
    private static final byte EOT = 4;
    PTY.MasterFD master;

    static {
        System.loadLibrary("pty");
    }

    public PTYOutputStream(PTY.MasterFD fd) {
        this.master = fd;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        byte[] tmpBuf = new byte[len];
        System.arraycopy(b, off, tmpBuf, 0, len);
        this.write0(this.master.getFD(), tmpBuf, len);
    }

    @Override
    public void write(int b) throws IOException {
        byte[] buf = new byte[]{(byte)b};
        this.write(buf, 0, 1);
    }

    @Override
    public void close() throws IOException {
        int status;
        if (this.master.getFD() == -1) {
            return;
        }
        if (!"win32".equals(Platform.getOS())) {
            this.write(4);
        }
        if ((status = this.close0(this.master.getFD())) == -1) {
            throw new IOException("close error");
        }
        this.master.setFD(-1);
    }

    protected void finalize() throws IOException {
        this.close();
    }

    private native int write0(int var1, byte[] var2, int var3) throws IOException;

    private native int close0(int var1) throws IOException;
}

