/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.qt.ui.assist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTEqualsInitializer;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeSelector;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameter;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPParameter;
import org.eclipse.cdt.internal.ui.text.contentassist.CCompletionProposal;
import org.eclipse.cdt.qt.core.index.IQMethod;
import org.eclipse.cdt.qt.core.index.IQObject;
import org.eclipse.cdt.qt.core.index.IQProperty;
import org.eclipse.cdt.qt.core.index.QtIndex;
import org.eclipse.cdt.qt.ui.QtUIPlugin;
import org.eclipse.cdt.ui.text.contentassist.ICEditorContentAssistInvocationContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.contentassist.ICompletionProposal;

public class QPropertyAttributeProposal {
    private final int relevance;
    private final String identifier;
    private final String display;

    public QPropertyAttributeProposal(String identifier, int relevance) {
        this(identifier, identifier, relevance);
    }

    public ICompletionProposal createProposal(String prefix, int offset) {
        int prefixLen = prefix == null ? 0 : prefix.length();
        String disp = this.identifier.equals(this.display) ? this.display : String.valueOf(this.identifier) + " - " + this.display;
        return new CCompletionProposal(this.identifier.substring(prefixLen), offset, prefixLen, QtUIPlugin.getQtLogo(), disp, this.relevance);
    }

    private QPropertyAttributeProposal(String identifier, String display, int relevance) {
        this.identifier = identifier;
        this.display = display;
        this.relevance = relevance;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public static Collection<QPropertyAttributeProposal> buildProposals(IQProperty.Attribute attr, ICEditorContentAssistInvocationContext context, IType type, String name) {
        switch (attr) {
            case DESIGNABLE: 
            case SCRIPTABLE: 
            case STORED: 
            case USER: {
                return Arrays.asList(new QPropertyAttributeProposal("true", 2011), new QPropertyAttributeProposal("false", 2010));
            }
            case READ: 
            case WRITE: 
            case RESET: {
                return QPropertyAttributeProposal.getMethodProposals(context, QPropertyAttributeProposal.get(attr, type, name));
            }
            case NOTIFY: {
                return QPropertyAttributeProposal.getSignalProposals(context, QPropertyAttributeProposal.get(attr, type, name));
            }
        }
        return Collections.emptyList();
    }

    private static Collection<QPropertyAttributeProposal> getMethodProposals(ICEditorContentAssistInvocationContext context, IMethodAttribute methodAttribute) {
        ICPPClassType cls = QPropertyAttributeProposal.getEnclosingClassDefinition(context);
        if (cls == null) {
            return Collections.emptyList();
        }
        ICPPMethod[] methods = cls.getMethods();
        ArrayList<ICPPMethod> filtered = new ArrayList<ICPPMethod>(methods.length);
        ICPPMethod[] iCPPMethodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPMethod method = iCPPMethodArray[n2];
            if (methodAttribute.keep(method)) {
                filtered.add(method);
            }
            ++n2;
        }
        ArrayList<QPropertyAttributeProposal> proposals = new ArrayList<QPropertyAttributeProposal>();
        for (ICPPMethod method : QPropertyAttributeProposal.getMethods(context, methodAttribute)) {
            proposals.add(new QPropertyAttributeProposal(method.getName(), QPropertyAttributeProposal.getDisplay(cls, method), methodAttribute.getRelevance(method)));
        }
        return proposals;
    }

    private static Collection<QPropertyAttributeProposal> getSignalProposals(ICEditorContentAssistInvocationContext context, IMethodAttribute methodAttribute) {
        ICPPClassType cls = QPropertyAttributeProposal.getEnclosingClassDefinition(context);
        if (cls == null) {
            return Collections.emptyList();
        }
        ICProject cProject = context.getProject();
        if (cProject == null) {
            return Collections.emptyList();
        }
        QtIndex qtIndex = QtIndex.getIndex((IProject)cProject.getProject());
        if (qtIndex == null) {
            return Collections.emptyList();
        }
        IQObject qobj = null;
        try {
            qobj = qtIndex.findQObject(cls.getQualifiedName());
        }
        catch (DOMException e) {
            QtUIPlugin.log(e);
        }
        if (qobj == null) {
            return Collections.emptyList();
        }
        ArrayList<QPropertyAttributeProposal> proposals = new ArrayList<QPropertyAttributeProposal>();
        for (IQMethod qMethod : qobj.getSignals().all()) {
            proposals.add(new QPropertyAttributeProposal(qMethod.getName(), 2000));
        }
        return proposals;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isSameClass(ICPPClassType cls1, ICPPClassType cls2) {
        try {
            String[] qn1 = cls1.getQualifiedName();
            String[] qn2 = cls2.getQualifiedName();
            if (qn1.length != qn2.length) {
                return false;
            }
            int i = 0;
            while (true) {
                if (i >= qn1.length) {
                    return true;
                }
                if (!qn1[i].equals(qn2[i])) {
                    return false;
                }
                ++i;
            }
        }
        catch (DOMException e) {
            return false;
        }
    }

    private static String getDisplay(ICPPClassType referenceContext, ICPPMethod method) {
        boolean includeClassname = !QPropertyAttributeProposal.isSameClass(referenceContext, method.getClassOwner());
        StringBuilder sig = new StringBuilder();
        ICPPFunctionType type = method.getType();
        sig.append(type.getReturnType().toString());
        sig.append(' ');
        if (includeClassname) {
            sig.append(method.getOwner().getName());
            sig.append("::");
        }
        sig.append(method.getName());
        sig.append('(');
        boolean first = true;
        ICPPParameter[] iCPPParameterArray = method.getParameters();
        int n = iCPPParameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            CPPParameter cppParam;
            IASTInitializer defaultValue;
            ICPPParameter param = iCPPParameterArray[n2];
            if (first) {
                first = false;
            } else {
                sig.append(", ");
            }
            String defValue = null;
            if (param instanceof CPPParameter && (defaultValue = (cppParam = (CPPParameter)param).getInitializer()) instanceof IASTEqualsInitializer) {
                IASTInitializerClause clause = ((IASTEqualsInitializer)defaultValue).getInitializerClause();
                defValue = clause.toString();
            }
            sig.append(defValue == null ? param.getType().toString() : defValue);
            ++n2;
        }
        sig.append(')');
        return sig.toString();
    }

    private static IMethodAttribute get(IQProperty.Attribute attr, IType type, String propertyName) {
        switch (attr) {
            case READ: {
                return new Read(type, propertyName);
            }
            case WRITE: {
                return new Write(type, propertyName);
            }
            case RESET: {
                return new Reset(type, propertyName);
            }
        }
        return IMethodAttribute.Null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ICPPClassType getEnclosingClassDefinition(ICEditorContentAssistInvocationContext context) {
        try {
            IASTNode enclosing;
            IASTFileLocation location;
            IIndex index = CCorePlugin.getIndexManager().getIndex(context.getProject());
            ITranslationUnit tu = context.getTranslationUnit();
            if (tu == null) {
                return null;
            }
            IASTTranslationUnit astTU = tu.getAST(index, 231);
            if (astTU == null) {
                return null;
            }
            IASTNodeSelector selector = astTU.getNodeSelector(null);
            int offset = context.getInvocationOffset();
            do {
                if ((enclosing = selector.findEnclosingNode(offset, 0)) == null) {
                    return null;
                }
                location = enclosing.getFileLocation();
                if (location != null) continue;
                return null;
            } while ((offset = location.getNodeOffset() - 1) > 0 && !(enclosing instanceof IASTCompositeTypeSpecifier));
            if (!(enclosing instanceof IASTCompositeTypeSpecifier)) {
                return null;
            }
            IASTName name = ((IASTCompositeTypeSpecifier)enclosing).getName();
            if (name == null) {
                return null;
            }
            IBinding binding = name.getBinding();
            if (binding == null) {
                return null;
            }
            return (ICPPClassType)binding.getAdapter(ICPPClassType.class);
        }
        catch (CoreException e) {
            QtUIPlugin.log(e);
            return null;
        }
    }

    private static Collection<ICPPMethod> getMethods(ICEditorContentAssistInvocationContext context, IMethodAttribute methodAttribute) {
        ICPPClassType cls = QPropertyAttributeProposal.getEnclosingClassDefinition(context);
        if (cls == null) {
            return Collections.emptyList();
        }
        ICPPMethod[] methods = cls.getMethods();
        ArrayList<ICPPMethod> filtered = new ArrayList<ICPPMethod>(methods.length);
        ICPPMethod[] iCPPMethodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPMethod method = iCPPMethodArray[n2];
            if (methodAttribute.keep(method)) {
                filtered.add(method);
            }
            ++n2;
        }
        return filtered;
    }

    private static boolean isAssignable(IType lhs, IType rhs) {
        return lhs != null && rhs.isSameType(lhs);
    }

    private static interface IMethodAttribute {
        public static final int BaseRelevance = 2000;
        public static final IMethodAttribute Null = new IMethodAttribute(){

            @Override
            public boolean keep(ICPPMethod method) {
                return false;
            }

            @Override
            public int getRelevance(ICPPMethod method) {
                return 0;
            }
        };

        public boolean keep(ICPPMethod var1);

        public int getRelevance(ICPPMethod var1);
    }

    private static class Read
    implements IMethodAttribute {
        private final IType type;
        private final String propertyName;

        public Read(IType type, String propertyName) {
            this.type = type;
            this.propertyName = propertyName;
        }

        @Override
        public boolean keep(ICPPMethod method) {
            if (method.getParameters().length > 0 && !method.getParameters()[0].hasDefaultValue()) {
                return false;
            }
            IType retType = method.getType().getReturnType();
            return QPropertyAttributeProposal.isAssignable(retType, this.type);
        }

        @Override
        public int getRelevance(ICPPMethod method) {
            String methodName = method.getName();
            if (methodName == null) {
                return 0;
            }
            if (methodName.equals(this.propertyName)) {
                return 2020;
            }
            if (methodName.equalsIgnoreCase("get" + this.propertyName)) {
                return 2019;
            }
            if (methodName.matches(".*(?i)" + this.propertyName + ".*")) {
                return 2018;
            }
            return 10;
        }
    }

    private static class Reset
    implements IMethodAttribute {
        private final IType type;
        private final String propertyName;

        public Reset(IType type, String propertyName) {
            this.type = type;
            this.propertyName = propertyName;
        }

        @Override
        public boolean keep(ICPPMethod method) {
            IType retType = method.getType().getReturnType();
            if (!(retType instanceof IBasicType) || ((IBasicType)retType).getKind() != IBasicType.Kind.eVoid) {
                return false;
            }
            return method.getParameters().length <= 0;
        }

        @Override
        public int getRelevance(ICPPMethod method) {
            String methodName = method.getName();
            if (methodName == null) {
                return 0;
            }
            if (methodName.equalsIgnoreCase("reset" + this.propertyName)) {
                return 2020;
            }
            if (methodName.matches(".*(?i)" + this.propertyName + ".*")) {
                return 2018;
            }
            return 10;
        }
    }

    private static class Write
    implements IMethodAttribute {
        private final IType type;
        private final String propertyName;

        public Write(IType type, String propertyName) {
            this.type = type;
            this.propertyName = propertyName;
        }

        @Override
        public boolean keep(ICPPMethod method) {
            if (method.getParameters().length < 1 || method.getParameters().length > 1 && !method.getParameters()[1].hasDefaultValue()) {
                return false;
            }
            IType paramType = method.getParameters()[0].getType();
            return QPropertyAttributeProposal.isAssignable(this.type, paramType);
        }

        @Override
        public int getRelevance(ICPPMethod method) {
            String methodName = method.getName();
            if (methodName == null) {
                return 0;
            }
            if (methodName.equals(this.propertyName)) {
                return 2020;
            }
            if (methodName.equalsIgnoreCase("set" + this.propertyName)) {
                return 2019;
            }
            if (methodName.matches(".*(?i)" + this.propertyName + ".*")) {
                return 2018;
            }
            return 10;
        }
    }
}

