/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.cdt.internal.ui.dialogs.TableTextCellEditor;
import org.eclipse.cdt.internal.ui.dialogs.TextFieldNavigationHandler;
import org.eclipse.cdt.internal.ui.refactoring.IParameterListChangeListener;
import org.eclipse.cdt.internal.ui.refactoring.Messages;
import org.eclipse.cdt.internal.ui.refactoring.NameInformation;
import org.eclipse.cdt.internal.ui.refactoring.ParameterEditDialog;
import org.eclipse.cdt.internal.ui.refactoring.StubTypeContext;
import org.eclipse.cdt.internal.ui.util.SWTUtil;
import org.eclipse.cdt.internal.ui.util.TableLayoutComposite;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.contentassist.SubjectControlContentAssistant;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.contentassist.ContentAssistHandler;

public class ChangeParametersControl
extends Composite {
    private final String[] columnProperties;
    private final int indexType;
    private final int indexDirection;
    private final int indexName;
    private final int indexDefault;
    private static final int ROW_COUNT = 7;
    static final Integer INDEX_OUTPUT = 0;
    static final Integer INDEX_RETURN = 1;
    private final Mode fMode;
    private final IParameterListChangeListener fListener;
    private List<NameInformation> fParameters;
    private final StubTypeContext fTypeContext;
    private final String[] fParamNameProposals;
    private ContentAssistHandler fNameContentAssistHandler;
    private TableViewer fTableViewer;
    private Button fUpButton;
    private Button fDownButton;
    private Button fEditButton;
    private Button fAddButton;
    private Button fRemoveButton;

    public ChangeParametersControl(Composite parent, int style, String label, IParameterListChangeListener listener, Mode mode, StubTypeContext typeContext) {
        this(parent, style, label, listener, mode, typeContext, new String[0]);
    }

    public ChangeParametersControl(Composite parent, int style, String label, IParameterListChangeListener listener, Mode mode) {
        this(parent, style, label, listener, mode, null, new String[0]);
    }

    public ChangeParametersControl(Composite parent, int style, String label, IParameterListChangeListener listener, Mode mode, String[] paramNameProposals) {
        this(parent, style, label, listener, mode, null, paramNameProposals);
    }

    private ChangeParametersControl(Composite parent, int style, String label, IParameterListChangeListener listener, Mode mode, StubTypeContext typeContext, String[] paramNameProposals) {
        super(parent, style);
        Assert.isNotNull((Object)listener);
        this.fListener = listener;
        this.fMode = mode;
        this.fTypeContext = typeContext;
        this.fParamNameProposals = paramNameProposals;
        ArrayList<String> properties = new ArrayList<String>();
        this.indexType = properties.size();
        properties.add("type");
        if (this.fMode.shouldShowDirection()) {
            this.indexDirection = properties.size();
            properties.add("direction");
        } else {
            this.indexDirection = -1;
        }
        this.indexName = properties.size();
        properties.add("name");
        if (this.fMode.canChangeDefault()) {
            this.indexDefault = properties.size();
            properties.add("default");
        } else {
            this.indexDefault = -1;
        }
        this.columnProperties = properties.toArray(new String[properties.size()]);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        if (label != null) {
            Label tableLabel = new Label((Composite)this, 0);
            GridData labelGd = new GridData();
            labelGd.horizontalSpan = 2;
            tableLabel.setLayoutData((Object)labelGd);
            tableLabel.setText(label);
        }
        this.createParameterList(this);
        this.createButtonComposite(this);
    }

    public void setInput(List<NameInformation> parameterInfos) {
        Assert.isNotNull(parameterInfos);
        this.fParameters = parameterInfos;
        this.fTableViewer.setInput(this.fParameters);
        if (this.fParameters.size() > 0) {
            this.fTableViewer.setSelection((ISelection)new StructuredSelection((Object)this.fParameters.get(0)));
        }
    }

    public void editParameter(NameInformation info) {
        this.fTableViewer.getControl().setFocus();
        if (!info.isDeleted()) {
            this.fTableViewer.setSelection((ISelection)new StructuredSelection((Object)info), true);
            this.updateButtonsEnabledState();
            this.editColumnOrNextPossible(this.indexName);
            return;
        }
    }

    private void createParameterList(Composite parent) {
        TableLayoutComposite layouter = new TableLayoutComposite(parent, 0);
        this.addColumnLayoutData(layouter);
        Table table = new Table((Composite)layouter, 67586);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumn tc = new TableColumn(table, 0, this.indexType);
        tc.setResizable(true);
        tc.setText(Messages.ChangeParametersControl_table_type);
        if (this.indexDirection >= 0) {
            tc = new TableColumn(table, 0, this.indexDirection);
            tc.setResizable(true);
            tc.setText(Messages.ChangeParametersControl_table_direction);
        }
        tc = new TableColumn(table, 0, this.indexName);
        tc.setResizable(true);
        tc.setText(Messages.ChangeParametersControl_table_name);
        if (this.indexDefault >= 0) {
            tc = new TableColumn(table, 0, this.indexDefault);
            tc.setResizable(true);
            tc.setText(Messages.ChangeParametersControl_table_default_value);
        }
        GridData gd = new GridData(1808);
        gd.heightHint = SWTUtil.getTableHeightHint(table, 7);
        gd.widthHint = 40;
        layouter.setLayoutData(gd);
        this.fTableViewer = new TableViewer(table);
        this.fTableViewer.setUseHashlookup(true);
        this.fTableViewer.setContentProvider((IContentProvider)new NameInformationContentProvider());
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new NameInformationLabelProvider());
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ChangeParametersControl.this.updateButtonsEnabledState();
            }
        });
        table.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4 && e.stateMask == 0) {
                    ChangeParametersControl.this.editColumnOrNextPossible(0);
                    e.detail = 0;
                }
            }
        });
        table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x100000B && e.stateMask == 0) {
                    ChangeParametersControl.this.editColumnOrNextPossible(0);
                    e.doit = false;
                }
            }
        });
        this.addCellEditors();
    }

    private static String getDirectionLabel(NameInformation parameter) {
        return parameter.isReturnValue() ? Messages.ChangeParametersControl_return : (parameter.isOutput() ? Messages.ChangeParametersControl_output : Messages.ChangeParametersControl_input);
    }

    private void editColumnOrNextPossible(int column) {
        NameInformation[] selected = this.getSelectedElements();
        if (selected.length != 1) {
            return;
        }
        int nextColumn = column;
        do {
            this.fTableViewer.editElement((Object)selected[0], nextColumn);
            if (!this.fTableViewer.isCellEditorActive()) continue;
            return;
        } while ((nextColumn = this.nextColumn(nextColumn)) != column);
    }

    private void editColumnOrPrevPossible(int column) {
        NameInformation[] selected = this.getSelectedElements();
        if (selected.length != 1) {
            return;
        }
        int prevColumn = column;
        do {
            this.fTableViewer.editElement((Object)selected[0], prevColumn);
            if (!this.fTableViewer.isCellEditorActive()) continue;
            return;
        } while ((prevColumn = this.prevColumn(prevColumn)) != column);
    }

    private int nextColumn(int column) {
        return column >= this.getTable().getColumnCount() - 1 ? 0 : column + 1;
    }

    private int prevColumn(int column) {
        return column <= 0 ? this.getTable().getColumnCount() - 1 : column - 1;
    }

    private void addColumnLayoutData(TableLayoutComposite layouter) {
        int i = 0;
        while (i < this.columnProperties.length) {
            layouter.addColumnData((ColumnLayoutData)new ColumnWeightData(10, true));
            ++i;
        }
    }

    private NameInformation[] getSelectedElements() {
        ISelection selection = this.fTableViewer.getSelection();
        if (selection == null) {
            return new NameInformation[0];
        }
        if (!(selection instanceof IStructuredSelection)) {
            return new NameInformation[0];
        }
        List selected = ((IStructuredSelection)selection).toList();
        return selected.toArray(new NameInformation[selected.size()]);
    }

    private void createButtonComposite(Composite parent) {
        Composite buttonComposite = new Composite(parent, 0);
        buttonComposite.setLayoutData((Object)new GridData(1040));
        GridLayout gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        buttonComposite.setLayout((Layout)gl);
        if (this.fMode.canAddParameters()) {
            this.fAddButton = this.createAddButton(buttonComposite);
        }
        this.fEditButton = this.createEditButton(buttonComposite);
        if (this.fMode.canAddParameters()) {
            this.fRemoveButton = this.createRemoveButton(buttonComposite);
        }
        if (buttonComposite.getChildren().length != 0) {
            this.addSpacer(buttonComposite);
        }
        this.fUpButton = this.createButton(buttonComposite, Messages.ChangeParametersControl_buttons_move_up, true);
        this.fDownButton = this.createButton(buttonComposite, Messages.ChangeParametersControl_buttons_move_down, false);
        this.updateButtonsEnabledState();
    }

    private void addSpacer(Composite parent) {
        Label label = new Label(parent, 0);
        GridData gd = new GridData(768);
        gd.heightHint = 5;
        label.setLayoutData((Object)gd);
    }

    private void updateButtonsEnabledState() {
        this.fUpButton.setEnabled(this.canMove(true));
        this.fDownButton.setEnabled(this.canMove(false));
        if (this.fEditButton != null) {
            this.fEditButton.setEnabled(this.getTableSelectionCount() == 1);
        }
        if (this.fAddButton != null) {
            this.fAddButton.setEnabled(true);
        }
        if (this.fRemoveButton != null) {
            this.fRemoveButton.setEnabled(this.getTableSelectionCount() != 0);
        }
    }

    private int getTableSelectionCount() {
        return this.getTable().getSelectionCount();
    }

    private int getTableItemCount() {
        return this.getTable().getItemCount();
    }

    private Table getTable() {
        return this.fTableViewer.getTable();
    }

    private Button createEditButton(Composite buttonComposite) {
        Button button = new Button(buttonComposite, 8);
        button.setText(Messages.ChangeParametersControl_buttons_edit);
        button.setLayoutData((Object)new GridData(768));
        SWTUtil.setButtonDimensionHint(button);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    NameInformation[] selected = ChangeParametersControl.this.getSelectedElements();
                    Assert.isTrue((selected.length == 1 ? 1 : 0) != 0);
                    NameInformation parameterInfo = selected[0];
                    ParameterEditDialog dialog = new ParameterEditDialog(ChangeParametersControl.this.getShell(), parameterInfo, ChangeParametersControl.this.fMode.canChangeTypes(), ChangeParametersControl.this.fMode.canChangeDefault(), ChangeParametersControl.this.fMode.canChangeReturn() && parameterInfo.isOutput());
                    dialog.open();
                    ChangeParametersControl.this.fListener.parameterChanged(parameterInfo);
                    ChangeParametersControl.this.fTableViewer.update((Object)parameterInfo, ChangeParametersControl.this.columnProperties);
                }
                finally {
                    ChangeParametersControl.this.fTableViewer.getControl().setFocus();
                }
            }
        });
        return button;
    }

    private Button createAddButton(Composite buttonComposite) {
        Button button = new Button(buttonComposite, 8);
        button.setText(Messages.ChangeParametersControl_buttons_add);
        button.setLayoutData((Object)new GridData(768));
        SWTUtil.setButtonDimensionHint(button);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HashSet<String> excludedParamNames = new HashSet<String>(ChangeParametersControl.this.fParameters.size());
                int i = 0;
                while (i < ChangeParametersControl.this.fParameters.size()) {
                    NameInformation info = (NameInformation)ChangeParametersControl.this.fParameters.get(i);
                    excludedParamNames.add(info.getNewName());
                    ++i;
                }
                String newParamName = StubUtility.suggestParameterName("newParam", excludedParamNames, ChangeParametersControl.this.fTypeContext != null ? ChangeParametersControl.this.fTypeContext.getTranslationUnit() : null);
                NameInformation newInfo = NameInformation.createInfoForAddedParameter("int", newParamName, "0");
                int insertIndex = ChangeParametersControl.this.fParameters.size();
                ChangeParametersControl.this.fParameters.add(insertIndex, newInfo);
                ChangeParametersControl.this.fListener.parameterAdded(newInfo);
                ChangeParametersControl.this.fTableViewer.refresh();
                ChangeParametersControl.this.fTableViewer.getControl().setFocus();
                ChangeParametersControl.this.fTableViewer.setSelection((ISelection)new StructuredSelection((Object)newInfo), true);
                ChangeParametersControl.this.updateButtonsEnabledState();
                ChangeParametersControl.this.editColumnOrNextPossible(0);
            }
        });
        return button;
    }

    private Button createRemoveButton(Composite buttonComposite) {
        Button button = new Button(buttonComposite, 8);
        button.setText(Messages.ChangeParametersControl_buttons_remove);
        button.setLayoutData((Object)new GridData(768));
        SWTUtil.setButtonDimensionHint(button);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = ChangeParametersControl.this.getTable().getSelectionIndices()[0];
                NameInformation[] selected = ChangeParametersControl.this.getSelectedElements();
                int i = 0;
                while (i < selected.length) {
                    if (selected[i].isAdded()) {
                        ChangeParametersControl.this.fParameters.remove(selected[i]);
                    } else {
                        selected[i].markAsDeleted();
                    }
                    ++i;
                }
                this.restoreSelection(index);
            }

            private void restoreSelection(int index) {
                ChangeParametersControl.this.fTableViewer.refresh();
                ChangeParametersControl.this.fTableViewer.getControl().setFocus();
                int itemCount = ChangeParametersControl.this.getTableItemCount();
                if (itemCount != 0) {
                    if (index >= itemCount) {
                        index = itemCount - 1;
                    }
                    ChangeParametersControl.this.getTable().setSelection(index);
                }
                ChangeParametersControl.this.fListener.parameterListChanged();
                ChangeParametersControl.this.updateButtonsEnabledState();
            }
        });
        return button;
    }

    private Button createButton(Composite buttonComposite, String text, final boolean up) {
        Button button = new Button(buttonComposite, 8);
        button.setText(text);
        button.setLayoutData((Object)new GridData(768));
        SWTUtil.setButtonDimensionHint(button);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ISelection savedSelection = ChangeParametersControl.this.fTableViewer.getSelection();
                if (savedSelection == null) {
                    return;
                }
                NameInformation[] selection = ChangeParametersControl.this.getSelectedElements();
                if (selection.length == 0) {
                    return;
                }
                if (up) {
                    ChangeParametersControl.this.moveUp(selection);
                } else {
                    ChangeParametersControl.this.moveDown(selection);
                }
                ChangeParametersControl.this.fTableViewer.refresh();
                ChangeParametersControl.this.fTableViewer.setSelection(savedSelection);
                ChangeParametersControl.this.fListener.parameterListChanged();
                ChangeParametersControl.this.fTableViewer.getControl().setFocus();
            }
        });
        return button;
    }

    private void addCellEditors() {
        this.fTableViewer.setColumnProperties(this.columnProperties);
        ArrayList<Object> editors = new ArrayList<Object>();
        TableTextCellEditor cellEditorType = new TableTextCellEditor(this.fTableViewer, this.indexType);
        editors.add((Object)cellEditorType);
        if (this.indexDirection >= 0) {
            DirectionCellEditor cellEditorDirection = new DirectionCellEditor(this.fTableViewer.getTable());
            editors.add((Object)cellEditorDirection);
        }
        TableTextCellEditor cellEditorName = new TableTextCellEditor(this.fTableViewer, this.indexName);
        editors.add((Object)cellEditorName);
        if (this.indexDefault >= 0) {
            TableTextCellEditor cellEditorDefault = new TableTextCellEditor(this.fTableViewer, this.indexDefault);
            editors.add((Object)cellEditorDefault);
        }
        if (this.fParamNameProposals.length > 0) {
            SubjectControlContentAssistant assistant = this.installParameterNameContentAssist(cellEditorName.getText());
            cellEditorName.setContentAssistant(assistant);
        }
        int i = 0;
        while (i < editors.size()) {
            final int editorColumn = i;
            CellEditor editor = (CellEditor)editors.get(i);
            Control control = editor.getControl();
            control.addTraverseListener(new TraverseListener(){

                public void keyTraversed(TraverseEvent e) {
                    switch (e.detail) {
                        case 16: {
                            ChangeParametersControl.this.editColumnOrNextPossible(ChangeParametersControl.this.nextColumn(editorColumn));
                            e.detail = 0;
                            break;
                        }
                        case 8: {
                            ChangeParametersControl.this.editColumnOrPrevPossible(ChangeParametersControl.this.prevColumn(editorColumn));
                            e.detail = 0;
                        }
                    }
                }
            });
            if (control instanceof Text) {
                TextFieldNavigationHandler.install((Text)control);
            }
            ++i;
        }
        cellEditorName.setActivationListener(new TableTextCellEditor.IActivationListener(){

            @Override
            public void activate() {
                NameInformation[] selected = ChangeParametersControl.this.getSelectedElements();
                if (selected.length == 1 && ChangeParametersControl.this.fNameContentAssistHandler != null) {
                    ChangeParametersControl.this.fNameContentAssistHandler.setEnabled(selected[0].isAdded());
                }
            }
        });
        this.fTableViewer.setCellEditors(editors.toArray(new CellEditor[editors.size()]));
        this.fTableViewer.setCellModifier((ICellModifier)new ParametersCellModifier());
    }

    private void moveUp(NameInformation[] selection) {
        ChangeParametersControl.moveUp(this.fParameters, Arrays.asList(selection));
    }

    private void moveDown(NameInformation[] selection) {
        Collections.reverse(this.fParameters);
        ChangeParametersControl.moveUp(this.fParameters, Arrays.asList(selection));
        Collections.reverse(this.fParameters);
    }

    private static void moveUp(List<NameInformation> elements, List<NameInformation> move) {
        ArrayList<NameInformation> res = new ArrayList<NameInformation>(elements.size());
        ArrayList<NameInformation> deleted = new ArrayList<NameInformation>();
        NameInformation floating = null;
        for (NameInformation curr : elements) {
            if (move.contains(curr)) {
                res.add(curr);
                continue;
            }
            if (curr.isDeleted()) {
                deleted.add(curr);
                continue;
            }
            if (floating != null) {
                res.add(floating);
            }
            floating = curr;
        }
        if (floating != null) {
            res.add(floating);
        }
        res.addAll(deleted);
        elements.clear();
        Iterator<NameInformation> iter = res.iterator();
        while (iter.hasNext()) {
            elements.add(iter.next());
        }
    }

    private boolean canMove(boolean up) {
        int notDeletedInfosCount = this.getNotDeletedInfosCount();
        if (notDeletedInfosCount == 0) {
            return false;
        }
        int[] indc = this.getTable().getSelectionIndices();
        if (indc.length == 0) {
            return false;
        }
        int invalid = up ? 0 : notDeletedInfosCount - 1;
        int i = 0;
        while (i < indc.length) {
            if (indc[i] == invalid) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private int getNotDeletedInfosCount() {
        if (this.fParameters == null) {
            return 0;
        }
        int result = 0;
        for (NameInformation info : this.fParameters) {
            if (info.isDeleted()) continue;
            ++result;
        }
        return result;
    }

    private SubjectControlContentAssistant installParameterNameContentAssist(Text text) {
        return null;
    }

    private static class DirectionCellEditor
    extends ComboBoxCellEditor {
        DirectionCellEditor(Table table) {
            super((Composite)table, new String[]{Messages.ChangeParametersControl_output, Messages.ChangeParametersControl_return}, 8);
        }

        protected Control createControl(Composite parent) {
            CCombo comboBox = (CCombo)super.createControl(parent);
            comboBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    DirectionCellEditor.this.fireApplyEditorValue();
                }
            });
            return comboBox;
        }
    }

    public static enum Mode {
        EXTRACT_METHOD,
        EXTRACT_METHOD_FIXED_RETURN,
        CHANGE_METHOD_SIGNATURE,
        INTRODUCE_PARAMETER;


        public boolean canChangeTypes() {
            return this == CHANGE_METHOD_SIGNATURE;
        }

        public boolean canAddParameters() {
            return this == CHANGE_METHOD_SIGNATURE;
        }

        public boolean canChangeDefault() {
            return this == CHANGE_METHOD_SIGNATURE;
        }

        public boolean shouldShowDirection() {
            return this == EXTRACT_METHOD || this == EXTRACT_METHOD_FIXED_RETURN;
        }

        public boolean canChangeReturn() {
            return this == EXTRACT_METHOD;
        }
    }

    private static class NameInformationContentProvider
    implements IStructuredContentProvider {
        private NameInformationContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return this.removeMarkedAsDeleted((List)inputElement);
        }

        private NameInformation[] removeMarkedAsDeleted(List<NameInformation> params) {
            ArrayList<NameInformation> result = new ArrayList<NameInformation>(params.size());
            for (NameInformation info : params) {
                if (info.isDeleted()) continue;
                result.add(info);
            }
            return result.toArray(new NameInformation[result.size()]);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class NameInformationLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    ITableFontProvider {
        private NameInformationLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            NameInformation info = (NameInformation)element;
            if (columnIndex == ChangeParametersControl.this.indexType) {
                return info.getTypeName();
            }
            if (columnIndex == ChangeParametersControl.this.indexDirection) {
                return ChangeParametersControl.getDirectionLabel(info);
            }
            if (columnIndex == ChangeParametersControl.this.indexName) {
                return info.getNewName();
            }
            if (columnIndex == ChangeParametersControl.this.indexDefault) {
                if (info.isAdded()) {
                    return info.getDefaultValue();
                }
                return "-";
            }
            throw new IllegalArgumentException(String.valueOf(columnIndex) + ": " + element);
        }

        public Font getFont(Object element, int columnIndex) {
            NameInformation info = (NameInformation)element;
            if (info.isAdded()) {
                return JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont");
            }
            return null;
        }
    }

    private class ParametersCellModifier
    implements ICellModifier {
        private ParametersCellModifier() {
        }

        public boolean canModify(Object element, String property) {
            Assert.isTrue((boolean)(element instanceof NameInformation));
            if (property.equals(ChangeParametersControl.this.columnProperties[ChangeParametersControl.this.indexType])) {
                return ChangeParametersControl.this.fMode.canChangeTypes();
            }
            if (property.equals(ChangeParametersControl.this.columnProperties[ChangeParametersControl.this.indexDirection])) {
                return ChangeParametersControl.this.fMode.canChangeReturn() && ((NameInformation)element).isOutput();
            }
            if (property.equals(ChangeParametersControl.this.columnProperties[ChangeParametersControl.this.indexName])) {
                return true;
            }
            if (property.equals(ChangeParametersControl.this.columnProperties[ChangeParametersControl.this.indexDefault])) {
                return ((NameInformation)element).isAdded();
            }
            Assert.isTrue((boolean)false);
            return false;
        }

        public Object getValue(Object element, String property) {
            Assert.isTrue((boolean)(element instanceof NameInformation));
            if (property.equals(ChangeParametersControl.this.columnProperties[ChangeParametersControl.this.indexType])) {
                return ((NameInformation)element).getTypeName();
            }
            if (property.equals(ChangeParametersControl.this.columnProperties[ChangeParametersControl.this.indexDirection])) {
                return ((NameInformation)element).isReturnValue() ? INDEX_RETURN : INDEX_OUTPUT;
            }
            if (property.equals(ChangeParametersControl.this.columnProperties[ChangeParametersControl.this.indexName])) {
                return ((NameInformation)element).getNewName();
            }
            if (property.equals(ChangeParametersControl.this.columnProperties[ChangeParametersControl.this.indexDefault])) {
                return ((NameInformation)element).getDefaultValue();
            }
            Assert.isTrue((boolean)false);
            return null;
        }

        public void modify(Object element, String property, Object value) {
            boolean unchanged;
            if (element instanceof TableItem) {
                element = ((TableItem)element).getData();
            }
            if (!(element instanceof NameInformation)) {
                return;
            }
            String[] columnsToUpdate = new String[]{property};
            NameInformation parameterInfo = (NameInformation)element;
            if (property.equals(ChangeParametersControl.this.columnProperties[ChangeParametersControl.this.indexType])) {
                unchanged = parameterInfo.getTypeName().equals(value);
                parameterInfo.setTypeName((String)value);
            } else if (property.equals(ChangeParametersControl.this.columnProperties[ChangeParametersControl.this.indexDirection])) {
                columnsToUpdate = new String[]{property, ChangeParametersControl.this.columnProperties[ChangeParametersControl.this.indexType]};
                boolean isReturn = value.equals(INDEX_RETURN);
                boolean bl = unchanged = isReturn == parameterInfo.isReturnValue();
                if (!unchanged && isReturn) {
                    for (NameInformation param : ChangeParametersControl.this.fParameters) {
                        if (param == parameterInfo || !param.isOutput()) continue;
                        param.setReturnValue(false);
                        ChangeParametersControl.this.fListener.parameterChanged(param);
                        ChangeParametersControl.this.fTableViewer.update((Object)param, columnsToUpdate);
                        break;
                    }
                }
                parameterInfo.setReturnValue(isReturn);
            } else if (property.equals(ChangeParametersControl.this.columnProperties[ChangeParametersControl.this.indexName])) {
                unchanged = parameterInfo.getNewName().equals(value);
                parameterInfo.setNewName((String)value);
            } else if (property.equals(ChangeParametersControl.this.columnProperties[ChangeParametersControl.this.indexDefault])) {
                unchanged = parameterInfo.getDefaultValue().equals(value);
                parameterInfo.setDefaultValue((String)value);
            } else {
                throw new IllegalStateException();
            }
            if (!unchanged) {
                ChangeParametersControl.this.fListener.parameterChanged(parameterInfo);
                ChangeParametersControl.this.fTableViewer.update((Object)parameterInfo, columnsToUpdate);
            }
        }
    }
}

