/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.arduino.core.internal.board;

import java.util.Properties;
import org.eclipse.cdt.arduino.core.internal.HierarchicalProperties;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoPlatform;

public class ArduinoBoard {
    public static final String MENU_QUALIFIER = "menu_";
    private String name;
    private String id;
    private ArduinoPlatform platform;
    private HierarchicalProperties properties;

    public ArduinoBoard() {
    }

    public ArduinoBoard(String id, HierarchicalProperties properties) {
        this.properties = properties;
        this.id = id;
        this.name = this.properties.getChild("name").getValue();
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public ArduinoPlatform getPlatform() {
        return this.platform;
    }

    ArduinoBoard setOwners(ArduinoPlatform platform) {
        this.platform = platform;
        return this;
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public HierarchicalProperties getMenus() {
        return this.properties.getChild("menu");
    }

    public Properties getBoardProperties() {
        return this.properties.flatten();
    }

    public Properties getMenuProperties(String id, String value) {
        return this.getMenus().getChild(id).getChild(value).flatten();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.platform == null ? 0 : this.platform.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArduinoBoard other = (ArduinoBoard)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.platform == null ? other.platform != null : !this.platform.equals(other.platform));
    }
}

