/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.arduino.core.internal.board;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.eclipse.cdt.arduino.core.internal.Activator;
import org.eclipse.cdt.arduino.core.internal.ArduinoPreferences;
import org.eclipse.cdt.arduino.core.internal.Messages;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoBoard;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoLibrary;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoPackage;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoPlatform;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoTool;
import org.eclipse.cdt.arduino.core.internal.board.LibraryIndex;
import org.eclipse.cdt.arduino.core.internal.board.PackageIndex;
import org.eclipse.cdt.arduino.core.internal.build.ArduinoBuildConfiguration;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.BackingStoreException;

public class ArduinoManager {
    public static final String BOARD_OPTION_ID = "org.eclipse.cdt.arduino.option.board";
    public static final String PLATFORM_OPTION_ID = "org.eclipse.cdt.arduino.option.platform";
    public static final String PACKAGE_OPTION_ID = "org.eclipse.cdt.arduino.option.package";
    public static final String AVR_TOOLCHAIN_ID = "org.eclipse.cdt.arduino.toolChain.avr";
    public static final String LIBRARIES_URL = "http://downloads.arduino.cc/libraries/library_index.json";
    private List<PackageIndex> packageIndices;
    private LibraryIndex libraryIndex;
    private static final String LIBRARIES = "libraries";

    public void loadIndices() {
        new Job(Messages.ArduinoBoardManager_0){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IStatus run(IProgressMonitor monitor) {
                ArduinoManager arduinoManager = ArduinoManager.this;
                synchronized (arduinoManager) {
                    String[] boardUrls = ArduinoPreferences.getBoardUrls().split("\n");
                    ArduinoManager.this.packageIndices = new ArrayList(boardUrls.length);
                    String[] stringArray = boardUrls;
                    int n = boardUrls.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String boardUrl = stringArray[n2];
                        ArduinoManager.this.loadPackageIndex(boardUrl, true);
                        ++n2;
                    }
                    ArduinoManager.this.loadLibraryIndex(true);
                    return Status.OK_STATUS;
                }
            }
        }.schedule();
    }

    private void loadPackageIndex(String url, boolean download) {
        block12: {
            try {
                URL packageUrl = new URL(url.trim());
                Path packagePath = ArduinoPreferences.getArduinoHome().resolve(Paths.get(packageUrl.getPath(), new String[0]).getFileName());
                File packageFile = packagePath.toFile();
                if (download) {
                    Files.createDirectories(ArduinoPreferences.getArduinoHome(), new FileAttribute[0]);
                    Files.copy(packageUrl.openStream(), packagePath, StandardCopyOption.REPLACE_EXISTING);
                }
                if (!packageFile.exists()) break block12;
                Throwable throwable = null;
                Object var7_9 = null;
                try (FileReader reader = new FileReader(packageFile);){
                    PackageIndex index = (PackageIndex)new Gson().fromJson((Reader)reader, PackageIndex.class);
                    index.setOwners(this);
                    this.packageIndices.add(index);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                Activator.log(e);
            }
        }
    }

    public synchronized List<PackageIndex> getPackageIndices() {
        if (this.packageIndices == null) {
            String[] boardUrls = ArduinoPreferences.getBoardUrls().split("\n");
            this.packageIndices = new ArrayList<PackageIndex>(boardUrls.length);
            String[] stringArray = boardUrls;
            int n = boardUrls.length;
            int n2 = 0;
            while (n2 < n) {
                String boardUrl = stringArray[n2];
                this.loadPackageIndex(boardUrl, false);
                ++n2;
            }
        }
        return this.packageIndices;
    }

    public void loadLibraryIndex(boolean download) {
        block12: {
            try {
                URL librariesUrl = new URL(LIBRARIES_URL);
                Path librariesPath = ArduinoPreferences.getArduinoHome().resolve(Paths.get(librariesUrl.getPath(), new String[0]).getFileName());
                File librariesFile = librariesPath.toFile();
                if (download) {
                    Files.createDirectories(ArduinoPreferences.getArduinoHome(), new FileAttribute[0]);
                    Files.copy(librariesUrl.openStream(), librariesPath, StandardCopyOption.REPLACE_EXISTING);
                }
                if (!librariesFile.exists()) break block12;
                Throwable throwable = null;
                Object var6_8 = null;
                try (FileReader reader = new FileReader(librariesFile);){
                    this.libraryIndex = (LibraryIndex)new Gson().fromJson((Reader)reader, LibraryIndex.class);
                    this.libraryIndex.resolve();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                Activator.log(e);
            }
        }
    }

    public LibraryIndex getLibraryIndex() throws CoreException {
        if (this.libraryIndex == null) {
            this.loadLibraryIndex(false);
        }
        return this.libraryIndex;
    }

    public ArduinoBoard getBoard(String boardName, String platformName, String packageName) throws CoreException {
        for (PackageIndex index : this.getPackageIndices()) {
            ArduinoBoard board;
            ArduinoPlatform platform;
            ArduinoPackage pkg = index.getPackage(packageName);
            if (pkg == null || (platform = pkg.getPlatform(platformName)) == null || (board = platform.getBoard(boardName)) == null) continue;
            return board;
        }
        return null;
    }

    public List<ArduinoBoard> getInstalledBoards() throws CoreException {
        ArrayList<ArduinoBoard> boards = new ArrayList<ArduinoBoard>();
        for (PackageIndex index : this.getPackageIndices()) {
            for (ArduinoPackage pkg : index.getPackages()) {
                for (ArduinoPlatform platform : pkg.getInstalledPlatforms().values()) {
                    boards.addAll(platform.getBoards());
                }
            }
        }
        return boards;
    }

    public ArduinoPackage getPackage(String packageName) throws CoreException {
        for (PackageIndex index : this.getPackageIndices()) {
            ArduinoPackage pkg = index.getPackage(packageName);
            if (pkg == null) continue;
            return pkg;
        }
        return null;
    }

    public ArduinoTool getTool(String packageName, String toolName, String version) throws CoreException {
        for (PackageIndex index : this.getPackageIndices()) {
            ArduinoTool tool;
            ArduinoPackage pkg = index.getPackage(packageName);
            if (pkg == null || (tool = pkg.getTool(toolName, version)) == null) continue;
            return tool;
        }
        return null;
    }

    private IEclipsePreferences getSettings(IProject project) {
        return new ProjectScope(project).getNode(Activator.getId());
    }

    public Collection<ArduinoLibrary> getLibraries(IProject project) throws CoreException {
        IEclipsePreferences settings = this.getSettings(project);
        String librarySetting = settings.get(LIBRARIES, "[]");
        Type stringSet = new TypeToken<Set<String>>(){}.getType();
        Set libraryNames = (Set)new Gson().fromJson(librarySetting, stringSet);
        LibraryIndex index = Activator.getService(ArduinoManager.class).getLibraryIndex();
        ArduinoPlatform platform = ((ArduinoBuildConfiguration)project.getActiveBuildConfig().getAdapter(ArduinoBuildConfiguration.class)).getBoard().getPlatform();
        ArrayList<ArduinoLibrary> libraries = new ArrayList<ArduinoLibrary>(libraryNames.size());
        for (String name : libraryNames) {
            ArduinoLibrary lib = index.getLibrary(name);
            if (lib == null) {
                lib = platform.getLibrary(name);
            }
            if (lib == null) continue;
            libraries.add(lib);
        }
        return libraries;
    }

    public void setLibraries(final IProject project, final Collection<ArduinoLibrary> libraries) throws CoreException {
        ArrayList<String> libraryNames = new ArrayList<String>(libraries.size());
        for (ArduinoLibrary library : libraries) {
            libraryNames.add(library.getName());
        }
        IEclipsePreferences settings = this.getSettings(project);
        settings.put(LIBRARIES, new Gson().toJson(libraryNames));
        try {
            settings.flush();
        }
        catch (BackingStoreException e) {
            Activator.log((Exception)((Object)e));
        }
        new Job(Messages.ArduinoManager_0){

            protected IStatus run(IProgressMonitor monitor) {
                MultiStatus mstatus = new MultiStatus(Activator.getId(), 0, Messages.ArduinoManager_1, null);
                for (ArduinoLibrary library : libraries) {
                    IStatus status = library.install(monitor);
                    if (status.isOK()) continue;
                    mstatus.add(status);
                }
                try {
                    IBuildConfiguration[] iBuildConfigurationArray = project.getBuildConfigs();
                    int n = iBuildConfigurationArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IBuildConfiguration config = iBuildConfigurationArray[n2];
                        ArduinoBuildConfiguration arduinoConfig = (ArduinoBuildConfiguration)config.getAdapter(ArduinoBuildConfiguration.class);
                        arduinoConfig.clearScannerInfoCache();
                        ++n2;
                    }
                }
                catch (CoreException e) {
                    mstatus.add(e.getStatus());
                }
                return mstatus;
            }
        }.schedule();
    }

    public static IStatus downloadAndInstall(String url, String archiveFileName, Path installPath, IProgressMonitor monitor) {
        Throwable error = null;
        int retries = 3;
        while (retries > 0 && !monitor.isCanceled()) {
            try {
                URL dl = new URL(url);
                Path dlDir = ArduinoPreferences.getArduinoHome().resolve("downloads");
                Files.createDirectories(dlDir, new FileAttribute[0]);
                Path archivePath = dlDir.resolve(archiveFileName);
                URLConnection conn = dl.openConnection();
                conn.setConnectTimeout(10000);
                conn.setReadTimeout(10000);
                Files.copy(conn.getInputStream(), archivePath, StandardCopyOption.REPLACE_EXISTING);
                boolean isWin = Platform.getOS().equals("win32");
                try (ArchiveInputStream archiveIn = null;){
                    String compressor = null;
                    String archiver = null;
                    if (archiveFileName.endsWith("tar.bz2")) {
                        compressor = "bzip2";
                        archiver = "tar";
                    } else if (archiveFileName.endsWith(".tar.gz") || archiveFileName.endsWith(".tgz")) {
                        compressor = "gz";
                        archiver = "tar";
                    } else if (archiveFileName.endsWith(".tar.xz")) {
                        compressor = "xz";
                        archiver = "tar";
                    } else if (archiveFileName.endsWith(".zip")) {
                        archiver = "zip";
                    }
                    BufferedInputStream in = new BufferedInputStream(new FileInputStream(archivePath.toFile()));
                    if (compressor != null) {
                        in = new CompressorStreamFactory().createCompressorInputStream(compressor, (InputStream)in);
                    }
                    archiveIn = new ArchiveStreamFactory().createArchiveInputStream(archiver, (InputStream)in);
                    ArchiveEntry entry = archiveIn.getNextEntry();
                    while (entry != null) {
                        Path path;
                        if (!entry.isDirectory() && !(path = Paths.get(entry.getName(), new String[0])).endsWith("pax_global_header")) {
                            Path entryPath = installPath.resolve(path.subpath(1, path.getNameCount()));
                            Files.createDirectories(entryPath.getParent(), new FileAttribute[0]);
                            if (entry instanceof TarArchiveEntry) {
                                TarArchiveEntry tarEntry = (TarArchiveEntry)entry;
                                if (tarEntry.isLink()) {
                                    Path linkPath = Paths.get(tarEntry.getLinkName(), new String[0]);
                                    linkPath = installPath.resolve(linkPath.subpath(1, linkPath.getNameCount()));
                                    Files.deleteIfExists(entryPath);
                                    Files.createSymbolicLink(entryPath, entryPath.getParent().relativize(linkPath), new FileAttribute[0]);
                                } else if (tarEntry.isSymbolicLink()) {
                                    Path linkPath = Paths.get(tarEntry.getLinkName(), new String[0]);
                                    Files.deleteIfExists(entryPath);
                                    Files.createSymbolicLink(entryPath, linkPath, new FileAttribute[0]);
                                } else {
                                    Files.copy((InputStream)archiveIn, entryPath, StandardCopyOption.REPLACE_EXISTING);
                                }
                                if (!isWin && !tarEntry.isSymbolicLink()) {
                                    int mode = tarEntry.getMode();
                                    Files.setPosixFilePermissions(entryPath, ArduinoManager.toPerms(mode));
                                }
                            } else {
                                Files.copy((InputStream)archiveIn, entryPath, StandardCopyOption.REPLACE_EXISTING);
                            }
                        }
                        entry = archiveIn.getNextEntry();
                    }
                }
                return Status.OK_STATUS;
            }
            catch (IOException | ArchiveException | CompressorException e) {
                error = e;
                --retries;
            }
        }
        return new Status(4, Activator.getId(), Messages.ArduinoManager_2, error);
    }

    public static int compareVersions(String version1, String version2) {
        if (version1 == null) {
            return version2 == null ? 0 : -1;
        }
        if (version2 == null) {
            return 1;
        }
        String[] v1 = version1.split("\\.");
        String[] v2 = version2.split("\\.");
        int i = 0;
        while (i < Math.max(v1.length, v2.length)) {
            block11: {
                int vi2;
                int vi1;
                block10: {
                    if (v1.length <= i) {
                        return v2.length < i ? 0 : -1;
                    }
                    if (v2.length <= i) {
                        return 1;
                    }
                    vi1 = Integer.parseInt(v1[i]);
                    vi2 = Integer.parseInt(v2[i]);
                    if (vi1 >= vi2) break block10;
                    return -1;
                }
                try {
                    if (vi1 > vi2) {
                        return 1;
                    }
                }
                catch (NumberFormatException e) {
                    int c = v1[i].compareTo(v2[i]);
                    if (c < 0) {
                        return -1;
                    }
                    if (c <= 0) break block11;
                    return 1;
                }
            }
            ++i;
        }
        return 0;
    }

    private static Set<PosixFilePermission> toPerms(int mode) {
        HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
        if ((mode & 0x100) != 0) {
            perms.add(PosixFilePermission.OWNER_READ);
        }
        if ((mode & 0x80) != 0) {
            perms.add(PosixFilePermission.OWNER_WRITE);
        }
        if ((mode & 0x40) != 0) {
            perms.add(PosixFilePermission.OWNER_EXECUTE);
        }
        if ((mode & 0x20) != 0) {
            perms.add(PosixFilePermission.GROUP_READ);
        }
        if ((mode & 0x10) != 0) {
            perms.add(PosixFilePermission.GROUP_WRITE);
        }
        if ((mode & 8) != 0) {
            perms.add(PosixFilePermission.GROUP_EXECUTE);
        }
        if ((mode & 4) != 0) {
            perms.add(PosixFilePermission.OTHERS_READ);
        }
        if ((mode & 2) != 0) {
            perms.add(PosixFilePermission.OTHERS_WRITE);
        }
        if ((mode & 1) != 0) {
            perms.add(PosixFilePermission.OTHERS_EXECUTE);
        }
        return perms;
    }

    public static void recursiveDelete(Path directory) throws IOException {
        Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }
}

