/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.arduino.core.internal.board;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.cdt.arduino.core.internal.Activator;
import org.eclipse.cdt.arduino.core.internal.ArduinoPreferences;
import org.eclipse.cdt.arduino.core.internal.HierarchicalProperties;
import org.eclipse.cdt.arduino.core.internal.Messages;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoBoard;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoLibrary;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoManager;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoPackage;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoTool;
import org.eclipse.cdt.arduino.core.internal.board.ToolDependency;
import org.eclipse.cdt.arduino.core.internal.build.ArduinoBuildConfiguration;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

public class ArduinoPlatform {
    private String name;
    private String architecture;
    private String version;
    private String category;
    private String url;
    private String archiveFileName;
    private String checksum;
    private String size;
    private List<ArduinoBoard> boards;
    private List<ToolDependency> toolsDependencies;
    private ArduinoPackage pkg;
    private HierarchicalProperties boardsProperties;
    private Properties platformProperties;
    private Map<String, String> menus = new HashMap<String, String>();
    private Map<String, ArduinoLibrary> libraries;

    void setOwner(ArduinoPackage pkg) {
        this.pkg = pkg;
        for (ArduinoBoard board : this.boards) {
            board.setOwners(this);
        }
        for (ToolDependency toolDep : this.toolsDependencies) {
            toolDep.setOwner(this);
        }
    }

    public ArduinoPackage getPackage() {
        return this.pkg;
    }

    public String getName() {
        return this.name;
    }

    public String getArchitecture() {
        return this.architecture;
    }

    public String getVersion() {
        return this.version;
    }

    public String getCategory() {
        return this.category;
    }

    public String getUrl() {
        return this.url;
    }

    public String getArchiveFileName() {
        return this.archiveFileName;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public String getSize() {
        return this.size;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<ArduinoBoard> getBoards() {
        Iterator<Map.Entry<String, HierarchicalProperties>> iterator;
        Properties boardProps;
        block18: {
            if (!this.isInstalled()) return this.boards;
            if (this.boardsProperties != null) return this.boards;
            boardProps = new Properties();
            try {
                Throwable throwable = null;
                iterator = null;
                try {
                    FileInputStream is = new FileInputStream(this.getInstallPath().resolve("boards.txt").toFile());
                    try {
                        try (InputStreamReader reader = new InputStreamReader((InputStream)is, "UTF-8");){
                            boardProps.load(reader);
                        }
                        if (is == null) break block18;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (is == null) throw throwable;
                        ((InputStream)is).close();
                        throw throwable;
                    }
                    ((InputStream)is).close();
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    }
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                    throw throwable;
                }
            }
            catch (IOException e) {
                Activator.log(e);
            }
        }
        this.boardsProperties = new HierarchicalProperties(boardProps);
        this.boards = new ArrayList<ArduinoBoard>();
        iterator = this.boardsProperties.getChildren().entrySet().iterator();
        while (true) {
            if (!iterator.hasNext()) break;
            Map.Entry<String, HierarchicalProperties> entry = iterator.next();
            if (entry.getValue().getChild("name") == null) continue;
            this.boards.add(new ArduinoBoard(entry.getKey(), entry.getValue()).setOwners(this));
        }
        HierarchicalProperties menuProp = this.boardsProperties.getChild("menu");
        if (menuProp == null) return this.boards;
        Iterator<Map.Entry<String, HierarchicalProperties>> iterator2 = menuProp.getChildren().entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<String, HierarchicalProperties> entry = iterator2.next();
            this.menus.put(entry.getKey(), entry.getValue().getValue());
        }
        return this.boards;
    }

    public HierarchicalProperties getBoardsProperties() {
        return this.boardsProperties;
    }

    public ArduinoBoard getBoard(String name) throws CoreException {
        for (ArduinoBoard board : this.getBoards()) {
            if (!name.equals(board.getName())) continue;
            return board;
        }
        return null;
    }

    public String getMenuText(String id) {
        return this.menus.get(id);
    }

    public List<ToolDependency> getToolsDependencies() {
        return this.toolsDependencies;
    }

    public ArduinoTool getTool(String name) throws CoreException {
        for (ToolDependency toolDep : this.toolsDependencies) {
            if (!toolDep.getName().equals(name)) continue;
            return toolDep.getTool();
        }
        return null;
    }

    public Properties getPlatformProperties() throws CoreException {
        if (this.platformProperties == null) {
            this.platformProperties = new Properties();
            try {
                Throwable throwable = null;
                Object var2_4 = null;
                try (BufferedReader reader = new BufferedReader(new FileReader(this.getInstallPath().resolve("platform.txt").toFile()));){
                    StringBuffer buffer = new StringBuffer();
                    String line = reader.readLine();
                    while (line != null) {
                        buffer.append(line.replace("\\", "\\\\"));
                        buffer.append('\n');
                        line = reader.readLine();
                    }
                    Throwable throwable2 = null;
                    Object var6_10 = null;
                    try (StringReader reader1 = new StringReader(buffer.toString());){
                        this.platformProperties.load(reader1);
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, Activator.getId(), "Loading platform.txt", (Throwable)e));
            }
        }
        return this.platformProperties;
    }

    public boolean isInstalled() {
        return this.getInstallPath().resolve("boards.txt").toFile().exists();
    }

    public Path getInstallPath() {
        Path oldPath = ArduinoPreferences.getArduinoHome().resolve("hardware").resolve(this.pkg.getName()).resolve(this.architecture).resolve(this.version);
        Path newPath = this.getPackage().getInstallPath().resolve("hardware").resolve(this.pkg.getName()).resolve(this.architecture).resolve(this.version);
        if (Files.exists(oldPath, new LinkOption[0])) {
            try {
                Files.createDirectories(newPath.getParent(), new FileAttribute[0]);
                Files.move(oldPath, newPath, new CopyOption[0]);
                Path parent = oldPath.getParent();
                while (parent != null) {
                    if (!Files.newDirectoryStream(parent).iterator().hasNext()) {
                        Files.delete(parent);
                        parent = parent.getParent();
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                Activator.log(e);
            }
        }
        return newPath;
    }

    public List<Path> getIncludePath() {
        Path installPath = this.getInstallPath();
        return Arrays.asList(installPath.resolve("cores/{build.core}"), installPath.resolve("variants/{build.variant}"));
    }

    private void getSources(Collection<String> sources, Path dir, boolean recurse) {
        File[] fileArray = dir.toFile().listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                if (recurse) {
                    this.getSources(sources, file.toPath(), recurse);
                }
            } else if (ArduinoBuildConfiguration.isSource(file.getName())) {
                sources.add(ArduinoBuildConfiguration.pathString(file.toPath()));
            }
            ++n2;
        }
    }

    public Collection<String> getSources(String core, String variant) {
        Path variantPath;
        ArrayList<String> sources = new ArrayList<String>();
        Path srcPath = this.getInstallPath().resolve("cores").resolve(core);
        if (srcPath.toFile().isDirectory()) {
            this.getSources(sources, srcPath, true);
        }
        if ((variantPath = this.getInstallPath().resolve("variants").resolve(variant)).toFile().isDirectory()) {
            this.getSources(sources, variantPath, true);
        }
        return sources;
    }

    private void initLibraries() throws CoreException {
        this.libraries = new HashMap<String, ArduinoLibrary>();
        File[] libraryDirs = this.getInstallPath().resolve("libraries").toFile().listFiles();
        if (libraryDirs != null) {
            File[] fileArray = libraryDirs;
            int n = libraryDirs.length;
            int n2 = 0;
            while (n2 < n) {
                File libraryDir = fileArray[n2];
                Path propsPath = libraryDir.toPath().resolve("library.properties");
                if (propsPath.toFile().exists()) {
                    try {
                        ArduinoLibrary lib = new ArduinoLibrary(propsPath);
                        this.libraries.put(lib.getName(), lib);
                    }
                    catch (IOException e) {
                        throw new CoreException((IStatus)new Status(4, Activator.getId(), "Loading " + propsPath, (Throwable)e));
                    }
                }
                ++n2;
            }
        }
    }

    public synchronized Collection<ArduinoLibrary> getLibraries() throws CoreException {
        if (this.libraries == null && this.isInstalled()) {
            this.initLibraries();
        }
        return this.libraries.values();
    }

    public synchronized ArduinoLibrary getLibrary(String name) throws CoreException {
        if (this.libraries == null && this.isInstalled()) {
            this.initLibraries();
        }
        return this.libraries != null ? this.libraries.get(name) : null;
    }

    public IStatus install(IProgressMonitor monitor) {
        IStatus status;
        if (this.isInstalled()) {
            try {
                ArduinoManager.recursiveDelete(this.getInstallPath());
            }
            catch (IOException e) {
                Activator.log(e);
            }
        }
        for (ToolDependency toolDep : this.toolsDependencies) {
            IStatus status2 = toolDep.install(monitor);
            if (status2.isOK()) continue;
            return status2;
        }
        if (Platform.getOS().equals("win32")) {
            try {
                Path makePath = ArduinoPreferences.getArduinoHome().resolve("make.exe");
                if (!makePath.toFile().exists()) {
                    Files.createDirectories(makePath.getParent(), new FileAttribute[0]);
                    URL makeUrl = new URL("https://bintray.com/artifact/download/cdtdoug/tools/make.exe");
                    Files.copy(makeUrl.openStream(), makePath, new CopyOption[0]);
                    makePath.toFile().setExecutable(true, false);
                }
            }
            catch (IOException e) {
                return new Status(4, Activator.getId(), Messages.ArduinoPlatform_0, (Throwable)e);
            }
        }
        if (!(status = ArduinoManager.downloadAndInstall(this.url, this.archiveFileName, this.getInstallPath(), monitor)).isOK()) {
            return status;
        }
        return Status.OK_STATUS;
    }

    public IStatus uninstall(IProgressMonitor monitor) {
        try {
            ArduinoManager.recursiveDelete(this.getInstallPath());
            return Status.OK_STATUS;
        }
        catch (IOException e) {
            return new Status(4, Activator.getId(), Messages.ArduinoPlatform_1, (Throwable)e);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.pkg == null ? 0 : this.pkg.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArduinoPlatform other = (ArduinoPlatform)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.pkg == null ? other.pkg != null : !this.pkg.equals(other.pkg)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }
}

