/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.arduino.core.internal.console;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.arduino.core.internal.Activator;
import org.eclipse.cdt.arduino.core.internal.console.ArduinoConsoleParser;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;

public abstract class ArduinoErrorParser
extends ArduinoConsoleParser {
    public static final String LINK_OFFSET = "arduino.link.offset";
    public static final String LINK_LENGTH = "arduino.link.length";
    private final Pattern errorPattern;

    public ArduinoErrorParser(String pattern, int flags, String lineQualifier) {
        super(pattern, flags, lineQualifier);
        this.errorPattern = Pattern.compile(pattern);
    }

    public ArduinoErrorParser(String pattern) {
        this(pattern, 0, null);
    }

    protected abstract String getFileName(Matcher var1);

    protected abstract int getLineNumber(Matcher var1);

    protected abstract String getMessage(Matcher var1);

    protected abstract int getSeverity(Matcher var1);

    protected abstract int getLinkOffset(Matcher var1);

    protected abstract int getLinkLength(Matcher var1);

    public IMarker generateMarker(IFolder buildDirectory, String text) throws CoreException {
        String fileName;
        IFile file;
        Matcher matcher = this.errorPattern.matcher(text);
        if (matcher.matches() && (file = buildDirectory.getFile(fileName = this.getFileName(matcher))).exists()) {
            IMarker marker;
            IMarker[] iMarkerArray = file.findMarkers("org.eclipse.cdt.core.problem", false, 0);
            int n = iMarkerArray.length;
            int n2 = 0;
            while (n2 < n) {
                marker = iMarkerArray[n2];
                if (marker.getAttribute("severity", -1) == this.getSeverity(matcher) && marker.getAttribute("lineNumber", -1) == this.getLineNumber(matcher) && marker.getAttribute("message", "").equals(this.getMessage(matcher))) {
                    return marker;
                }
                ++n2;
            }
            try {
                marker = file.createMarker("org.eclipse.cdt.core.problem");
                marker.setAttribute("message", (Object)this.getMessage(matcher));
                marker.setAttribute("severity", this.getSeverity(matcher));
                marker.setAttribute("lineNumber", this.getLineNumber(matcher));
                marker.setAttribute("charStart", -1);
                marker.setAttribute("charEnd", -1);
                marker.setAttribute(LINK_OFFSET, this.getLinkOffset(matcher));
                marker.setAttribute(LINK_LENGTH, this.getLinkLength(matcher));
                return marker;
            }
            catch (CoreException e) {
                Activator.log((Exception)((Object)e));
                return null;
            }
        }
        return null;
    }
}

