/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.arduino.ui.internal.preferences;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoBoard;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoPlatform;
import org.eclipse.cdt.arduino.ui.internal.Messages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PlatformDetailsDialog
extends Dialog {
    private final ArduinoPlatform platform;

    protected PlatformDetailsDialog(Shell parentShell, ArduinoPlatform platform) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.platform = platform;
    }

    protected Control createDialogArea(Composite parent) {
        Composite control = (Composite)super.createDialogArea(parent);
        Text text = new Text(control, 2570);
        text.setLayoutData((Object)new GridData(4, 4, true, true));
        StringBuilder str = new StringBuilder();
        str.append(Messages.PlatformDetailsDialog_0);
        str.append(this.platform.getName());
        str.append('\n');
        str.append(Messages.PlatformDetailsDialog_1);
        List boards = this.platform.getBoards();
        Collections.sort(boards, new Comparator<ArduinoBoard>(){

            @Override
            public int compare(ArduinoBoard o1, ArduinoBoard o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (ArduinoBoard board : this.platform.getBoards()) {
            str.append("   ");
            str.append(board.getName());
            str.append('\n');
        }
        text.setText(str.toString());
        return control;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }
}

