/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.cdt.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.concurrent.Sequence;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IBreakpoints;
import org.eclipse.cdt.dsf.debug.service.IBreakpointsExtension;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControl;
import org.eclipse.cdt.dsf.gdb.internal.tracepointactions.ITracepointAction;
import org.eclipse.cdt.dsf.gdb.internal.tracepointactions.TracepointActionManager;
import org.eclipse.cdt.dsf.mi.service.IMICommandControl;
import org.eclipse.cdt.dsf.mi.service.IMIRunControl;
import org.eclipse.cdt.dsf.mi.service.MIBreakpointDMData;
import org.eclipse.cdt.dsf.mi.service.MIBreakpoints;
import org.eclipse.cdt.dsf.mi.service.command.CommandFactory;
import org.eclipse.cdt.dsf.mi.service.command.output.CLITraceInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIBreakInsertInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIBreakListInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIBreakpoint;
import org.eclipse.cdt.dsf.mi.service.command.output.MIInfo;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class GDBBreakpoints_7_0
extends MIBreakpoints {
    private ICommandControl fConnection;
    private IMIRunControl fRunControl;
    private CommandFactory fCommandFactory;

    public GDBBreakpoints_7_0(DsfSession session) {
        super(session);
    }

    @Override
    public void initialize(final RequestMonitor rm) {
        super.initialize((RequestMonitor)new ImmediateRequestMonitor(rm){

            protected void handleSuccess() {
                GDBBreakpoints_7_0.this.doInitialize(rm);
            }
        });
    }

    private void doInitialize(RequestMonitor rm) {
        this.fConnection = (ICommandControl)this.getServicesTracker().getService(ICommandControl.class);
        this.fRunControl = (IMIRunControl)this.getServicesTracker().getService(IMIRunControl.class);
        this.fCommandFactory = ((IMICommandControl)this.getServicesTracker().getService(IMICommandControl.class)).getCommandFactory();
        this.register(new String[]{IBreakpoints.class.getName(), IBreakpointsExtension.class.getName(), MIBreakpoints.class.getName(), GDBBreakpoints_7_0.class.getName()}, new Hashtable());
        rm.done();
    }

    @Override
    public void shutdown(RequestMonitor requestMonitor) {
        this.unregister();
        super.shutdown(requestMonitor);
    }

    @Override
    protected void addBreakpoint(final IBreakpoints.IBreakpointsTargetDMContext context, Map<String, Object> attributes, final DataRequestMonitor<IBreakpoints.IBreakpointDMContext> finalRm) {
        final Map<Integer, MIBreakpointDMData> contextBreakpoints = this.getBreakpointMap(context);
        if (contextBreakpoints == null) {
            finalRm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, "Unknown breakpoint context", null));
            finalRm.done();
            return;
        }
        final String location = this.formatLocation(attributes);
        if (location.equals("")) {
            finalRm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, "Unknown breakpoint context", null));
            finalRm.done();
            return;
        }
        final Boolean enabled = (Boolean)this.getProperty(attributes, "org.eclipse.cdt.dsf.debug.breakpoint.isEnabled", true);
        final Boolean isTemporary = (Boolean)this.getProperty(attributes, "org.eclipse.cdt.dsf.debug.breakpoint.mi.isTemporary", false);
        final Boolean isHardware = (Boolean)this.getProperty(attributes, "org.eclipse.cdt.dsf.debug.breakpoint.mi.isHardware", false);
        final String condition = (String)this.getProperty(attributes, "org.eclipse.cdt.dsf.debug.breakpoint.condition", "");
        final Integer ignoreCount = (Integer)this.getProperty(attributes, "org.eclipse.cdt.dsf.debug.breakpoint.ignoreCount", 0);
        String threadId = (String)this.getProperty(attributes, "org.eclipse.cdt.dsf.debug.breakpoint.mi.threadId", "0");
        final int tid = Integer.parseInt(threadId);
        Sequence.Step insertBreakpointStep = new Sequence.Step(){

            public void execute(final RequestMonitor rm) {
                GDBBreakpoints_7_0.this.fConnection.queueCommand(GDBBreakpoints_7_0.this.fCommandFactory.createMIBreakInsert(context, isTemporary, isHardware, condition, ignoreCount, location, tid, enabled == false, false), (DataRequestMonitor)new DataRequestMonitor<MIBreakInsertInfo>((Executor)GDBBreakpoints_7_0.this.getExecutor(), rm){

                    protected void handleSuccess() {
                        if (((MIBreakInsertInfo)this.getData()).getMIBreakpoints().length == 0) {
                            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, "Breakpoint insertion failure", null));
                            rm.done();
                            return;
                        }
                        MIBreakpointDMData newBreakpoint = new MIBreakpointDMData(((MIBreakInsertInfo)this.getData()).getMIBreakpoints()[0]);
                        int reference = newBreakpoint.getNumber();
                        if (reference == -1) {
                            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, "Breakpoint insertion failure", null));
                            rm.done();
                            return;
                        }
                        contextBreakpoints.put(reference, newBreakpoint);
                        MIBreakpoints.MIBreakpointDMContext dmc = new MIBreakpoints.MIBreakpointDMContext(GDBBreakpoints_7_0.this, new IDMContext[]{context}, reference);
                        finalRm.setData((Object)dmc);
                        GDBBreakpoints_7_0.this.getSession().dispatchEvent((Object)new MIBreakpoints.BreakpointAddedEvent(GDBBreakpoints_7_0.this, dmc), GDBBreakpoints_7_0.this.getProperties());
                        rm.done();
                    }

                    protected void handleError() {
                        rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, "Breakpoint insertion failure", this.getStatus().getException()));
                        rm.done();
                    }
                });
            }
        };
        this.fRunControl.executeWithTargetAvailable((IDMContext)context, new Sequence.Step[]{insertBreakpointStep}, (RequestMonitor)finalRm);
    }

    @Override
    protected void addTracepoint(final IBreakpoints.IBreakpointsTargetDMContext context, final Map<String, Object> attributes, final DataRequestMonitor<IBreakpoints.IBreakpointDMContext> drm) {
        final Map<Integer, MIBreakpointDMData> contextBreakpoints = this.getBreakpointMap(context);
        if (contextBreakpoints == null) {
            drm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, "Unknown breakpoint context", null));
            drm.done();
            return;
        }
        String location = this.formatLocation(attributes);
        if (location.equals("")) {
            drm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, "Unknown breakpoint context", null));
            drm.done();
            return;
        }
        String condition = (String)this.getProperty(attributes, "org.eclipse.cdt.dsf.debug.breakpoint.condition", "");
        this.fConnection.queueCommand(this.fCommandFactory.createCLITrace(context, location, condition), (DataRequestMonitor)new DataRequestMonitor<CLITraceInfo>((Executor)this.getExecutor(), drm){

            protected void handleSuccess() {
                final Integer tpReference = ((CLITraceInfo)this.getData()).getTraceReference();
                if (tpReference == null) {
                    drm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, "Breakpoint insertion failure", null));
                    drm.done();
                    return;
                }
                GDBBreakpoints_7_0.this.fConnection.queueCommand(GDBBreakpoints_7_0.this.fCommandFactory.createMIBreakList(context), (DataRequestMonitor)new DataRequestMonitor<MIBreakListInfo>((Executor)GDBBreakpoints_7_0.this.getExecutor(), (RequestMonitor)drm){

                    protected void handleSuccess() {
                        MIBreakpoint[] breakpoints;
                        MIBreakpoint[] mIBreakpointArray = breakpoints = ((MIBreakListInfo)this.getData()).getMIBreakpoints();
                        int n = breakpoints.length;
                        int n2 = 0;
                        while (n2 < n) {
                            MIBreakpoint bp = mIBreakpointArray[n2];
                            if (bp.getNumber() == tpReference.intValue()) {
                                MIBreakpointDMData newBreakpoint = new MIBreakpointDMData(bp);
                                int reference = newBreakpoint.getNumber();
                                contextBreakpoints.put(reference, newBreakpoint);
                                MIBreakpoints.MIBreakpointDMContext dmc = new MIBreakpoints.MIBreakpointDMContext(GDBBreakpoints_7_0.this, new IDMContext[]{context}, reference);
                                drm.setData((Object)dmc);
                                GDBBreakpoints_7_0.this.getSession().dispatchEvent((Object)new MIBreakpoints.BreakpointAddedEvent(GDBBreakpoints_7_0.this, dmc), GDBBreakpoints_7_0.this.getProperties());
                                HashMap<String, Object> delta = new HashMap<String, Object>();
                                delta.put("org.eclipse.cdt.dsf.debug.breakpoint.isEnabled", GDBBreakpoints_7_0.this.getProperty(attributes, "org.eclipse.cdt.dsf.debug.breakpoint.isEnabled", true));
                                delta.put("org.eclipse.cdt.dsf.debug.breakpoint.passCount", GDBBreakpoints_7_0.this.getProperty(attributes, "org.eclipse.cdt.dsf.debug.breakpoint.passCount", 0));
                                delta.put("org.eclipse.cdt.dsf.debug.breakpoint.commands", GDBBreakpoints_7_0.this.getProperty(attributes, "org.eclipse.cdt.dsf.debug.breakpoint.commands", ""));
                                GDBBreakpoints_7_0.this.modifyBreakpoint(dmc, delta, (RequestMonitor)drm, false);
                                return;
                            }
                            ++n2;
                        }
                        drm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, "Breakpoint insertion failure", null));
                        drm.done();
                    }
                });
            }
        });
    }

    @Override
    protected void modifyBreakpoint(final IBreakpoints.IBreakpointDMContext dmc, final Map<String, Object> attributes, final RequestMonitor rm, final boolean generateUpdateEvent) {
        String commandsAttribute;
        MIBreakpoints.MIBreakpointDMContext breakpointCtx = (MIBreakpoints.MIBreakpointDMContext)dmc;
        IBreakpoints.IBreakpointsTargetDMContext context = (IBreakpoints.IBreakpointsTargetDMContext)DMContexts.getAncestorOfType((IDMContext)breakpointCtx, IBreakpoints.IBreakpointsTargetDMContext.class);
        Map<Integer, MIBreakpointDMData> contextBreakpoints = this.getBreakpointMap(context);
        int reference = breakpointCtx.getReference();
        MIBreakpointDMData breakpoint = contextBreakpoints.get(reference);
        int numberOfChanges = 0;
        CountingRequestMonitor countingRm = new CountingRequestMonitor((Executor)this.getExecutor(), rm){

            protected void handleCompleted() {
                GDBBreakpoints_7_0.super.modifyBreakpoint(dmc, attributes, rm, generateUpdateEvent);
            }
        };
        String passCountAttribute = "org.eclipse.cdt.dsf.debug.breakpoint.passCount";
        if (attributes.containsKey(passCountAttribute)) {
            Integer oldValue = breakpoint.getPassCount();
            Integer newValue = (Integer)attributes.get(passCountAttribute);
            if (newValue == null) {
                newValue = 0;
            }
            if (!oldValue.equals(newValue)) {
                this.changePassCount(context, reference, newValue, (RequestMonitor)countingRm);
                ++numberOfChanges;
            }
            attributes.remove(passCountAttribute);
        }
        if (attributes.containsKey(commandsAttribute = "org.eclipse.cdt.dsf.debug.breakpoint.commands") && breakpoint.getBreakpointType().equals("tracepoint")) {
            String oldValue = breakpoint.getCommands();
            String newValue = (String)attributes.get(commandsAttribute);
            if (newValue == null) {
                newValue = "";
            }
            if (!oldValue.equals(newValue)) {
                ITracepointAction[] actions = this.generateGdbCommands(newValue);
                ++numberOfChanges;
                this.changeActions(context, reference, newValue, actions, (RequestMonitor)countingRm);
            }
            attributes.remove(commandsAttribute);
        }
        countingRm.setDoneCount(numberOfChanges);
    }

    private ITracepointAction[] generateGdbCommands(String actionStr) {
        String[] actionNames = actionStr.split("%_#");
        ITracepointAction[] actions = new ITracepointAction[actionNames.length];
        TracepointActionManager actionManager = TracepointActionManager.getInstance();
        int i = 0;
        while (i < actionNames.length) {
            actions[i] = actionManager.findAction(actionNames[i]);
            ++i;
        }
        return actions;
    }

    private void changeActions(IBreakpoints.IBreakpointsTargetDMContext context, final int reference, final String actionNames, ITracepointAction[] actions, final RequestMonitor rm) {
        final Map<Integer, MIBreakpointDMData> contextBreakpoints = this.getBreakpointMap(context);
        if (contextBreakpoints == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, "Unknown breakpoint context", null));
            rm.done();
            return;
        }
        ArrayList<String> actionStrings = new ArrayList<String>();
        ITracepointAction[] iTracepointActionArray = actions;
        int n = actions.length;
        int n2 = 0;
        while (n2 < n) {
            ITracepointAction action = iTracepointActionArray[n2];
            if (action != null) {
                actionStrings.add(action.getSummary());
            }
            ++n2;
        }
        this.fConnection.queueCommand(this.fCommandFactory.createMIBreakCommands(context, reference, actionStrings.toArray(new String[0])), (DataRequestMonitor)new DataRequestMonitor<MIInfo>((Executor)this.getExecutor(), rm){

            protected void handleSuccess() {
                MIBreakpointDMData breakpoint = (MIBreakpointDMData)contextBreakpoints.get(reference);
                if (breakpoint == null) {
                    rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, "Unknown breakpoint", null));
                    rm.done();
                    return;
                }
                breakpoint.setCommands(actionNames);
                rm.done();
            }
        });
    }

    @Override
    protected void changeIgnoreCount(IBreakpoints.IBreakpointsTargetDMContext context, int reference, int ignoreCount, RequestMonitor rm) {
        Map<Integer, MIBreakpointDMData> contextBreakpoints = this.getBreakpointMap(context);
        if (contextBreakpoints == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, "Unknown breakpoint context", null));
            rm.done();
            return;
        }
        MIBreakpointDMData breakpoint = contextBreakpoints.get(reference);
        if (breakpoint == null || breakpoint.getBreakpointType().equals("tracepoint")) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, "Invalid breakpoint type", null));
            rm.done();
            return;
        }
        super.changeIgnoreCount(context, reference, ignoreCount, rm);
    }

    protected void changePassCount(IBreakpoints.IBreakpointsTargetDMContext context, int reference, final int ignoreCount, final RequestMonitor rm) {
        Map<Integer, MIBreakpointDMData> contextBreakpoints = this.getBreakpointMap(context);
        if (contextBreakpoints == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, "Unknown breakpoint context", null));
            rm.done();
            return;
        }
        final MIBreakpointDMData breakpoint = contextBreakpoints.get(reference);
        if (breakpoint == null || !breakpoint.getBreakpointType().equals("tracepoint")) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, "Invalid breakpoint type", null));
            rm.done();
            return;
        }
        this.fConnection.queueCommand(this.fCommandFactory.createCLIPasscount(context, reference, ignoreCount), (DataRequestMonitor)new DataRequestMonitor<MIInfo>((Executor)this.getExecutor(), rm){

            protected void handleSuccess() {
                breakpoint.setPassCount(ignoreCount);
                rm.done();
            }
        });
    }
}

