/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.xlc.core.scannerconfig;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.core.ProblemMarkerInfo;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.internal.core.MakeMessages;
import org.eclipse.cdt.make.internal.core.scannerconfig.util.CCommandDSC;
import org.eclipse.cdt.make.internal.core.scannerconfig.util.KVStringPair;
import org.eclipse.cdt.make.internal.core.scannerconfig.util.SCDOptionsEnum;
import org.eclipse.cdt.make.internal.core.scannerconfig.util.TraceUtil;
import org.eclipse.cdt.make.xlc.core.scannerconfig.util.XLCCommandDSC;
import org.eclipse.cdt.utils.EFSExtensionManager;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;

public class XLCBuildOutputParserUtility {
    private List commandsList2;
    private int commandsN = 0;
    private List compiledFileList;
    private Map directoryCommandListMap;
    private IPath fBaseDirectory;
    private String fDefaultMacroDefinitionValue = "1";
    private Vector<IPath> fDirectoryStack = new Vector();
    private ArrayList<Problem> fErrors = new ArrayList();
    private int filesN = 0;
    private IMarkerGenerator fMarkerGenerator;
    private IProject project;
    private int workingDirsN = 0;
    private Map<String, IFile> fFilesInProject;
    private List<String> fCollectedFiles;
    private List<String> fNameConflicts;

    public static IPath convertCygpath(IPath path) {
        if (path.segmentCount() > 1 && path.segment(0).equals("cygdrive")) {
            StringBuffer buf = new StringBuffer(2);
            buf.append(Character.toUpperCase(path.segment(1).charAt(0)));
            buf.append(':');
            path = path.removeFirstSegments(2);
            path = path.setDevice(buf.toString());
            path = path.makeAbsolute();
        }
        return path;
    }

    protected XLCBuildOutputParserUtility(IPath baseDirectory, IPath workingDirectory) {
        this.fBaseDirectory = baseDirectory;
        if (workingDirectory != null) {
            this.pushDirectory(workingDirectory);
        }
    }

    public XLCBuildOutputParserUtility(IProject project, IPath workingDirectory, IMarkerGenerator markerGenerator) {
        this.project = project;
        this.fBaseDirectory = this.getPathForResource((IResource)project);
        if (workingDirectory != null) {
            this.pushDirectory(workingDirectory);
        }
    }

    private IPath getPathForResource(IResource resource) {
        URI locationURI = resource.getLocationURI();
        Path path = new Path(locationURI.getPath());
        return path;
    }

    void addGenericCommandForFile(String longFileName, String genericCommand) {
        if (this.compiledFileList.contains(longFileName)) {
            return;
        }
        this.compiledFileList.add(longFileName);
        String workingDir = this.getWorkingDirectory().toString();
        ArrayList directoryCommandList = (ArrayList)this.directoryCommandListMap.get(workingDir);
        if (directoryCommandList == null) {
            directoryCommandList = new ArrayList();
            this.directoryCommandListMap.put(workingDir, directoryCommandList);
            ++this.workingDirsN;
        }
        Object var5_5 = null;
        for (Map map : directoryCommandList) {
            List fileList = (List)map.get(genericCommand);
            if (fileList == null) continue;
            if (!fileList.contains(longFileName)) {
                fileList.add(longFileName);
                ++this.filesN;
            }
            return;
        }
        HashMap hashMap = new HashMap(1);
        directoryCommandList.add(hashMap);
        ++this.commandsN;
        ArrayList<String> fileList = new ArrayList<String>();
        hashMap.put(genericCommand, fileList);
        fileList.add(longFileName);
        ++this.filesN;
    }

    void addGenericCommandForFile2(String longFileName, String genericLine) {
        if (this.compiledFileList.contains(longFileName)) {
            return;
        }
        this.compiledFileList.add(longFileName);
        String[] tokens = genericLine.split("\\s+");
        CCommandDSC command = this.getNewCCommandDSC(tokens, 0, false);
        int index = this.commandsList2.indexOf(command);
        if (index == -1) {
            this.commandsList2.add(command);
            ++this.commandsN;
        } else {
            command = (CCommandDSC)this.commandsList2.get(index);
        }
    }

    public void changeMakeDirectory(String dir, int dirLevel, boolean enterDir) {
        if (enterDir) {
            int parseLevel = this.getDirectoryLevel();
            while (dirLevel < parseLevel) {
                this.popDirectory();
                parseLevel = this.getDirectoryLevel();
            }
            this.pushDirectory((IPath)new Path(dir));
        } else {
            this.popDirectory();
        }
    }

    public void generateMarker(IResource file, int lineNumber, String desc, int severity, String varName) {
        if (this.fMarkerGenerator != null) {
            Problem problem = new Problem(file, lineNumber, desc, severity, varName);
            this.fErrors.add(problem);
        }
    }

    void generateReport() {
        TraceUtil.metricsTrace((String)"Stats for directory ", (String)"Generic command: '", (String)"' applicable for:", (Map)this.directoryCommandListMap);
        TraceUtil.summaryTrace((String)"Discovery summary", (int)this.workingDirsN, (int)this.commandsN, (int)this.filesN);
    }

    public IPath getAbsolutePath(String filePath) {
        Path pFilePath;
        if (filePath.startsWith("/")) {
            return XLCBuildOutputParserUtility.convertCygpath((IPath)new Path(filePath));
        }
        if (filePath.startsWith("\\") || !filePath.startsWith(".") && filePath.length() > 2 && filePath.charAt(1) == ':' && (filePath.charAt(2) == '\\' || filePath.charAt(2) == '/')) {
            pFilePath = new Path(filePath);
        } else {
            IPath cwd = this.getWorkingDirectory();
            if (!cwd.isAbsolute()) {
                cwd = this.getBaseDirectory().append(cwd);
            }
            if (filePath.startsWith("`pwd`")) {
                filePath = filePath.length() > 5 && (filePath.charAt(5) == '/' || filePath.charAt(5) == '\\') ? filePath.substring(6) : filePath.substring(5);
            }
            pFilePath = cwd.append(filePath);
        }
        return pFilePath;
    }

    public IPath getBaseDirectory() {
        return this.fBaseDirectory;
    }

    public List getCCommandDSCList() {
        return new ArrayList(this.commandsList2);
    }

    protected int getDirectoryLevel() {
        return this.fDirectoryStack.size();
    }

    protected Vector<IPath> getDirectoryStack() {
        return this.fDirectoryStack;
    }

    protected ArrayList<Problem> getErrors() {
        return this.fErrors;
    }

    protected IMarkerGenerator getMarkerGenerator() {
        return this.fMarkerGenerator;
    }

    public CCommandDSC getNewCCommandDSC(String[] tokens, int idxOfCompilerCommand, boolean cppFileType) {
        ArrayList<KVStringPair> dirafter = new ArrayList<KVStringPair>();
        ArrayList<String> includes = new ArrayList<String>();
        XLCCommandDSC command = new XLCCommandDSC(cppFileType, this.getProject());
        command.addSCOption(new KVStringPair(SCDOptionsEnum.COMMAND.toString(), tokens[idxOfCompilerCommand]));
        int i = idxOfCompilerCommand + 1;
        while (i < tokens.length) {
            String token = tokens[i];
            if (token.startsWith("-m") || token.equals("-ansi") || token.equals("-posix") || token.equals("-pthread") || token.startsWith("-O") || token.equals("-fno-inline") || token.startsWith("-finline") || token.equals("-fno-exceptions") || token.equals("-fexceptions") || token.equals("-fshort-wchar") || token.equals("-fshort-double") || token.equals("-fno-signed-char") || token.equals("-fsigned-char") || token.startsWith("-fabi-version=")) {
                command.addSCOption(new KVStringPair(SCDOptionsEnum.COMMAND.toString(), token));
            } else {
                int j = 1;
                while (j <= 14) {
                    SCDOptionsEnum optionKind = SCDOptionsEnum.getSCDOptionsEnum((int)j);
                    if (token.startsWith(optionKind.toString())) {
                        KVStringPair pair;
                        String option2 = token.substring(optionKind.toString().length()).trim();
                        if (option2.length() <= 0) {
                            if (optionKind.equals((Object)SCDOptionsEnum.IDASH)) {
                                for (String option2 : includes) {
                                    KVStringPair pair2 = new KVStringPair(SCDOptionsEnum.IQUOTE.toString(), option2);
                                    command.addSCOption(pair2);
                                }
                                includes = new ArrayList();
                            } else {
                                if (i + 1 >= tokens.length || tokens[i + 1].startsWith("-")) break;
                                option2 = tokens[++i];
                            }
                        }
                        if (option2.length() > 0 && (optionKind.equals((Object)SCDOptionsEnum.INCLUDE) || optionKind.equals((Object)SCDOptionsEnum.INCLUDE_FILE) || optionKind.equals((Object)SCDOptionsEnum.IMACROS_FILE) || optionKind.equals((Object)SCDOptionsEnum.IDIRAFTER) || optionKind.equals((Object)SCDOptionsEnum.ISYSTEM) || optionKind.equals((Object)SCDOptionsEnum.IQUOTE))) {
                            option2 = this.getAbsolutePath(option2).toString();
                        }
                        if (optionKind.equals((Object)SCDOptionsEnum.IDIRAFTER)) {
                            pair = new KVStringPair(SCDOptionsEnum.INCLUDE.toString(), option2);
                            dirafter.add(pair);
                            break;
                        }
                        if (optionKind.equals((Object)SCDOptionsEnum.INCLUDE)) {
                            includes.add(option2);
                            break;
                        }
                        if (optionKind.equals((Object)SCDOptionsEnum.DEFINE) && option2.indexOf(61) == -1) {
                            option2 = String.valueOf(option2) + '=' + this.fDefaultMacroDefinitionValue;
                        }
                        pair = new KVStringPair(optionKind.toString(), option2);
                        command.addSCOption(pair);
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        for (String option : includes) {
            KVStringPair pair = new KVStringPair(SCDOptionsEnum.INCLUDE.toString(), option);
            command.addSCOption(pair);
        }
        Iterator iter = dirafter.iterator();
        while (iter.hasNext()) {
            command.addSCOption((KVStringPair)iter.next());
        }
        return command;
    }

    protected IProject getProject() {
        return this.project;
    }

    public IPath getWorkingDirectory() {
        if (this.fDirectoryStack.size() != 0) {
            return this.fDirectoryStack.lastElement();
        }
        return this.fBaseDirectory;
    }

    protected IPath popDirectory() {
        int i = this.getDirectoryLevel();
        if (i != 0) {
            IPath dir = this.fDirectoryStack.lastElement();
            this.fDirectoryStack.removeElementAt(i - 1);
            return dir;
        }
        return new Path("");
    }

    protected void pushDirectory(IPath dir) {
        if (dir != null) {
            IPath pwd = null;
            pwd = this.fBaseDirectory != null && this.fBaseDirectory.isPrefixOf(dir) ? dir.removeFirstSegments(this.fBaseDirectory.segmentCount()) : XLCBuildOutputParserUtility.convertCygpath(dir);
            this.fDirectoryStack.addElement(pwd);
        }
    }

    public boolean reportProblems() {
        boolean reset = false;
        for (Problem problem : this.fErrors) {
            if (problem.severity == 3) {
                reset = true;
            }
            if (problem.file == null) {
                this.fMarkerGenerator.addMarker(new ProblemMarkerInfo((IResource)this.project, problem.lineNumber, problem.description, problem.severity, problem.variableName));
                continue;
            }
            this.fMarkerGenerator.addMarker(new ProblemMarkerInfo(problem.file, problem.lineNumber, problem.description, problem.severity, problem.variableName));
        }
        this.fErrors.clear();
        return reset;
    }

    public void setDefaultMacroDefinitionValue(String val) {
        if (val != null) {
            this.fDefaultMacroDefinitionValue = val;
        }
    }

    public String getDefaultMacroDefinitionValue() {
        return this.fDefaultMacroDefinitionValue;
    }

    public String normalizePath(String path) {
        int sdot;
        char driveLetter;
        int column = path.indexOf(58);
        if (column > 0 && Character.isLowerCase(driveLetter = path.charAt(column - 1))) {
            StringBuffer sb = new StringBuffer();
            if (column - 1 > 0) {
                sb.append(path.substring(0, column - 1));
            }
            sb.append(Character.toUpperCase(driveLetter));
            sb.append(path.substring(column));
            path = sb.toString();
        }
        if (path.indexOf(46) == -1 || path.equals(".")) {
            return new Path(path).toString();
        }
        StringBuffer buf = new StringBuffer(path);
        int len = buf.length();
        StringBuffer newBuf = new StringBuffer(buf.length());
        int scp = 0;
        int ssp = 0;
        while (ssp < len && (sdot = buf.indexOf(".", ssp)) != -1) {
            boolean validPrefix = false;
            int ddot = buf.indexOf("..", ssp);
            if (sdot < ddot || ddot == -1) {
                newBuf.append(buf.substring(scp, sdot));
                scp = sdot;
                ssp = sdot + 1;
                if (ssp >= len) continue;
                if (sdot == 0 || buf.charAt(sdot - 1) == '/' || buf.charAt(sdot - 1) == '\\') {
                    validPrefix = true;
                }
                char nextChar = buf.charAt(ssp);
                if (validPrefix && nextChar == '/') {
                    scp = ++ssp;
                    continue;
                }
                if (validPrefix && nextChar == '\\') {
                    if (++ssp < len - 1 && buf.charAt(ssp) == '\\') {
                        ++ssp;
                    }
                    scp = ssp;
                    continue;
                }
                scp = ssp - 1;
                continue;
            }
            if (sdot != ddot) continue;
            ssp = sdot + 2;
        }
        newBuf.append(buf.substring(scp, len));
        Path orgPath = new Path(newBuf.toString());
        return orgPath.toString();
    }

    public IFile findFile(String fileName) {
        IFile file = this.findFilePath(fileName);
        if (file == null && (file = this.findFileName(fileName)) != null && this.isConflictingName(fileName)) {
            file = null;
            String error = MakeMessages.getString((String)"ConsoleParser.Ambiguous_Filepath_Error_Message");
            TraceUtil.outputError((String)error, (String)fileName);
            this.generateMarker((IResource)this.getProject(), -1, String.valueOf(error) + fileName, 1, null);
        }
        return file;
    }

    protected IFile findFilePath(String filePath) {
        IPath path = null;
        Path fp = new Path(filePath);
        if (fp.isAbsolute()) {
            if (this.getBaseDirectory().isPrefixOf((IPath)fp)) {
                int segments = this.getBaseDirectory().matchingFirstSegments((IPath)fp);
                path = fp.removeFirstSegments(segments);
            } else {
                path = fp;
            }
        } else {
            path = this.getWorkingDirectory().append(filePath);
        }
        IFile file = null;
        try {
            file = this.findFileInWorkspace(path);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (file == null || !file.exists()) {
            File f = path.toFile();
            try {
                String canon = f.getCanonicalPath();
                path = new Path(canon);
                file = this.findFileInWorkspace(path);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return file != null && file.exists() ? file : null;
    }

    protected IFile findFileName(String fileName) {
        Path path = new Path(fileName);
        return this.fFilesInProject.get(path.lastSegment());
    }

    protected IFile findFileInWorkspace(IPath path) {
        IFile file = null;
        if (path.isAbsolute()) {
            IWorkspaceRoot root = this.getProject().getWorkspace().getRoot();
            URI projectURI = this.project.getLocationURI();
            URI newURI = EFSExtensionManager.getDefault().createNewURIFromPath(projectURI, path.toString());
            IFile[] files = root.findFilesForLocationURI(newURI);
            int i = 0;
            while (i < files.length) {
                if (files[i].getProject().equals((Object)this.getProject())) {
                    file = files[i];
                    break;
                }
                ++i;
            }
        } else {
            file = this.getProject().getFile(path);
        }
        return file;
    }

    protected void collectFiles(IContainer parent, List result) {
        try {
            IResource[] resources = parent.members();
            int i = 0;
            while (i < resources.length) {
                IResource resource = resources[i];
                if (resource instanceof IFile) {
                    result.add(resource);
                } else if (resource instanceof IContainer) {
                    this.collectFiles((IContainer)resource, result);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            MakeCorePlugin.log((IStatus)e.getStatus());
        }
    }

    protected boolean isConflictingName(String fileName) {
        Path path = new Path(fileName);
        return this.fNameConflicts.contains(path.lastSegment());
    }

    public List translateRelativePaths(IFile file, String fileName, List includes) {
        ArrayList<String> translatedIncludes = new ArrayList<String>(includes.size());
        for (String include : includes) {
            Path includePath = new Path(include);
            if (!includePath.isAbsolute() && !includePath.isUNC()) {
                Path filePath;
                IPath cwd = this.getWorkingDirectory();
                if (!cwd.isAbsolute()) {
                    cwd = this.getBaseDirectory().append(cwd);
                }
                if (!(filePath = new Path(fileName)).isAbsolute()) {
                    filePath = cwd.append(fileName);
                }
                if (!filePath.toString().equalsIgnoreCase(file.getLocation().toString())) {
                    IPath lastFileSegment;
                    if (fileName.startsWith("..")) {
                        String error = MakeMessages.getString((String)"ConsoleParser.Working_Directory_Error_Message");
                        TraceUtil.outputError((String)error, (String)fileName);
                        this.generateMarker((IResource)file, -1, error, 1, fileName);
                        break;
                    }
                    Path tPath = new Path(fileName);
                    if (fileName.startsWith(".")) {
                        tPath = tPath.removeFirstSegments(1);
                    }
                    if ((lastFileSegment = (filePath = file.getLocation()).removeFirstSegments(filePath.segmentCount() - tPath.segmentCount())).matchingFirstSegments((IPath)tPath) == tPath.segmentCount()) {
                        cwd = filePath.removeLastSegments(tPath.segmentCount());
                    }
                }
                IPath candidatePath = cwd.append((IPath)includePath);
                File dir = candidatePath.toFile();
                include = candidatePath.toString();
                if (!dir.exists()) {
                    String error = MakeMessages.getString((String)"ConsoleParser.Nonexistent_Include_Path_Error_Message");
                    TraceUtil.outputError((String)error, (String)include);
                }
            }
            translatedIncludes.add(include);
        }
        return translatedIncludes;
    }

    protected class Problem {
        protected String description;
        protected IResource file;
        protected int lineNumber;
        protected int severity;
        protected String variableName;

        public Problem(IResource file, int lineNumber, String desciption, int severity, String variableName) {
            this.file = file;
            this.lineNumber = lineNumber;
            this.description = desciption;
            this.severity = severity;
            this.variableName = variableName;
        }
    }
}

