/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.qt.core.pdom;

import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTLiteralExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateInstance;
import org.eclipse.cdt.internal.qt.core.ASTUtil;
import org.eclipse.cdt.internal.qt.core.pdom.ASTDelegatedName;
import org.eclipse.cdt.internal.qt.core.pdom.IQtASTName;
import org.eclipse.cdt.internal.qt.core.pdom.QtPDOMBinding;
import org.eclipse.cdt.internal.qt.core.pdom.QtPDOMLinkage;
import org.eclipse.cdt.internal.qt.core.pdom.QtPDOMQmlRegistration;
import org.eclipse.cdt.internal.qt.core.pdom.QtPDOMQmlUncreatable;
import org.eclipse.cdt.qt.core.index.IQmlRegistration;
import org.eclipse.core.runtime.CoreException;

public class QmlTypeRegistration
extends ASTDelegatedName
implements IQtASTName {
    private final ICPPTemplateInstance functionInstanceBinding;
    private final IASTFunctionCallExpression fnCall;
    private final IQmlRegistration.Kind kind;
    private char[] simpleID;

    public QmlTypeRegistration(IASTName ast, ICPPTemplateInstance functionInstanceBinding, IASTFunctionCallExpression fnCall) {
        super(ast);
        this.functionInstanceBinding = functionInstanceBinding;
        this.fnCall = fnCall;
        this.kind = "qmlRegisterUncreatableType".equals(functionInstanceBinding.getName()) ? IQmlRegistration.Kind.Uncreatable : IQmlRegistration.Kind.Type;
    }

    @Override
    public char[] getSimpleID() {
        if (this.simpleID == null) {
            IASTInitializerClause[] args = this.fnCall.getArguments();
            this.simpleID = (String.valueOf(this.functionInstanceBinding.getName()) + ASTTypeUtil.getArgumentListString((ICPPTemplateArgument[])this.functionInstanceBinding.getTemplateArguments(), (boolean)true) + "\u0000(" + this.asStringForName(args, 0) + ',' + this.asStringForName(args, 1) + ',' + this.asStringForName(args, 2) + ',' + this.asStringForName(args, 3) + ')').toCharArray();
        }
        return this.simpleID;
    }

    @Override
    public QtPDOMBinding createPDOMBinding(QtPDOMLinkage linkage) throws CoreException {
        switch (this.kind) {
            case Type: {
                return new QtPDOMQmlRegistration(linkage, this, this.delegate);
            }
            case Uncreatable: {
                return new QtPDOMQmlUncreatable(linkage, this, this.delegate);
            }
        }
        return null;
    }

    public String getQObjectName() {
        ICPPTemplateArgument[] args = this.functionInstanceBinding.getTemplateArguments();
        if (args.length < 1) {
            return null;
        }
        IType type = args[0].getTypeValue();
        return type instanceof ICPPBinding ? ASTUtil.getFullyQualifiedName((IBinding)((ICPPBinding)type)) : null;
    }

    public Long getVersion() {
        ICPPTemplateArgument[] args = this.functionInstanceBinding.getTemplateArguments();
        if (args.length < 2) {
            return null;
        }
        IValue val = args[1].getNonTypeValue();
        return val == null ? null : val.numericalValue();
    }

    public String getUri() {
        return this.getArgAsStringOrNull(0);
    }

    public Long getMajor() {
        return this.getArgAsLongOrNull(1);
    }

    public Long getMinor() {
        return this.getArgAsLongOrNull(2);
    }

    public String getQmlName() {
        return this.getArgAsStringOrNull(3);
    }

    public String getReason() {
        return this.getArgAsStringOrNull(4);
    }

    private String asStringForName(IASTInitializerClause[] args, int index) {
        String arg = args.length <= index ? null : QmlTypeRegistration.asString(args[index]);
        return arg == null ? "" : arg;
    }

    private String getArgAsStringOrNull(int index) {
        IASTInitializerClause[] args = this.fnCall.getArguments();
        if (args.length <= index) {
            return null;
        }
        return QmlTypeRegistration.asString(args[index]);
    }

    private Long getArgAsLongOrNull(int index) {
        IASTInitializerClause[] args = this.fnCall.getArguments();
        if (args.length <= index) {
            return null;
        }
        String str = QmlTypeRegistration.asString(args[index]);
        if (str != null) {
            try {
                return Long.parseLong(str);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    private static String asString(IASTInitializerClause init) {
        if (init instanceof IASTLiteralExpression) {
            IASTLiteralExpression literal = (IASTLiteralExpression)init;
            switch (literal.getKind()) {
                case 0: {
                    return new String(literal.getValue());
                }
                case 3: {
                    char[] value = literal.getValue();
                    return new String(value, 1, value.length - 2);
                }
            }
        }
        return null;
    }
}

