/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameterPackType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.internal.core.dom.parser.Value;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFixed;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalParameterPack;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalTypeId;
import org.eclipse.core.runtime.Assert;

public class CPPTemplateNonTypeArgument
implements ICPPTemplateArgument {
    private final ICPPEvaluation fEvaluation;

    public CPPTemplateNonTypeArgument(ICPPEvaluation evaluation, IASTNode point) {
        IValue value;
        Assert.isNotNull((Object)evaluation);
        this.fEvaluation = evaluation instanceof EvalFixed || point == null || evaluation.isTypeDependent() || evaluation.isValueDependent() ? evaluation : ((value = evaluation.getValue(point)) == Value.ERROR ? EvalFixed.INCOMPLETE : new EvalFixed(evaluation.getType(point), evaluation.getValueCategory(point), value));
    }

    public CPPTemplateNonTypeArgument(IValue value, IType type) {
        this.fEvaluation = new EvalFixed(type, IASTExpression.ValueCategory.PRVALUE, value);
    }

    @Override
    public boolean isTypeValue() {
        return false;
    }

    @Override
    public IType getOriginalTypeValue() {
        return null;
    }

    @Override
    public boolean isNonTypeValue() {
        return true;
    }

    @Override
    public IType getTypeValue() {
        return null;
    }

    @Override
    public ICPPEvaluation getNonTypeEvaluation() {
        return this.fEvaluation;
    }

    @Override
    public IValue getNonTypeValue() {
        return this.fEvaluation.getValue(null);
    }

    @Override
    public IType getTypeOfNonTypeValue() {
        return this.fEvaluation.getType(null);
    }

    @Override
    public boolean isPackExpansion() {
        return this.fEvaluation.getType(null) instanceof ICPPParameterPackType;
    }

    @Override
    public ICPPTemplateArgument getExpansionPattern() {
        IType t;
        IType type = this.fEvaluation.getType(null);
        if (type instanceof ICPPParameterPackType && (t = ((ICPPParameterPackType)type).getType()) != null) {
            ICPPEvaluation evaluation = this.fEvaluation instanceof EvalParameterPack ? ((EvalParameterPack)this.fEvaluation).getExpansionPattern() : new EvalTypeId(t, this.fEvaluation.getTemplateDefinition(), this.fEvaluation);
            return new CPPTemplateNonTypeArgument(evaluation, null);
        }
        return null;
    }

    @Override
    public boolean isSameValue(ICPPTemplateArgument arg) {
        return this.getNonTypeValue().equals(arg.getNonTypeValue());
    }

    public String toString() {
        return this.getNonTypeValue().toString();
    }
}

