/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.hidemethod;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTVisibilityLabel;
import org.eclipse.cdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.core.model.CoreModelUtil;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.ASTQueries;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.AccessContext;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.corext.util.CModelUtil;
import org.eclipse.cdt.internal.ui.editor.ITranslationUnitEditorInput;
import org.eclipse.cdt.internal.ui.refactoring.CRefactoring;
import org.eclipse.cdt.internal.ui.refactoring.ClassMemberInserter;
import org.eclipse.cdt.internal.ui.refactoring.ModificationCollector;
import org.eclipse.cdt.internal.ui.refactoring.hidemethod.HideMethodRefactoringDescriptor;
import org.eclipse.cdt.internal.ui.refactoring.hidemethod.Messages;
import org.eclipse.cdt.internal.ui.refactoring.utils.DefinitionFinder;
import org.eclipse.cdt.internal.ui.refactoring.utils.SelectionHelper;
import org.eclipse.cdt.internal.ui.refactoring.utils.VisibilityEnum;
import org.eclipse.cdt.internal.ui.util.EditorUtility;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;

public class HideMethodRefactoring
extends CRefactoring {
    public static final String ID = "org.eclipse.cdt.internal.ui.refactoring.hidemethod.HideMethodRefactoring";
    private IASTName methodName;
    private IASTDeclaration methodDeclaration;

    public HideMethodRefactoring(ICElement element, ISelection selection, ICProject project) {
        super(element, selection, project);
        this.name = Messages.HideMethodRefactoring_HIDE_METHOD;
    }

    @Override
    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)pm, (int)10);
        try {
            IASTCompositeTypeSpecifier classNode;
            IASTFunctionDeclarator declarator;
            super.checkInitialConditions((IProgressMonitor)sm.newChild(8));
            if (this.initStatus.hasFatalError()) {
                RefactoringStatus refactoringStatus = this.initStatus;
                return refactoringStatus;
            }
            if (HideMethodRefactoring.isProgressMonitorCanceled((IProgressMonitor)sm, this.initStatus)) {
                RefactoringStatus refactoringStatus = this.initStatus;
                return refactoringStatus;
            }
            List<IASTName> names = this.findAllMarkedNames();
            if (names.isEmpty()) {
                this.initStatus.addFatalError(Messages.HideMethodRefactoring_NoNameSelected);
                RefactoringStatus refactoringStatus = this.initStatus;
                return refactoringStatus;
            }
            IASTName name = names.get(names.size() - 1);
            this.methodName = DefinitionFinder.getMemberDeclaration(name, this.refactoringContext, (IProgressMonitor)sm.newChild(1));
            if (this.methodName == null) {
                this.initStatus.addFatalError(Messages.HideMethodRefactoring_NoMethodNameSelected);
                RefactoringStatus refactoringStatus = this.initStatus;
                return refactoringStatus;
            }
            IASTDeclarator decl = (IASTDeclarator)this.methodName.getParent();
            decl = CPPVisitor.findOutermostDeclarator((IASTDeclarator)decl);
            this.methodDeclaration = (IASTDeclaration)decl.getParent();
            if (this.methodDeclaration == null || !(this.methodDeclaration.getParent() instanceof ICPPASTCompositeTypeSpecifier)) {
                this.initStatus.addFatalError(Messages.HideMethodRefactoring_CanOnlyHideMethods);
                RefactoringStatus refactoringStatus = this.initStatus;
                return refactoringStatus;
            }
            if (HideMethodRefactoring.isProgressMonitorCanceled((IProgressMonitor)sm, this.initStatus)) {
                RefactoringStatus refactoringStatus = this.initStatus;
                return refactoringStatus;
            }
            if (this.methodDeclaration instanceof IASTFunctionDefinition) {
                declarator = ((IASTFunctionDefinition)this.methodDeclaration).getDeclarator();
                if (ASTQueries.findInnermostDeclarator((IASTDeclarator)declarator).getName().getRawSignature().equals(name.getRawSignature()) && !(declarator instanceof IASTFunctionDeclarator)) {
                    this.initStatus.addFatalError(Messages.HideMethodRefactoring_CanOnlyHideMethods);
                    RefactoringStatus refactoringStatus = this.initStatus;
                    return refactoringStatus;
                }
            } else if (this.methodDeclaration instanceof IASTSimpleDeclaration) {
                IASTDeclarator[] iASTDeclaratorArray = ((IASTSimpleDeclaration)this.methodDeclaration).getDeclarators();
                int n = iASTDeclaratorArray.length;
                int n2 = 0;
                while (n2 < n) {
                    declarator = iASTDeclaratorArray[n2];
                    if (declarator.getName().getRawSignature().equals(name.getRawSignature()) && !(declarator instanceof IASTFunctionDeclarator)) {
                        this.initStatus.addFatalError(Messages.HideMethodRefactoring_CanOnlyHideMethods);
                        RefactoringStatus refactoringStatus = this.initStatus;
                        return refactoringStatus;
                    }
                    ++n2;
                }
            } else {
                this.initStatus.addFatalError(Messages.HideMethodRefactoring_CanOnlyHideMethods);
                RefactoringStatus refactoringStatus = this.initStatus;
                return refactoringStatus;
            }
            if ((classNode = (IASTCompositeTypeSpecifier)ASTQueries.findAncestorWithType((IASTNode)this.methodName, IASTCompositeTypeSpecifier.class)) == null) {
                this.initStatus.addError(Messages.HideMethodRefactoring_EnclosingClassNotFound);
            }
            if (this.checkIfPrivate(classNode, this.methodDeclaration)) {
                this.initStatus.addError(Messages.HideMethodRefactoring_IsAlreadyPrivate);
            }
            RefactoringStatus refactoringStatus = this.initStatus;
            return refactoringStatus;
        }
        finally {
            sm.done();
        }
    }

    private boolean checkIfPrivate(IASTCompositeTypeSpecifier classNode, IASTDeclaration decl) {
        IASTDeclaration[] members = classNode.getMembers();
        int currentVisibility = 3;
        if (1 == classNode.getKey()) {
            currentVisibility = 1;
        }
        IASTDeclaration[] iASTDeclarationArray = members;
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            IASTDeclaration declaration = iASTDeclarationArray[n2];
            if (declaration instanceof ICPPASTVisibilityLabel) {
                currentVisibility = ((ICPPASTVisibilityLabel)declaration).getVisibility();
            }
            if (declaration != null && decl == declaration) break;
            ++n2;
        }
        return 3 == currentVisibility;
    }

    @Override
    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext checkContext) throws CoreException, OperationCanceledException {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)pm, (int)10);
        try {
            int n;
            RefactoringStatus status = new RefactoringStatus();
            IIndex index = this.getIndex();
            IIndexBinding methodBinding = index.adaptBinding(this.methodName.resolveBinding());
            if (methodBinding == null) {
                return null;
            }
            ArrayList references = new ArrayList();
            HashSet<String> searchedFiles = new HashSet<String>();
            IEditorPart[] dirtyEditors = EditorUtility.getDirtyEditors(true);
            SubMonitor loopProgress = sm.newChild(3).setWorkRemaining(dirtyEditors.length);
            IEditorPart[] iEditorPartArray = dirtyEditors;
            int n2 = dirtyEditors.length;
            int n3 = 0;
            while (n3 < n2) {
                IEditorPart editor = iEditorPartArray[n3];
                if (sm.isCanceled()) {
                    throw new OperationCanceledException();
                }
                IEditorInput editorInput = editor.getEditorInput();
                if (editorInput instanceof ITranslationUnitEditorInput) {
                    ITranslationUnit tu = CModelUtil.toWorkingCopy(((ITranslationUnitEditorInput)editorInput).getTranslationUnit());
                    searchedFiles.add(tu.getLocation().toOSString());
                    IASTTranslationUnit ast = this.getAST(tu, (IProgressMonitor)loopProgress.newChild(1));
                    IASTName[] iASTNameArray = ast.getReferences((IBinding)methodBinding);
                    n = iASTNameArray.length;
                    int n4 = 0;
                    while (n4 < n) {
                        IASTName reference = iASTNameArray[n4];
                        if (!AccessContext.isAccessible((IBinding)methodBinding, (int)3, (IASTName)reference)) {
                            status.addWarning(Messages.HideMethodRefactoring_HasExternalReferences);
                            RefactoringStatus refactoringStatus = status;
                            return refactoringStatus;
                        }
                        ++n4;
                    }
                }
                ++n3;
            }
            IIndexName[] referencesFromIndex = index.findReferences((IBinding)methodBinding);
            int remainingCount = referencesFromIndex.length;
            loopProgress = sm.newChild(6).setWorkRemaining(remainingCount);
            IIndexName[] iIndexNameArray = referencesFromIndex;
            int n5 = referencesFromIndex.length;
            int n6 = 0;
            while (n6 < n5) {
                IIndexName name = iIndexNameArray[n6];
                if (sm.isCanceled()) {
                    throw new OperationCanceledException();
                }
                ITranslationUnit tu = CoreModelUtil.findTranslationUnitForLocation((IIndexFileLocation)name.getFile().getLocation(), null);
                if (searchedFiles.add(tu.getLocation().toOSString())) {
                    IASTTranslationUnit ast = this.getAST(tu, (IProgressMonitor)loopProgress.newChild(1));
                    IASTName[] iASTNameArray = ast.getReferences((IBinding)methodBinding);
                    int n7 = iASTNameArray.length;
                    n = 0;
                    while (n < n7) {
                        IASTName reference = iASTNameArray[n];
                        if (!AccessContext.isAccessible((IBinding)methodBinding, (int)3, (IASTName)reference)) {
                            status.addWarning(Messages.HideMethodRefactoring_HasExternalReferences);
                            RefactoringStatus refactoringStatus = status;
                            return refactoringStatus;
                        }
                        ++n;
                    }
                    ArrayUtil.addAll(references, (Object[])ast.getReferences((IBinding)methodBinding));
                }
                loopProgress.setWorkRemaining(--remainingCount);
                ++n6;
            }
            RefactoringStatus refactoringStatus = status;
            return refactoringStatus;
        }
        finally {
            sm.done();
        }
    }

    @Override
    protected void collectModifications(IProgressMonitor pm, ModificationCollector collector) throws CoreException, OperationCanceledException {
        ASTRewrite rewriter = collector.rewriterForTranslationUnit(this.methodName.getTranslationUnit());
        TextEditGroup editGroup = new TextEditGroup(String.valueOf(Messages.HideMethodRefactoring_FILE_CHANGE_TEXT) + this.methodName.getRawSignature());
        ICPPASTCompositeTypeSpecifier classDefinition = (ICPPASTCompositeTypeSpecifier)this.methodDeclaration.getParent();
        ClassMemberInserter.createChange(classDefinition, VisibilityEnum.v_private, (IASTNode)this.methodDeclaration, false, collector);
        rewriter.remove((IASTNode)this.methodDeclaration, editGroup);
    }

    private List<IASTName> findAllMarkedNames() throws OperationCanceledException, CoreException {
        final ArrayList<IASTName> namesVector = new ArrayList<IASTName>();
        IASTTranslationUnit ast = this.getAST(this.tu, null);
        ast.accept(new ASTVisitor(){
            {
                this.shouldVisitNames = true;
            }

            public int visit(IASTName name) {
                if (name.isPartOfTranslationUnitFile() && SelectionHelper.doesNodeOverlapWithRegion((IASTNode)name, HideMethodRefactoring.this.selectedRegion) && !(name instanceof ICPPASTQualifiedName)) {
                    namesVector.add(name);
                }
                return super.visit(name);
            }
        });
        return namesVector;
    }

    @Override
    protected RefactoringDescriptor getRefactoringDescriptor() {
        Map<String, String> arguments = this.getArgumentMap();
        HideMethodRefactoringDescriptor desc = new HideMethodRefactoringDescriptor(this.project.getProject().getName(), "Hide Method Refactoring", "Hide Method " + this.methodName.getRawSignature(), arguments);
        return desc;
    }

    private Map<String, String> getArgumentMap() {
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("fileName", this.tu.getLocationURI().toString());
        arguments.put("selection", String.valueOf(this.selectedRegion.getOffset()) + "," + this.selectedRegion.getLength());
        return arguments;
    }
}

