/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.dnd;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.cdt.internal.ui.CUIMessages;
import org.eclipse.cdt.internal.ui.dnd.TransferDragSourceListener;
import org.eclipse.cdt.internal.ui.util.ExceptionHandler;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class FileTransferDragAdapter
implements TransferDragSourceListener {
    private final ISelectionProvider provider;

    public FileTransferDragAdapter(ISelectionProvider provider) {
        this.provider = provider;
        Assert.isNotNull((Object)provider);
    }

    @Override
    public Transfer getTransfer() {
        return FileTransfer.getInstance();
    }

    public void dragStart(DragSourceEvent event) {
        event.doit = !this.getResources().isEmpty();
    }

    public void dragSetData(DragSourceEvent event) {
        event.data = FileTransferDragAdapter.getResourceLocations(this.getResources());
    }

    public void dragFinished(DragSourceEvent event) {
        if (event.doit && event.detail != 2 && (event.detail == 0 || event.detail == 8)) {
            FileTransferDragAdapter.runOperation((IRunnableWithProgress)new RefreshOperation(this.getResources()), true, false);
        }
    }

    private List<IResource> getResources() {
        List<IResource> result = Collections.emptyList();
        ISelection selection = this.provider.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structured = (IStructuredSelection)selection;
            result = new ArrayList<IResource>(structured.size());
            for (Object object : structured) {
                IResource resource = null;
                if (object instanceof IResource) {
                    resource = (IResource)object;
                } else if (object instanceof IAdaptable) {
                    resource = (IResource)((IAdaptable)object).getAdapter(IResource.class);
                }
                if (resource == null) continue;
                result.add(resource);
            }
        }
        return result;
    }

    private static String[] getResourceLocations(List<IResource> resources) {
        if (!resources.isEmpty()) {
            int count = resources.size();
            ArrayList<String> locations = new ArrayList<String>(count);
            for (IResource resource : resources) {
                IPath location = resource.getLocation();
                if (location == null) continue;
                locations.add(location.toOSString());
            }
            String[] result = new String[locations.size()];
            locations.toArray(result);
            return result;
        }
        return null;
    }

    private static void runOperation(IRunnableWithProgress operation, boolean fork, boolean cancelable) {
        try {
            IWorkbench workbench = CUIPlugin.getDefault().getWorkbench();
            IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
            Shell parent = window.getShell();
            new ProgressMonitorDialog(parent).run(fork, cancelable, operation);
        }
        catch (InterruptedException workbench) {
        }
        catch (InvocationTargetException e) {
            String message = CUIMessages.FileTransferDragAdapter_problem;
            String title = CUIMessages.FileTransferDragAdapter_problemTitle;
            ExceptionHandler.handle(e, title, message);
        }
    }

    private static class RefreshOperation
    extends WorkspaceModifyOperation {
        private final Set<IResource> roots;

        public RefreshOperation(List<IResource> resources) {
            this.roots = new HashSet<IResource>(resources.size());
            for (IResource resource : resources) {
                IContainer parent = resource.getParent();
                this.roots.add((IResource)(parent != null ? parent : resource));
            }
        }

        public void execute(IProgressMonitor monitor) throws CoreException {
            try {
                monitor.beginTask(CUIMessages.FileTransferDragAdapter_refreshing, this.roots.size());
                MultiStatus status = new MultiStatus(CUIPlugin.getPluginId(), 0, CUIMessages.FileTransferDragAdapter_problem, null);
                for (IResource resource : this.roots) {
                    try {
                        resource.refreshLocal(1, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    }
                    catch (CoreException e) {
                        status.add(e.getStatus());
                    }
                }
                if (!status.isOK()) {
                    throw new CoreException((IStatus)status);
                }
            }
            finally {
                monitor.done();
            }
        }
    }
}

