/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.service;

import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.cdt.debug.internal.core.sourcelookup.CSourceLookupDirector;
import org.eclipse.cdt.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.debug.service.ISourceLookup;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControl;
import org.eclipse.cdt.dsf.gdb.launching.GdbSourceLookupDirector;
import org.eclipse.cdt.dsf.gdb.service.IGDBSourceLookup;
import org.eclipse.cdt.dsf.mi.service.CSourceLookup;
import org.eclipse.cdt.dsf.mi.service.IMICommandControl;
import org.eclipse.cdt.dsf.mi.service.command.CommandFactory;
import org.eclipse.cdt.dsf.mi.service.command.output.MIInfo;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class GDBSourceLookup
extends CSourceLookup
implements IGDBSourceLookup {
    private ICommandControl fCommand;
    private CommandFactory fCommandFactory;
    private Map<ISourceLookup.ISourceLookupDMContext, CSourceLookupDirector> fDirectors = new HashMap<ISourceLookup.ISourceLookupDMContext, CSourceLookupDirector>();
    private Map<String, String> fCachedEntries = Collections.emptyMap();

    public GDBSourceLookup(DsfSession session) {
        super(session);
    }

    @Override
    public void initialize(final RequestMonitor rm) {
        super.initialize((RequestMonitor)new ImmediateRequestMonitor(rm){

            protected void handleSuccess() {
                GDBSourceLookup.this.doInitialize(rm);
            }
        });
    }

    private void doInitialize(RequestMonitor rm) {
        this.fCommand = (ICommandControl)this.getServicesTracker().getService(ICommandControl.class);
        this.fCommandFactory = ((IMICommandControl)this.getServicesTracker().getService(IMICommandControl.class)).getCommandFactory();
        this.register(new String[]{IGDBSourceLookup.class.getName(), GDBSourceLookup.class.getName()}, new Hashtable());
        rm.done();
    }

    @Override
    public void shutdown(RequestMonitor rm) {
        this.unregister();
        super.shutdown(rm);
    }

    @Override
    public void setSourceLookupDirector(ISourceLookup.ISourceLookupDMContext ctx, CSourceLookupDirector director) {
        this.fDirectors.put(ctx, director);
        super.setSourceLookupDirector(ctx, director);
    }

    @Override
    public void initializeSourceSubstitutions(ISourceLookup.ISourceLookupDMContext sourceLookupCtx, RequestMonitor rm) {
        if (!this.fDirectors.containsKey(sourceLookupCtx)) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "No source director configured for given context", null));
            rm.done();
            return;
        }
        this.setSubstitutePaths(sourceLookupCtx, this.getSubstitutionsPaths(sourceLookupCtx), rm);
    }

    private Map<String, String> getSubstitutionsPaths(ISourceLookup.ISourceLookupDMContext sourceLookupCtx) {
        CSourceLookupDirector director = this.fDirectors.get(sourceLookupCtx);
        if (director instanceof GdbSourceLookupDirector) {
            return ((GdbSourceLookupDirector)director).getSubstitutionsPaths();
        }
        return Collections.emptyMap();
    }

    @Override
    public void sourceContainersChanged(final ISourceLookup.ISourceLookupDMContext sourceLookupCtx, final DataRequestMonitor<Boolean> rm) {
        if (!this.fDirectors.containsKey(sourceLookupCtx)) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "No source director configured for given context", null));
            rm.done();
            return;
        }
        Map<String, String> entries = this.getSubstitutionsPaths(sourceLookupCtx);
        if (entries.equals(this.fCachedEntries)) {
            rm.done((Object)false);
        } else {
            this.fCommand.queueCommand(this.fCommandFactory.createCLIUnsetSubstitutePath(sourceLookupCtx), (DataRequestMonitor)new DataRequestMonitor<MIInfo>((Executor)this.getExecutor(), rm){

                protected void handleSuccess() {
                    GDBSourceLookup.this.initializeSourceSubstitutions(sourceLookupCtx, new RequestMonitor((Executor)GDBSourceLookup.this.getExecutor(), (RequestMonitor)rm){

                        protected void handleSuccess() {
                            rm.done((Object)true);
                        }
                    });
                }
            });
        }
    }

    protected void setSubstitutePaths(ISourceLookup.ISourceLookupDMContext sourceLookupCtx, Map<String, String> entries, final RequestMonitor rm) {
        this.fCachedEntries = entries;
        CountingRequestMonitor countingRm = new CountingRequestMonitor((Executor)this.getExecutor(), rm){

            protected void handleFailure() {
                GDBSourceLookup.this.fCachedEntries = null;
                rm.done();
            }
        };
        countingRm.setDoneCount(entries.size());
        for (Map.Entry<String, String> entry : entries.entrySet()) {
            this.fCommand.queueCommand(this.fCommandFactory.createMISetSubstitutePath(sourceLookupCtx, entry.getKey(), entry.getValue()), new DataRequestMonitor((Executor)this.getExecutor(), (RequestMonitor)countingRm));
        }
    }
}

