/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.ui.dnd;

import com.ibm.icu.text.MessageFormat;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.make.core.IMakeBuilderInfo;
import org.eclipse.cdt.make.core.IMakeCommonBuildInfo;
import org.eclipse.cdt.make.core.IMakeTarget;
import org.eclipse.cdt.make.core.IMakeTargetManager;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.cdt.make.ui.dialogs.MakeTargetDialog;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Shell;

public class MakeTargetDndUtil {
    private static final int RENAME_ID = 256;
    private static final int RENAME_TO_ALL_ID = 257;
    protected static int lastUserAnswer = 2;
    public static final String DEFAULT_BUILD_COMMAND = "make";

    public static String getProjectBuildCommand(IProject project) {
        IMakeTargetManager targetManager = MakeCorePlugin.getDefault().getTargetManager();
        String[] targetBuilders = targetManager.getTargetBuilders(project);
        if (targetBuilders == null || targetBuilders.length == 0) {
            return DEFAULT_BUILD_COMMAND;
        }
        String builderId = targetManager.getBuilderID(targetBuilders[0]);
        String buildCommand = DEFAULT_BUILD_COMMAND;
        try {
            IMakeBuilderInfo buildInfo = MakeCorePlugin.createBuildInfo((IProject)project, (String)builderId);
            buildCommand = buildInfo.getBuildCommand().toString().trim();
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return buildCommand;
    }

    public static boolean isDragable(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            List selectedElements = ((IStructuredSelection)selection).toList();
            if (selectedElements.size() == 0) {
                return false;
            }
            ArrayList<String> names = new ArrayList<String>(selectedElements.size());
            for (Object element : selectedElements) {
                if (!(element instanceof IMakeTarget)) {
                    return false;
                }
                String makeTargetName = ((IMakeTarget)element).getName();
                for (String name : names) {
                    if (makeTargetName != null && !makeTargetName.equals(name)) continue;
                    return false;
                }
                names.add(makeTargetName);
            }
            return true;
        }
        return false;
    }

    public static void copyTargets(IMakeTarget[] makeTargets, IContainer container, int operation, Shell shell) {
        if (makeTargets == null || makeTargets.length == 0 || container == null) {
            return;
        }
        lastUserAnswer = 2;
        if (makeTargets.length == 1) {
            try {
                MakeTargetDndUtil.copyOneTarget(makeTargets[0], container, operation, shell, false);
            }
            catch (CoreException e) {
                MakeUIPlugin.log(e);
            }
        } else if (makeTargets.length > 1) {
            MakeTargetDndUtil.copyTargetsWithProgressIndicator(makeTargets, container, operation, shell);
        }
    }

    public static void copyOneTarget(IMakeTarget makeTarget, IContainer container, int operation, Shell shell, boolean offerOverwriteDialog) throws CoreException {
        IMakeTargetManager makeTargetManager = MakeCorePlugin.getDefault().getTargetManager();
        IMakeTarget exists = makeTargetManager.findTarget(container, makeTarget.getName());
        if (exists != null) {
            int userAnswer = 1;
            userAnswer = offerOverwriteDialog ? MakeTargetDndUtil.overwriteMakeTargetDialog(makeTarget.getName(), shell) : 256;
            if (userAnswer == 2 || userAnswer == 4) {
                MakeTargetDndUtil.copyTargetData(makeTarget, exists);
                if (operation == 2) {
                    makeTargetManager.removeTarget(makeTarget);
                }
            } else if (userAnswer == 256 || userAnswer == 257) {
                String name = MakeTargetDndUtil.generateUniqueName(makeTarget.getName(), container);
                IMakeTarget newMakeTarget = MakeTargetDndUtil.cloneTarget(name, makeTarget, container.getProject());
                newMakeTarget.setContainer(container);
                int dialogReturnCode = 0;
                if (userAnswer == 256) {
                    try {
                        MakeTargetDialog dialog = new MakeTargetDialog(shell, newMakeTarget);
                        dialogReturnCode = dialog.open();
                    }
                    catch (CoreException e) {
                        MakeUIPlugin.errorDialog(shell, MakeUIPlugin.getResourceString("AddBuildTargetAction.exception.internal"), e.toString(), e);
                    }
                } else if (userAnswer == 257) {
                    makeTargetManager.addTarget(container, newMakeTarget);
                }
                if (operation == 2 && dialogReturnCode != 1) {
                    makeTargetManager.removeTarget(makeTarget);
                }
            }
        } else {
            makeTargetManager.addTarget(container, MakeTargetDndUtil.cloneTarget(makeTarget.getName(), makeTarget, container.getProject()));
            if (operation == 2) {
                makeTargetManager.removeTarget(makeTarget);
            }
        }
    }

    private static String generateUniqueName(String targetName, IContainer container) throws CoreException {
        String newName;
        IMakeTargetManager makeTargetManager = MakeCorePlugin.getDefault().getTargetManager();
        if (makeTargetManager.findTarget(container, newName = targetName) == null) {
            return newName;
        }
        newName = MessageFormat.format((String)MakeUIPlugin.getResourceString("MakeTargetDnD.copyOf.uniqueName"), (Object[])new Object[]{targetName});
        if (makeTargetManager.findTarget(container, newName) == null) {
            return newName;
        }
        int counter = 1;
        while (makeTargetManager.findTarget(container, newName = MessageFormat.format((String)MakeUIPlugin.getResourceString("MakeTargetDnD.countedCopyOf.uniqueName"), (Object[])new Object[]{counter, targetName})) != null) {
            ++counter;
        }
        return newName;
    }

    private static void copyTargetsWithProgressIndicator(final IMakeTarget[] makeTargets, final IContainer container, final int operation, final Shell shell) {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                boolean isMove = operation == 2;
                String textHeader = isMove ? MakeUIPlugin.getResourceString("MakeTargetDnD.moving") : MakeUIPlugin.getResourceString("MakeTargetDnD.copying");
                String textAction = isMove ? MakeUIPlugin.getResourceString("MakeTargetDnD.moving.one") : MakeUIPlugin.getResourceString("MakeTargetDnD.copying.one");
                monitor.beginTask(String.valueOf(textHeader) + ' ' + container.getName(), makeTargets.length - 1);
                IMakeTarget[] iMakeTargetArray = makeTargets;
                int n = makeTargets.length;
                int n2 = 0;
                while (n2 < n) {
                    IMakeTarget makeTarget = iMakeTargetArray[n2];
                    if (makeTarget != null) {
                        monitor.subTask(String.valueOf(textAction) + ' ' + makeTarget.getName());
                        try {
                            MakeTargetDndUtil.copyOneTarget(makeTarget, container, operation, shell, true);
                        }
                        catch (CoreException e) {
                            MakeUIPlugin.log(e);
                        }
                        if (lastUserAnswer == 1) break;
                    }
                    monitor.worked(1);
                    if (monitor.isCanceled()) break;
                    ++n2;
                }
                monitor.done();
                lastUserAnswer = 2;
            }
        };
        ProgressMonitorDialog context = new ProgressMonitorDialog(shell);
        try {
            context.run(false, true, runnable);
        }
        catch (InvocationTargetException e) {
            MakeUIPlugin.log(e);
        }
        catch (InterruptedException e) {
            MakeUIPlugin.log(e);
        }
    }

    private static int overwriteMakeTargetDialog(String name, Shell shell) {
        if (lastUserAnswer == 4 || lastUserAnswer == 21 || lastUserAnswer == 257) {
            return lastUserAnswer;
        }
        String[] labels = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, MakeUIPlugin.getResourceString("MakeTargetDnD.button.rename"), IDialogConstants.CANCEL_LABEL};
        String title = MakeUIPlugin.getResourceString("MakeTargetDnD.title.overwriteTargetConfirm");
        String question = MessageFormat.format((String)MakeUIPlugin.getResourceString("MakeTargetDnD.message.overwriteTargetConfirm"), (Object[])new Object[]{name});
        String toggleApplyToAll = MakeUIPlugin.getResourceString("MakeTargetDnD.toggle.applyToAll");
        MessageDialogWithToggle dialog = new MessageDialogWithToggle(shell, title, null, question, 3, labels, 0, toggleApplyToAll, false);
        try {
            dialog.open();
            lastUserAnswer = dialog.getReturnCode();
            boolean toAll = dialog.getToggleState();
            if (toAll && lastUserAnswer == 2) {
                lastUserAnswer = 4;
            } else if (toAll && lastUserAnswer == 3) {
                lastUserAnswer = 21;
            } else if (toAll && lastUserAnswer == 256) {
                lastUserAnswer = 257;
            }
        }
        catch (SWTException e) {
            MakeUIPlugin.log(e);
            lastUserAnswer = 1;
        }
        if (lastUserAnswer == -1) {
            lastUserAnswer = 1;
        }
        return lastUserAnswer;
    }

    private static IMakeTarget cloneTarget(String name, IMakeTarget makeTarget, IProject project) throws CoreException {
        IMakeTargetManager makeTargetManager = MakeCorePlugin.getDefault().getTargetManager();
        String[] ids = makeTargetManager.getTargetBuilders(project);
        String builderId = ids[0];
        IMakeTarget newMakeTarget = makeTargetManager.createTarget(project, name, builderId);
        MakeTargetDndUtil.copyTargetData(makeTarget, newMakeTarget);
        if (makeTarget.getName().equals(makeTarget.getBuildAttribute(IMakeTarget.BUILD_TARGET, ""))) {
            newMakeTarget.setBuildAttribute(IMakeTarget.BUILD_TARGET, name);
        }
        return newMakeTarget;
    }

    private static void copyTargetData(IMakeTarget source, IMakeTarget destination) throws CoreException {
        destination.setRunAllBuilders(source.runAllBuilders());
        destination.setAppendProjectEnvironment(source.appendProjectEnvironment());
        destination.setBuildAttribute(IMakeTarget.BUILD_TARGET, source.getBuildAttribute(IMakeTarget.BUILD_TARGET, ""));
        if (!source.isDefaultBuildCmd()) {
            destination.setBuildAttribute(IMakeCommonBuildInfo.BUILD_COMMAND, source.getBuildAttribute(IMakeCommonBuildInfo.BUILD_COMMAND, DEFAULT_BUILD_COMMAND));
            destination.setBuildAttribute(IMakeCommonBuildInfo.BUILD_ARGUMENTS, source.getBuildAttribute(IMakeCommonBuildInfo.BUILD_ARGUMENTS, ""));
        }
        destination.setStopOnError(source.isStopOnError());
        destination.setUseDefaultBuildCmd(source.isDefaultBuildCmd());
        destination.setEnvironment(source.getEnvironment());
        destination.setAppendEnvironment(source.appendEnvironment());
    }

    public static IMakeTarget createMakeTarget(String name, String targetStr, String command, IContainer container) throws CoreException {
        IMakeTargetManager makeTargetManager = MakeCorePlugin.getDefault().getTargetManager();
        IProject project = container.getProject();
        String[] ids = makeTargetManager.getTargetBuilders(project);
        String builderId = ids[0];
        IMakeTarget newMakeTarget = makeTargetManager.createTarget(project, name, builderId);
        if (targetStr != null) {
            newMakeTarget.setBuildAttribute(IMakeTarget.BUILD_TARGET, targetStr);
        }
        String projectBuildCommand = MakeTargetDndUtil.getProjectBuildCommand(project);
        if (command != null && command.length() > 0 && !command.equals(projectBuildCommand)) {
            newMakeTarget.setBuildAttribute(IMakeCommonBuildInfo.BUILD_COMMAND, command);
            newMakeTarget.setUseDefaultBuildCmd(false);
        } else {
            newMakeTarget.setBuildAttribute(IMakeCommonBuildInfo.BUILD_COMMAND, projectBuildCommand);
            newMakeTarget.setUseDefaultBuildCmd(true);
        }
        return newMakeTarget;
    }
}

