/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.qt.ui.preferences;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.internal.qt.ui.Activator;
import org.eclipse.cdt.internal.qt.ui.Messages;
import org.eclipse.cdt.internal.qt.ui.preferences.NewQtInstallWizard;
import org.eclipse.cdt.qt.core.IQtInstall;
import org.eclipse.cdt.qt.core.IQtInstallManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class QtPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private IQtInstallManager manager;
    private Table installTable;
    private Button removeButton;
    private Map<Path, IQtInstall> installsToAdd = new HashMap<Path, IQtInstall>();
    private Map<Path, IQtInstall> installsToRemove = new HashMap<Path, IQtInstall>();

    public void init(IWorkbench workbench) {
        this.manager = Activator.getService(IQtInstallManager.class);
    }

    protected Control createContents(Composite parent) {
        Composite control = new Composite(parent, 0);
        control.setLayout((Layout)new GridLayout());
        Group installsGroup = new Group(control, 0);
        installsGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        installsGroup.setText(Messages.QtPreferencePage_0);
        installsGroup.setLayout((Layout)new GridLayout(2, false));
        Composite installTableComp = new Composite((Composite)installsGroup, 0);
        installTableComp.setLayoutData((Object)new GridData(4, 4, true, true));
        this.installTable = new Table(installTableComp, 68100);
        this.installTable.setLayoutData((Object)new GridData(4, 4, true, true));
        this.installTable.setHeaderVisible(true);
        this.installTable.setLinesVisible(true);
        this.installTable.addListener(13, e -> {
            TableItem[] items = this.installTable.getSelection();
            this.removeButton.setEnabled(items.length > 0);
        });
        TableColumn nameColumn = new TableColumn(this.installTable, 0);
        nameColumn.setText(Messages.QtPreferencePage_1);
        TableColumn locationColumn = new TableColumn(this.installTable, 0);
        locationColumn.setText(Messages.QtPreferencePage_2);
        TableColumnLayout tableLayout = new TableColumnLayout();
        tableLayout.setColumnData((Widget)nameColumn, (ColumnLayoutData)new ColumnWeightData(75, 350, true));
        tableLayout.setColumnData((Widget)locationColumn, (ColumnLayoutData)new ColumnWeightData(25, 100, true));
        installTableComp.setLayout((Layout)tableLayout);
        Composite buttonsComp = new Composite((Composite)installsGroup, 0);
        buttonsComp.setLayoutData((Object)new GridData(4, 4, false, true));
        buttonsComp.setLayout((Layout)new GridLayout());
        Button addButton = new Button(buttonsComp, 8);
        addButton.setLayoutData((Object)new GridData(4, 4, false, false));
        addButton.setText(Messages.QtPreferencePage_3);
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewQtInstallWizard wizard = new NewQtInstallWizard(QtPreferencePage.this.getInstalls());
                WizardDialog dialog = new WizardDialog(QtPreferencePage.this.getShell(), (IWizard)wizard);
                if (dialog.open() == 0) {
                    IQtInstall install = wizard.getInstall();
                    QtPreferencePage.this.installsToAdd.put(install.getQmakePath(), install);
                    QtPreferencePage.this.updateTable();
                }
            }
        });
        this.removeButton = new Button(buttonsComp, 8);
        this.removeButton.setLayoutData((Object)new GridData(4, 4, false, false));
        this.removeButton.setText(Messages.QtPreferencePage_4);
        this.removeButton.setEnabled(false);
        this.removeButton.addListener(13, e -> {
            if (MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.QtPreferencePage_5, (String)Messages.QtPreferencePage_6)) {
                TableItem[] tableItemArray = this.installTable.getSelection();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    IQtInstall install = (IQtInstall)item.getData();
                    this.installsToRemove.put(install.getQmakePath(), install);
                    this.updateTable();
                    ++n2;
                }
            }
        });
        this.updateTable();
        return control;
    }

    private Map<Path, IQtInstall> getInstalls() {
        HashMap<Path, IQtInstall> installs = new HashMap<Path, IQtInstall>();
        for (IQtInstall install : this.manager.getInstalls()) {
            installs.put(install.getQmakePath(), install);
        }
        for (IQtInstall install : this.installsToAdd.values()) {
            installs.put(install.getQmakePath(), install);
        }
        for (IQtInstall install : this.installsToRemove.values()) {
            installs.remove(install.getQmakePath());
        }
        return installs;
    }

    private void updateTable() {
        ArrayList<IQtInstall> sorted = new ArrayList<IQtInstall>(this.getInstalls().values());
        Collections.sort(sorted, (o1, o2) -> o1.getQmakePath().toString().compareToIgnoreCase(o2.getQmakePath().toString()));
        this.installTable.removeAll();
        for (IQtInstall install : sorted) {
            TableItem item = new TableItem(this.installTable, 0);
            item.setText(0, install.getQmakePath().toString());
            item.setText(1, install.getSpec());
            item.setData((Object)install);
        }
    }

    public boolean performOk() {
        for (IQtInstall install : this.installsToAdd.values()) {
            this.manager.addInstall(install);
        }
        for (IQtInstall install : this.installsToRemove.values()) {
            this.manager.removeInstall(install);
        }
        return true;
    }
}

