/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.FMParserConstants;
import freemarker.core.MessageUtil;
import freemarker.core.TemplateObject;
import freemarker.core.Token;
import freemarker.template.Template;
import freemarker.template.utility.SecurityUtilities;
import freemarker.template.utility.StringUtil;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ParseException
extends IOException
implements FMParserConstants {
    public Token currentToken;
    private static volatile Boolean jbossToolsMode;
    private boolean messageAndDescriptionRendered;
    private String message;
    private String description;
    public int columnNumber;
    public int lineNumber;
    public int endColumnNumber;
    public int endLineNumber;
    public int[][] expectedTokenSequences;
    public String[] tokenImage;
    protected String eol = SecurityUtilities.getSystemProperty("line.separator", "\n");
    protected boolean specialConstructor;
    private String templateName;

    public ParseException(Token currentTokenVal, int[][] expectedTokenSequencesVal, String[] tokenImageVal) {
        super("");
        this.currentToken = currentTokenVal;
        this.specialConstructor = true;
        this.expectedTokenSequences = expectedTokenSequencesVal;
        this.tokenImage = tokenImageVal;
        this.lineNumber = this.currentToken.next.beginLine;
        this.columnNumber = this.currentToken.next.beginColumn;
        this.endLineNumber = this.currentToken.next.endLine;
        this.endColumnNumber = this.currentToken.next.endColumn;
    }

    protected ParseException() {
    }

    public ParseException(String description, int lineNumber, int columnNumber) {
        this(description, null, lineNumber, columnNumber, null);
    }

    public ParseException(String description, Template template, int lineNumber, int columnNumber, int endLineNumber, int endColumnNumber) {
        this(description, template, lineNumber, columnNumber, endLineNumber, endColumnNumber, null);
    }

    public ParseException(String description, Template template, int lineNumber, int columnNumber, int endLineNumber, int endColumnNumber, Throwable cause) {
        this(description, template == null ? null : template.getSourceName(), lineNumber, columnNumber, endLineNumber, endColumnNumber, cause);
    }

    public ParseException(String description, Template template, int lineNumber, int columnNumber) {
        this(description, template, lineNumber, columnNumber, null);
    }

    public ParseException(String description, Template template, int lineNumber, int columnNumber, Throwable cause) {
        this(description, template == null ? null : template.getSourceName(), lineNumber, columnNumber, 0, 0, cause);
    }

    public ParseException(String description, Template template, Token tk) {
        this(description, template, tk, null);
    }

    public ParseException(String description, Template template, Token tk, Throwable cause) {
        this(description, template == null ? null : template.getSourceName(), tk.beginLine, tk.beginColumn, tk.endLine, tk.endColumn, cause);
    }

    public ParseException(String description, TemplateObject tobj) {
        this(description, tobj, null);
    }

    public ParseException(String description, TemplateObject tobj, Throwable cause) {
        this(description, tobj.getTemplate() == null ? null : tobj.getTemplate().getSourceName(), tobj.beginLine, tobj.beginColumn, tobj.endLine, tobj.endColumn, cause);
    }

    private ParseException(String description, String templateName, int lineNumber, int columnNumber, int endLineNumber, int endColumnNumber, Throwable cause) {
        super(description);
        this.description = description;
        this.templateName = templateName;
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
        this.endLineNumber = endLineNumber;
        this.endColumnNumber = endColumnNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTemplateName(String templateName) {
        this.templateName = templateName;
        ParseException parseException = this;
        synchronized (parseException) {
            this.messageAndDescriptionRendered = false;
            this.message = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMessage() {
        ParseException parseException = this;
        synchronized (parseException) {
            if (this.messageAndDescriptionRendered) {
                return this.message;
            }
        }
        this.renderMessageAndDescription();
        parseException = this;
        synchronized (parseException) {
            return this.message;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDescription() {
        ParseException parseException = this;
        synchronized (parseException) {
            if (this.messageAndDescriptionRendered) {
                return this.description;
            }
        }
        this.renderMessageAndDescription();
        parseException = this;
        synchronized (parseException) {
            return this.description;
        }
    }

    public String getEditorMessage() {
        return this.getDescription();
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public int getEndLineNumber() {
        return this.endLineNumber;
    }

    public int getEndColumnNumber() {
        return this.endColumnNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderMessageAndDescription() {
        String desc = this.getOrRenderDescription();
        String prefix = !this.isInJBossToolsMode() ? "Syntax error " + MessageUtil.formatLocationForSimpleParsingError(this.templateName, this.lineNumber, this.columnNumber) + ":\n" : "[col. " + this.columnNumber + "] ";
        String msg = prefix + desc;
        desc = msg.substring(prefix.length());
        ParseException parseException = this;
        synchronized (parseException) {
            this.message = msg;
            this.description = desc;
            this.messageAndDescriptionRendered = true;
        }
    }

    private boolean isInJBossToolsMode() {
        if (jbossToolsMode == null) {
            try {
                jbossToolsMode = ParseException.class.getClassLoader().toString().indexOf("[org.jboss.ide.eclipse.freemarker:") != -1;
            }
            catch (Throwable e) {
                jbossToolsMode = Boolean.FALSE;
            }
        }
        return jbossToolsMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getOrRenderDescription() {
        String tokenErrDesc;
        ParseException parseException = this;
        synchronized (parseException) {
            if (this.description != null) {
                return this.description;
            }
        }
        if (this.currentToken != null) {
            tokenErrDesc = this.getCustomTokenErrorDescription();
            if (tokenErrDesc == null) {
                StringBuffer expected = new StringBuffer();
                int maxSize = 0;
                for (int i = 0; i < this.expectedTokenSequences.length; ++i) {
                    if (i != 0) {
                        expected.append(this.eol);
                    }
                    expected.append("    ");
                    if (maxSize < this.expectedTokenSequences[i].length) {
                        maxSize = this.expectedTokenSequences[i].length;
                    }
                    for (int j = 0; j < this.expectedTokenSequences[i].length; ++j) {
                        if (j != 0) {
                            expected.append(' ');
                        }
                        expected.append(this.tokenImage[this.expectedTokenSequences[i][j]]);
                    }
                }
                tokenErrDesc = "Encountered \"";
                Token tok = this.currentToken.next;
                for (int i = 0; i < maxSize; ++i) {
                    if (i != 0) {
                        tokenErrDesc = tokenErrDesc + " ";
                    }
                    if (tok.kind == 0) {
                        tokenErrDesc = tokenErrDesc + this.tokenImage[0];
                        break;
                    }
                    tokenErrDesc = tokenErrDesc + this.add_escapes(tok.image);
                    tok = tok.next;
                }
                tokenErrDesc = tokenErrDesc + "\", but ";
                tokenErrDesc = this.expectedTokenSequences.length == 1 ? tokenErrDesc + "was expecting:" + this.eol : tokenErrDesc + "was expecting one of:" + this.eol;
                tokenErrDesc = tokenErrDesc + expected;
            }
        } else {
            tokenErrDesc = null;
        }
        return tokenErrDesc;
    }

    private String getCustomTokenErrorDescription() {
        Token nextToken = this.currentToken.next;
        int kind = nextToken.kind;
        if (kind == 0) {
            HashSet<String> endNames = new HashSet<String>();
            for (int i = 0; i < this.expectedTokenSequences.length; ++i) {
                int[] sequence = this.expectedTokenSequences[i];
                block21: for (int j = 0; j < sequence.length; ++j) {
                    switch (sequence[j]) {
                        case 35: {
                            endNames.add("#foreach");
                            continue block21;
                        }
                        case 32: {
                            endNames.add("#list");
                            continue block21;
                        }
                        case 43: {
                            endNames.add("#switch");
                            continue block21;
                        }
                        case 31: {
                            endNames.add("#if");
                            continue block21;
                        }
                        case 41: {
                            endNames.add("#compress");
                            continue block21;
                        }
                        case 40: {
                            endNames.add("#macro");
                        }
                        case 39: {
                            endNames.add("#function");
                            continue block21;
                        }
                        case 42: {
                            endNames.add("#transform");
                            continue block21;
                        }
                        case 60: {
                            endNames.add("#escape");
                            continue block21;
                        }
                        case 62: {
                            endNames.add("#noescape");
                            continue block21;
                        }
                        case 38: {
                            endNames.add("#assign");
                            continue block21;
                        }
                        case 36: {
                            endNames.add("#local");
                            continue block21;
                        }
                        case 37: {
                            endNames.add("#global");
                            continue block21;
                        }
                        case 34: {
                            endNames.add("#attempt");
                            continue block21;
                        }
                        case 118: {
                            endNames.add("\"{\"");
                            continue block21;
                        }
                        case 114: {
                            endNames.add("\"[\"");
                            continue block21;
                        }
                        case 116: {
                            endNames.add("\"(\"");
                            continue block21;
                        }
                        case 64: {
                            endNames.add("@...");
                        }
                    }
                }
            }
            return "Unexpected end of file reached." + (endNames.size() == 0 ? "" : " You have an unclosed " + this.concatWithOrs(endNames) + ".");
        }
        if (kind == 31 || kind == 9 || kind == 44) {
            return "Unexpected directive, " + StringUtil.jQuote(nextToken) + ". Check whether you have a valid #if-#elseif-#else structure.";
        }
        return null;
    }

    private String concatWithOrs(Set endNames) {
        StringBuffer sb = new StringBuffer();
        Iterator it = endNames.iterator();
        while (it.hasNext()) {
            String endName = (String)it.next();
            if (sb.length() != 0) {
                sb.append(" or ");
            }
            sb.append(endName);
        }
        return sb.toString();
    }

    protected String add_escapes(String str) {
        StringBuffer retval = new StringBuffer();
        block11: for (int i = 0; i < str.length(); ++i) {
            switch (str.charAt(i)) {
                case '\u0000': {
                    continue block11;
                }
                case '\b': {
                    retval.append("\\b");
                    continue block11;
                }
                case '\t': {
                    retval.append("\\t");
                    continue block11;
                }
                case '\n': {
                    retval.append("\\n");
                    continue block11;
                }
                case '\f': {
                    retval.append("\\f");
                    continue block11;
                }
                case '\r': {
                    retval.append("\\r");
                    continue block11;
                }
                case '\"': {
                    retval.append("\\\"");
                    continue block11;
                }
                case '\'': {
                    retval.append("\\'");
                    continue block11;
                }
                case '\\': {
                    retval.append("\\\\");
                    continue block11;
                }
                default: {
                    char ch = str.charAt(i);
                    if (ch < ' ' || ch > '~') {
                        String s = "0000" + Integer.toString(ch, 16);
                        retval.append("\\u" + s.substring(s.length() - 4, s.length()));
                        continue block11;
                    }
                    retval.append(ch);
                }
            }
        }
        return retval.toString();
    }
}

