/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.arduino.ui.internal.downloads;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoManager;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoPlatform;
import org.eclipse.cdt.arduino.ui.internal.Activator;
import org.eclipse.cdt.arduino.ui.internal.FormTextHoverManager;
import org.eclipse.cdt.arduino.ui.internal.downloads.ArduinoDownloadsManager;
import org.eclipse.cdt.arduino.ui.internal.downloads.SelectPlatformsDialog;
import org.eclipse.cdt.arduino.ui.internal.downloads.UpdatePlatformsDialog;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class PlatformsTabControl
extends Composite {
    private ArduinoManager manager = Activator.getService(ArduinoManager.class);
    private Table table;
    private IWizardContainer container;
    private Collection<ArduinoPlatform> availablePlatforms;

    public PlatformsTabControl(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout());
        Text desc = new Text((Composite)this, 72);
        GridData layoutData = new GridData(4, 4, true, false);
        layoutData.widthHint = 500;
        desc.setLayoutData((Object)layoutData);
        desc.setBackground(parent.getBackground());
        desc.setText("Installed Platforms. Details available in their tooltips");
        Composite comp = new Composite((Composite)this, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite tableComp = new Composite(comp, 0);
        tableComp.setLayoutData((Object)new GridData(4, 4, true, true));
        this.table = new Table(tableComp, 68098);
        this.table.setLayoutData((Object)new GridData(4, 4, true, true));
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        TableColumnLayout tableLayout = new TableColumnLayout();
        TableColumn packageColumn = new TableColumn(this.table, 16384);
        packageColumn.setText("Package");
        tableLayout.setColumnData((Widget)packageColumn, (ColumnLayoutData)new ColumnWeightData(2, 75, true));
        TableColumn platformColumn = new TableColumn(this.table, 16384);
        platformColumn.setText("Platform");
        tableLayout.setColumnData((Widget)platformColumn, (ColumnLayoutData)new ColumnWeightData(5, 150, true));
        TableColumn versionColumn = new TableColumn(this.table, 16384);
        versionColumn.setText("Version");
        tableLayout.setColumnData((Widget)versionColumn, (ColumnLayoutData)new ColumnWeightData(2, 75, true));
        tableComp.setLayout((Layout)tableLayout);
        Composite buttonComp = new Composite(comp, 0);
        buttonComp.setLayout((Layout)new GridLayout());
        buttonComp.setLayoutData((Object)new GridData(1, 1, false, false));
        final Button uninstallButton = new Button(buttonComp, 8);
        uninstallButton.setLayoutData((Object)new GridData(4, 1, true, false));
        uninstallButton.setText("Uninstall");
        uninstallButton.setEnabled(false);
        uninstallButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PlatformsTabControl.this.uninstall();
            }
        });
        Button updatesButton = new Button(buttonComp, 8);
        updatesButton.setLayoutData((Object)new GridData(4, 1, true, false));
        updatesButton.setText("Updates");
        updatesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PlatformsTabControl.this.checkForUpdates();
            }
        });
        Button addButton = new Button(buttonComp, 8);
        addButton.setLayoutData((Object)new GridData(4, 1, true, false));
        addButton.setText("Add");
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PlatformsTabControl.this.addPlatforms();
            }
        });
        this.populateTable();
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] selection = PlatformsTabControl.this.table.getSelection();
                uninstallButton.setEnabled(selection.length > 0);
            }
        });
        FormTextHoverManager hoverManager = new FormTextHoverManager(){

            protected void computeInformation() {
                TableItem item = PlatformsTabControl.this.table.getItem(this.getHoverEventLocation());
                if (item != null) {
                    ArduinoPlatform platform = (ArduinoPlatform)item.getData();
                    this.setInformation(platform.toFormText(), item.getBounds());
                } else {
                    this.setInformation(null, null);
                }
            }
        };
        hoverManager.install((Control)this.table);
    }

    public boolean setFocus() {
        return this.table.setFocus();
    }

    public void setContainer(IWizardContainer container) {
        this.container = container;
    }

    private void populateTable() {
        this.table.removeAll();
        try {
            ArrayList platforms = new ArrayList(this.manager.getInstalledPlatforms());
            Collections.sort(platforms, new Comparator<ArduinoPlatform>(){

                @Override
                public int compare(ArduinoPlatform o1, ArduinoPlatform o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            for (ArduinoPlatform platform : platforms) {
                TableItem item = new TableItem(this.table, 0);
                item.setData((Object)platform);
                item.setText(0, platform.getPackage().getName());
                item.setText(1, platform.getName());
                item.setText(2, platform.getVersion());
            }
        }
        catch (CoreException e) {
            Activator.log((Exception)((Object)e));
        }
    }

    private void uninstall() {
        ArrayList<ArduinoPlatform> selectedPlatforms = new ArrayList<ArduinoPlatform>(this.table.getSelectionCount());
        TableItem[] tableItemArray = this.table.getSelection();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            selectedPlatforms.add((ArduinoPlatform)item.getData());
            ++n2;
        }
        try {
            this.container.run(true, true, monitor -> this.manager.uninstallPlatforms((Collection)selectedPlatforms, monitor));
        }
        catch (InterruptedException | InvocationTargetException e) {
            Activator.log(e);
            return;
        }
        this.populateTable();
    }

    private void checkForUpdates() {
        Collection<ArduinoPlatform> toUpdate;
        ArrayList<ArduinoPlatform> updates = new ArrayList<ArduinoPlatform>();
        try {
            this.container.run(true, true, monitor -> {
                try {
                    for (ArduinoPlatform available : this.manager.getPlatformUpdates(monitor)) {
                        ArduinoPlatform installed = this.manager.getInstalledPlatform(available.getPackage().getName(), available.getArchitecture());
                        if (installed == null || ArduinoManager.compareVersions((String)available.getVersion(), (String)installed.getVersion()) <= 0) continue;
                        updates.add(available);
                    }
                }
                catch (CoreException e) {
                    this.getDisplay().syncExec(() -> {
                        int n = ErrorDialog.openError((Shell)this.getShell(), null, null, (IStatus)e.getStatus());
                    });
                    Activator.log((Exception)((Object)e));
                }
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            Activator.log(e);
            return;
        }
        if (updates.isEmpty()) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)"Platform Updates", (String)"All platforms are up to date");
            return;
        }
        UpdatePlatformsDialog updateDialog = new UpdatePlatformsDialog(this.getShell(), updates);
        if (updateDialog.open() == 0 && !(toUpdate = updateDialog.getSelectedPlatforms()).isEmpty()) {
            try {
                this.container.run(true, true, monitor -> {
                    try {
                        this.manager.installPlatforms(toUpdate, monitor);
                    }
                    catch (CoreException e) {
                        this.getDisplay().syncExec(() -> {
                            int n = ErrorDialog.openError((Shell)this.getShell(), null, null, (IStatus)e.getStatus());
                        });
                        Activator.log((Exception)((Object)e));
                    }
                });
            }
            catch (InterruptedException | InvocationTargetException e) {
                Activator.log(e);
            }
            this.populateTable();
        }
    }

    private void addPlatforms() {
        try {
            this.container.run(true, true, monitor -> {
                try {
                    this.availablePlatforms = this.manager.getAvailablePlatforms(monitor);
                }
                catch (CoreException e) {
                    this.getDisplay().syncExec(() -> {
                        int n = ErrorDialog.openError((Shell)this.getShell(), null, null, (IStatus)e.getStatus());
                    });
                    Activator.log((Exception)((Object)e));
                }
            });
            SelectPlatformsDialog selectDialog = new SelectPlatformsDialog(this.getShell());
            selectDialog.setPlatforms(this.availablePlatforms);
            if (selectDialog.open() == 0 && ArduinoDownloadsManager.checkLicense(this.getShell())) {
                Collection<ArduinoPlatform> selectedPlatforms = selectDialog.getSelectedPlatforms();
                this.container.run(true, true, monitor -> {
                    try {
                        this.manager.installPlatforms(selectedPlatforms, monitor);
                    }
                    catch (CoreException e) {
                        Activator.log((Exception)((Object)e));
                    }
                });
            }
            this.populateTable();
        }
        catch (InterruptedException | InvocationTargetException e) {
            Activator.log(e);
            return;
        }
    }
}

