/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.cmake.core.internal;

import java.util.Collection;
import java.util.HashMap;
import org.eclipse.cdt.cmake.core.internal.Activator;
import org.eclipse.cdt.core.build.ICBuildConfiguration;
import org.eclipse.cdt.core.build.ICBuildConfigurationManager;
import org.eclipse.cdt.core.build.IToolChain;
import org.eclipse.cdt.core.build.IToolChainManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.launchbar.core.target.ILaunchTarget;
import org.eclipse.launchbar.core.target.launch.LaunchConfigurationTargetedDelegate;

public class CMakeLaunchConfigurationDelegate
extends LaunchConfigurationTargetedDelegate
implements ILaunchConfigurationDelegate {
    public static final String TYPE_ID = "org.eclipse.cdt.cmake.core.launchConfigurationType";
    private ICBuildConfigurationManager configManager = Activator.getService(ICBuildConfigurationManager.class);
    private IToolChainManager tcManager = Activator.getService(IToolChainManager.class);

    private IProject getProject(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getMappedResources()[0].getProject();
    }

    public boolean buildForLaunch(ILaunchConfiguration configuration, String mode, ILaunchTarget target, IProgressMonitor monitor) throws CoreException {
        Collection tcs;
        String arch;
        HashMap<String, String> properties = new HashMap<String, String>();
        String os = target.getAttribute("os", "");
        if (!os.isEmpty()) {
            properties.put("os", os);
        }
        if (!(arch = target.getAttribute("arch", "")).isEmpty()) {
            properties.put("arch", arch);
        }
        if (!(tcs = this.tcManager.getToolChainsMatching(properties)).isEmpty()) {
            IToolChain toolChain = (IToolChain)tcs.iterator().next();
            IProject project = this.getProject(configuration);
            ICBuildConfiguration config = this.configManager.getBuildConfiguration(project, toolChain, "run", monitor);
            if (config != null) {
                IProjectDescription desc = project.getDescription();
                desc.setActiveBuildConfig(config.getBuildConfiguration().getName());
                project.setDescription(desc, monitor);
            }
        }
        return this.superBuildForLaunch(configuration, mode, monitor);
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
    }

    protected IProject[] getBuildOrder(ILaunchConfiguration configuration, String mode) throws CoreException {
        IProject project = this.getProject(configuration);
        return new IProject[]{project};
    }
}

