/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.llvm.dsf.lldb.ui.internal;

import java.io.File;
import org.eclipse.cdt.debug.ui.AbstractCDebuggerPage;
import org.eclipse.cdt.llvm.dsf.lldb.ui.internal.LLDBUIPlugin;
import org.eclipse.cdt.llvm.dsf.lldb.ui.internal.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class LLDBCDebuggerPage
extends AbstractCDebuggerPage {
    protected Text fLLDBCommandText;

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)new GridLayout(3, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        Label lbl = new Label(composite, 16384);
        lbl.setFont(parent.getFont());
        lbl.setText(Messages.LLDBCDebuggerPage_debugger_command);
        this.fLLDBCommandText = new Text(composite, 2052);
        this.fLLDBCommandText.setLayoutData((Object)new GridData(4, 128, true, false));
        this.fLLDBCommandText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                LLDBCDebuggerPage.this.updateLaunchConfigurationDialog();
            }
        });
        Button button = this.createPushButton(composite, Messages.LLDBCDebuggerPage_browse, null);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                this.handleButtonSelected();
                LLDBCDebuggerPage.this.updateLaunchConfigurationDialog();
            }

            private void handleButtonSelected() {
                String res;
                FileDialog dialog = new FileDialog(LLDBCDebuggerPage.this.getShell(), 0);
                dialog.setText(Messages.LLDBCDebuggerPage_browse_dialog_title);
                String lldbCommand = LLDBCDebuggerPage.this.fLLDBCommandText.getText().trim();
                int lastSeparatorIndex = lldbCommand.lastIndexOf(File.separator);
                if (lastSeparatorIndex != -1) {
                    dialog.setFilterPath(lldbCommand.substring(0, lastSeparatorIndex));
                }
                if ((res = dialog.open()) == null) {
                    return;
                }
                LLDBCDebuggerPage.this.fLLDBCommandText.setText(res);
            }
        });
        this.setControl((Control)parent);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        IPreferenceStore corePreferenceStore = LLDBUIPlugin.getDefault().getCorePreferenceStore();
        configuration.setAttribute("org.eclipse.cdt.llvm.dsf.lldb.core.DEBUG_NAME", corePreferenceStore.getString("defaultLLDBCommand"));
        configuration.setAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN", corePreferenceStore.getBoolean("defaultStopAtMain"));
        configuration.setAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN_SYMBOL", corePreferenceStore.getBoolean("defaultStopAtMainSymbol"));
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        IPreferenceStore preferenceStore = LLDBUIPlugin.getDefault().getCorePreferenceStore();
        String lldbCommand = LLDBCDebuggerPage.getStringAttr(configuration, "org.eclipse.cdt.llvm.dsf.lldb.core.DEBUG_NAME", preferenceStore.getString("defaultLLDBCommand"));
        this.fLLDBCommandText.setText(lldbCommand);
    }

    private static String getStringAttr(ILaunchConfiguration config, String attributeName, String defaultValue) {
        try {
            return config.getAttribute(attributeName, defaultValue);
        }
        catch (CoreException e) {
            return defaultValue;
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.cdt.llvm.dsf.lldb.core.DEBUG_NAME", this.fLLDBCommandText.getText().trim());
    }

    public String getName() {
        return Messages.LLDBCDebuggerPage_tab_name;
    }
}

