/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.cmake.core.internal;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.cmake.core.ICMakeToolChainFile;
import org.eclipse.cdt.cmake.core.ICMakeToolChainManager;
import org.eclipse.cdt.cmake.core.internal.Activator;
import org.eclipse.cdt.cmake.core.internal.CompileCommand;
import org.eclipse.cdt.core.ConsoleOutputStream;
import org.eclipse.cdt.core.ErrorParserManager;
import org.eclipse.cdt.core.IConsoleParser;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.core.build.CBuildConfiguration;
import org.eclipse.cdt.core.build.IToolChain;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class CMakeBuildConfiguration
extends CBuildConfiguration {
    private static final String TOOLCHAIN_FILE = "cdt.cmake.toolchainfile";
    private ICMakeToolChainFile toolChainFile;

    public CMakeBuildConfiguration(IBuildConfiguration config, String name) throws CoreException {
        super(config, name);
        Preferences settings = this.getSettings();
        String pathStr = settings.get(TOOLCHAIN_FILE, "");
        if (!pathStr.isEmpty()) {
            Path path = Paths.get(pathStr, new String[0]);
            ICMakeToolChainManager manager = Activator.getService(ICMakeToolChainManager.class);
            this.toolChainFile = manager.getToolChainFile(path);
        }
    }

    public CMakeBuildConfiguration(IBuildConfiguration config, String name, IToolChain toolChain) {
        this(config, name, toolChain, null);
    }

    public CMakeBuildConfiguration(IBuildConfiguration config, String name, IToolChain toolChain, ICMakeToolChainFile toolChainFile) {
        super(config, name, toolChain);
        this.toolChainFile = toolChainFile;
        if (toolChainFile != null) {
            Preferences settings = this.getSettings();
            settings.put(TOOLCHAIN_FILE, toolChainFile.getPath().toString());
            try {
                settings.flush();
            }
            catch (BackingStoreException e) {
                Activator.log(e);
            }
        }
    }

    public ICMakeToolChainFile getToolChainFile() {
        return this.toolChainFile;
    }

    public IProject[] build(int kind, Map<String, String> args, IConsole console, IProgressMonitor monitor) throws CoreException {
        IProject project = this.getProject();
        try {
            project.deleteMarkers("org.eclipse.cdt.core.problem", false, 2);
            ConsoleOutputStream outStream = console.getOutputStream();
            Path buildDir = this.getBuildDirectory();
            outStream.write(String.format("Building in: %s\n", buildDir.toString()));
            if (!Files.exists(buildDir.resolve("Makefile"), new LinkOption[0])) {
                ArrayList<String> command = new ArrayList<String>();
                Path cmakePath = CBuildConfiguration.getCommandFromPath((Path)Paths.get("cmake", new String[0]));
                if (cmakePath == null) {
                    cmakePath = !Platform.getOS().equals("win32") ? Paths.get("/usr/local/bin/cmake", new String[0]) : Paths.get("cmake", new String[0]);
                }
                command.add(cmakePath.toString());
                command.add("-G");
                command.add("Unix Makefiles");
                if (this.toolChainFile != null) {
                    command.add("-DCMAKE_TOOLCHAIN_FILE=" + this.toolChainFile.getPath().toString());
                }
                command.add("-DCMAKE_EXPORT_COMPILE_COMMANDS=ON");
                command.add(new File(project.getLocationURI()).getAbsolutePath());
                ProcessBuilder processBuilder = new ProcessBuilder(command).directory(buildDir.toFile());
                this.setBuildEnvironment(processBuilder.environment());
                Process process = processBuilder.start();
                outStream.write(String.valueOf(String.join((CharSequence)" ", command)) + '\n');
                this.watchProcess(process, new IConsoleParser[0], console);
            }
            Throwable throwable = null;
            Object var9_11 = null;
            try (ErrorParserManager epm = new ErrorParserManager(project, this.getBuildDirectoryURI(), (IMarkerGenerator)this, this.getToolChain().getErrorParserIds());){
                List<String> command = Arrays.asList("make");
                ProcessBuilder processBuilder = new ProcessBuilder(command).directory(buildDir.toFile());
                this.setBuildEnvironment(processBuilder.environment());
                Process process = processBuilder.start();
                outStream.write(String.valueOf(String.join((CharSequence)" ", command)) + '\n');
                this.watchProcess(process, new IConsoleParser[]{epm}, console);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            project.refreshLocal(2, monitor);
            this.processCompileCommandsFile(monitor);
            return new IProject[]{project};
        }
        catch (IOException e) {
            throw new CoreException(Activator.errorStatus(String.format("Building %s", project.getName()), e));
        }
    }

    public void clean(IConsole console, IProgressMonitor monitor) throws CoreException {
        IProject project = this.getProject();
        try {
            project.deleteMarkers("org.eclipse.cdt.core.problem", false, 2);
            ConsoleOutputStream outStream = console.getOutputStream();
            Path buildDir = this.getBuildDirectory();
            if (!Files.exists(buildDir.resolve("Makefile"), new LinkOption[0])) {
                outStream.write("Makefile not found. Assuming clean.");
                return;
            }
            List<String> command = Arrays.asList("make", "clean");
            ProcessBuilder processBuilder = new ProcessBuilder(command).directory(buildDir.toFile());
            Process process = processBuilder.start();
            outStream.write(String.valueOf(String.join((CharSequence)" ", command)) + '\n');
            this.watchProcess(process, new IConsoleParser[0], console);
            project.refreshLocal(2, monitor);
        }
        catch (IOException e) {
            throw new CoreException(Activator.errorStatus(String.format("Cleaning %s", project.getName()), e));
        }
    }

    private void processCompileCommandsFile(IProgressMonitor monitor) throws CoreException {
        IProject project = this.getProject();
        Path commandsFile = this.getBuildDirectory().resolve("compile_commands.json");
        if (Files.exists(commandsFile, new LinkOption[0])) {
            monitor.setTaskName("Processing compile_commands.json");
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (FileReader reader = new FileReader(commandsFile.toFile());){
                    CompileCommand[] commands;
                    Gson gson = new Gson();
                    CompileCommand[] compileCommandArray = commands = (CompileCommand[])gson.fromJson((Reader)reader, CompileCommand[].class);
                    int n = commands.length;
                    int n2 = 0;
                    while (n2 < n) {
                        CompileCommand command = compileCommandArray[n2];
                        this.processLine(command.getCommand());
                        ++n2;
                    }
                    this.shutdown();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new CoreException(Activator.errorStatus(String.format("Processing compile commands %s", project.getName()), e));
            }
        }
    }
}

