/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.llvm.dsf.lldb.core.internal.service;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IProcessInfo;
import org.eclipse.cdt.core.IProcessList;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IProcesses;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.gdb.service.GDBProcesses_7_4;
import org.eclipse.cdt.dsf.gdb.service.IGDBBackend;
import org.eclipse.cdt.dsf.gdb.service.SessionType;
import org.eclipse.cdt.dsf.mi.service.IMIProcessDMContext;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.llvm.dsf.lldb.core.internal.service.Messages;
import org.eclipse.core.runtime.CoreException;

public class LLDBProcesses
extends GDBProcesses_7_4 {
    private Map<Integer, String> fProcessNames = new HashMap<Integer, String>();

    public LLDBProcesses(DsfSession session) {
        super(session);
    }

    public void getRunningProcesses(IDMContext dmc, DataRequestMonitor<IProcesses.IProcessDMContext[]> rm) {
        ICommandControlService.ICommandControlDMContext controlDmc = (ICommandControlService.ICommandControlDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, ICommandControlService.ICommandControlDMContext.class);
        IGDBBackend backend = (IGDBBackend)this.getServicesTracker().getService(IGDBBackend.class);
        if (backend.getSessionType() == SessionType.LOCAL) {
            IProcessList list = null;
            try {
                list = CCorePlugin.getDefault().getProcessList();
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            if (list == null) {
                this.fProcessNames.clear();
                rm.setData(null);
            } else {
                IProcessInfo[] procInfos;
                this.fProcessNames.clear();
                IProcessInfo[] iProcessInfoArray = procInfos = list.getProcessList();
                int n = procInfos.length;
                int n2 = 0;
                while (n2 < n) {
                    IProcessInfo procInfo = iProcessInfoArray[n2];
                    this.fProcessNames.put(procInfo.getPid(), procInfo.getName());
                    ++n2;
                }
                rm.setData((Object)this.makeProcessDMCs(controlDmc, procInfos));
            }
            rm.done();
        } else {
            this.fProcessNames.clear();
            rm.setData((Object)new IProcesses.IProcessDMContext[0]);
            rm.done();
        }
    }

    private IProcesses.IProcessDMContext[] makeProcessDMCs(ICommandControlService.ICommandControlDMContext controlDmc, IProcessInfo[] processes) {
        IMIProcessDMContext[] procDmcs = new IMIProcessDMContext[processes.length];
        int i = 0;
        while (i < procDmcs.length) {
            procDmcs[i] = this.createProcessContext(controlDmc, Integer.toString(processes[i].getPid()));
            ++i;
        }
        return procDmcs;
    }

    public void getExecutionData(IProcesses.IThreadDMContext dmc, DataRequestMonitor<IProcesses.IThreadDMData> rm) {
        if (dmc instanceof IMIProcessDMContext) {
            String name;
            String pidStr = ((IMIProcessDMContext)dmc).getProcId();
            int pid = -1;
            try {
                pid = Integer.parseInt(pidStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (this.fProcessNames.isEmpty()) {
                this.getRunningProcesses((IDMContext)dmc, (DataRequestMonitor<IProcesses.IProcessDMContext[]>)new DataRequestMonitor((Executor)this.getExecutor(), rm));
            }
            if ((name = this.fProcessNames.get(pid)) == null) {
                name = Messages.LLDBProcesses_unknown_process_name;
            }
            rm.setData((Object)new LLDBMIThreadDMData(name, pidStr));
            rm.done();
        } else {
            super.getExecutionData(dmc, rm);
        }
    }

    private static class LLDBMIThreadDMData
    implements IProcesses.IThreadDMData {
        final String fName;
        final String fId;

        public LLDBMIThreadDMData(String name, String id) {
            this.fName = name;
            this.fId = id;
        }

        public String getId() {
            return this.fId;
        }

        public String getName() {
            return this.fName;
        }

        public boolean isDebuggerAttached() {
            return true;
        }
    }
}

