/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.qt.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.internal.qt.core.launch.QtLaunchDescriptor;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.launchbar.core.AbstractLaunchConfigProvider;
import org.eclipse.launchbar.core.ILaunchDescriptor;
import org.eclipse.launchbar.core.target.ILaunchTarget;

public abstract class QtLaunchConfigurationProvider
extends AbstractLaunchConfigProvider {
    private Map<IProject, ILaunchConfiguration> configs = new HashMap<IProject, ILaunchConfiguration>();

    public ILaunchConfiguration getLaunchConfiguration(ILaunchDescriptor descriptor, ILaunchTarget target) throws CoreException {
        ILaunchConfiguration config = null;
        IProject project = (IProject)descriptor.getAdapter(IProject.class);
        if (project != null && (config = this.configs.get(project)) == null) {
            config = this.createLaunchConfiguration(descriptor, target);
        }
        return config;
    }

    protected void populateLaunchConfiguration(ILaunchDescriptor descriptor, ILaunchTarget target, ILaunchConfigurationWorkingCopy workingCopy) throws CoreException {
        super.populateLaunchConfiguration(descriptor, target, workingCopy);
        workingCopy.setAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN", false);
        QtLaunchDescriptor qtDesc = (QtLaunchDescriptor)descriptor;
        workingCopy.setMappedResources(new IResource[]{qtDesc.getProject()});
    }

    public boolean launchConfigurationAdded(ILaunchConfiguration configuration) throws CoreException {
        if (this.ownsLaunchConfiguration(configuration)) {
            IProject project = configuration.getMappedResources()[0].getProject();
            this.configs.put(project, configuration);
            return true;
        }
        return false;
    }

    public boolean launchConfigurationRemoved(ILaunchConfiguration configuration) throws CoreException {
        for (Map.Entry<IProject, ILaunchConfiguration> entry : this.configs.entrySet()) {
            if (!configuration.equals(entry.getValue())) continue;
            this.configs.remove(entry.getKey());
            return true;
        }
        return false;
    }

    public boolean launchConfigurationChanged(ILaunchConfiguration configuration) throws CoreException {
        return false;
    }

    public void launchDescriptorRemoved(ILaunchDescriptor descriptor) throws CoreException {
        IProject project = (IProject)descriptor.getAdapter(IProject.class);
        if (project != null) {
            this.configs.remove(project);
        }
    }

    public void launchTargetRemoved(ILaunchTarget target) throws CoreException {
    }
}

