/*
 * Decompiled with CFR 0.152.
 */
package com.symbian.cdt.templateengine;

import com.symbian.cdt.templateengine.TemplateDescriptor;
import com.symbian.cdt.templateengine.TemplateEngine;
import com.symbian.cdt.templateengine.TemplateEngineHelper;
import com.symbian.cdt.templateengine.TemplateEnginePlugin;
import com.symbian.cdt.templateengine.TemplateInfo;
import com.symbian.cdt.templateengine.process.ProcessFailureException;
import com.symbian.cdt.templateengine.process.TemplateProcessHandler;
import com.symbian.cdt.templateengine.ui.pages.UIWizardPage;
import com.symbian.cdt.templateengine.ui.uiengine.UIPagesProvider;
import com.symbian.cdt.templateengine.ui.uitree.UIElementTreeBuilderHelper;
import com.symbian.cdt.templateengine.ui.uitree.UIElementTreeBuilderManager;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.wizard.IWizard;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Template {
    private static final String DESCRIPTION = "description";
    private static final String LABEL = "label";
    private static Map<TemplateInfo, Template> templateCache = new HashMap<TemplateInfo, Template>();
    public static final Comparator<Template> TEMPLATE_LABEL_CASE_INSENSITIVE_COMPARATOR = new Comparator<Template>(){

        @Override
        public int compare(Template t1, Template t2) {
            return String.CASE_INSENSITIVE_ORDER.compare(t1.getLabel(), t2.getLabel());
        }
    };
    private TemplateDescriptor templateDescriptor;
    private UIElementTreeBuilderManager iUIElementTreeBuilderManager;
    private Map<String, String> valueStore;
    private TemplateInfo templateInfo;
    private Set<String> allMacrosInProcesses;
    private TemplateProcessHandler processHandler;
    private String description;
    private String label;
    private boolean fireDirtyEvents;
    private Map<String, UIWizardPage> pageMap;

    private Template(TemplateInfo templateInfo) throws IOException, SAXException, ParserConfigurationException {
        this.templateInfo = templateInfo;
        this.templateDescriptor = new TemplateDescriptor(TemplateEngineHelper.getTemplateResourceURL(templateInfo.getPluginId(), templateInfo.getTemplatePath()));
        this.valueStore = new ValueStore<String, String>(this);
        this.valueStore.putAll(this.templateDescriptor.getTemplateDefaults(this.templateDescriptor.getRootElement()));
        this.valueStore.putAll(TemplateEngine.getTemplateEngine().getSharedDefaults());
        this.iUIElementTreeBuilderManager = new UIElementTreeBuilderManager(new UIElementTreeBuilderHelper(this.templateDescriptor));
        this.processHandler = new TemplateProcessHandler(this);
        this.allMacrosInProcesses = this.processHandler.getAllMacros();
        this.fireDirtyEvents = true;
    }

    public Map<String, UIWizardPage> getUIPages(IWizard Wizard) {
        if (this.pageMap == null) {
            this.pageMap = new HashMap<String, UIWizardPage>();
            List rootPropertyGrouplist = this.templateDescriptor.getPropertyGroupList();
            UIPagesProvider.clearOrderVector();
            int i = 0;
            while (i < rootPropertyGrouplist.size()) {
                this.iUIElementTreeBuilderManager.setUIElementTreeRootNull();
                this.iUIElementTreeBuilderManager.createUIElementTree(null, (Element)rootPropertyGrouplist.get(i));
                this.pageMap.putAll(UIPagesProvider.getWizardUIPages(this.iUIElementTreeBuilderManager.getUIElementTreeRoot(), this.valueStore));
                ++i;
            }
        }
        return this.pageMap;
    }

    public List<String> getPagesOrderVector() {
        return UIPagesProvider.getOrderVector();
    }

    public IStatus[] executeTemplateProcesses(boolean showError) {
        this.setDirty();
        TemplateEngine.getTemplateEngine().updateSharedDefaults(this);
        try {
            return this.processHandler.processAll();
        }
        catch (ProcessFailureException e) {
            if (showError) {
                TemplateEngine.showError(e.getMessage(), e.getCause());
            }
            return new IStatus[]{new Status(4, TemplateEnginePlugin.getUniqueId(), 4, e.getMessage(), (Throwable)e)};
        }
    }

    public Set<String> getAllMissingMacrosInProcesses() {
        TreeSet<String> set = new TreeSet<String>(this.allMacrosInProcesses);
        if (set != null) {
            Iterator iter = set.iterator();
            while (iter.hasNext()) {
                if (this.valueStore.get(iter.next()) == null) continue;
                iter.remove();
            }
        }
        return set;
    }

    public UIElementTreeBuilderManager getUIElementTreeBuilderManager() {
        return this.iUIElementTreeBuilderManager;
    }

    public Map<String, String> getValueStore() {
        return this.valueStore;
    }

    public List<String> getPersistTrueIDs() {
        return this.templateDescriptor.getPersistTrueIDs();
    }

    public TemplateInfo getTemplateInfo() {
        return this.templateInfo;
    }

    public TemplateDescriptor getTemplateDescriptor() {
        return this.templateDescriptor;
    }

    public String getDescription() {
        if (this.description == null) {
            this.description = this.templateDescriptor.getRootElement().getAttribute(DESCRIPTION).trim();
        }
        return this.description;
    }

    public String getLabel() {
        if (this.label == null) {
            this.label = this.templateDescriptor.getRootElement().getAttribute(LABEL).trim();
        }
        return this.label;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDirty() {
        if (this.fireDirtyEvents) {
            Map<TemplateInfo, Template> map = templateCache;
            synchronized (map) {
                templateCache.remove(this.templateInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Template getTemplate(TemplateInfo templateInfo) throws IOException, ProcessFailureException, SAXException, ParserConfigurationException {
        Map<TemplateInfo, Template> map = templateCache;
        synchronized (map) {
            Template template = templateCache.get(templateInfo);
            if (template == null) {
                template = new Template(templateInfo);
                templateCache.put(templateInfo, template);
            }
            return template;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ValueStore<K, V>
    extends HashMap<K, V> {
        private static final long serialVersionUID = -4523467333437879406L;
        private Template template;

        ValueStore(Template template) {
            this.template = template;
        }

        @Override
        public V put(K key, V value) {
            V v = super.put(key, value);
            this.template.setDirty();
            return v;
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> map) {
            super.putAll(map);
            this.template.setDirty();
        }

        @Override
        public V remove(Object key) {
            Object v = super.remove(key);
            this.template.setDirty();
            return v;
        }
    }
}

