/*
 * Decompiled with CFR 0.152.
 */
package com.symbian.cdt.templateengine;

import com.symbian.cdt.templateengine.TemplateEngine;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateDescriptor {
    public static final String PROPERTY_GROUP = "property-group";
    public static final String PROCESS = "process";
    public static final String IF = "if";
    public static final String ID = "id";
    public static final String DEFAULT = "default";
    public static final String PERSIST = "persist";
    public static final String BOOL_TRUE = "true";
    private Document document;
    private Element rootElement;
    private List<String> iPersistVector;

    public TemplateDescriptor(URL descriptorURL) throws SAXException, IOException, ParserConfigurationException {
        this.document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(descriptorURL.openStream());
        this.rootElement = this.document.getDocumentElement();
        this.iPersistVector = new ArrayList<String>();
    }

    public Map<String, String> getTemplateDefaults(Element aRootElement) {
        Map<String, String> templateDefaults = new HashMap<String, String>();
        List<Element> children = TemplateEngine.getChildrenOfElement(aRootElement);
        int i = 0;
        int l = children.size();
        while (i < l) {
            Element propertyGroupElement = children.get(i);
            if (this.isNestedElement(propertyGroupElement)) {
                templateDefaults = this.getTemplateDefaults(propertyGroupElement);
            }
            this.propertyElements(templateDefaults, propertyGroupElement);
            ++i;
        }
        return templateDefaults;
    }

    private boolean isNestedElement(Element aElement) {
        boolean result = false;
        if (aElement != null) {
            List<Element> children = TemplateEngine.getChildrenOfElement(aElement);
            String elementName = aElement.getNodeName();
            String testElementName = null;
            if (children.size() > 0) {
                Element testElement = children.get(0);
                testElementName = testElement.getNodeName();
            }
            result = elementName.equals(testElementName);
        }
        return result;
    }

    public List getPropertyGroupList() {
        ArrayList<Element> aList;
        ArrayList<Element> resultList = null;
        resultList = aList = new ArrayList<Element>();
        if (this.rootElement != null) {
            List<Element> tempList = TemplateEngine.getChildrenOfElement(this.rootElement);
            int i = 0;
            int l = tempList.size();
            while (i < l) {
                Element nextPropertyGroup = tempList.get(i);
                String nextPGName = nextPropertyGroup.getNodeName();
                if (nextPGName.equalsIgnoreCase(PROPERTY_GROUP)) {
                    aList.add(nextPropertyGroup);
                }
                ++i;
            }
        }
        return resultList;
    }

    public Element getRootPropertyGroup(Element aRootElement) {
        if (aRootElement != null) {
            String rootElementName = aRootElement.getNodeName();
            if (rootElementName.equalsIgnoreCase(PROPERTY_GROUP) && this.isNestedElement(aRootElement)) {
                return aRootElement;
            }
            return aRootElement;
        }
        String nextPGElementName = null;
        List<Element> propertyGroupList = TemplateEngine.getChildrenOfElement(aRootElement);
        int i = 0;
        int l = propertyGroupList.size();
        while (i < l) {
            Element nextPGElement = propertyGroupList.get(i);
            if (this.isNestedElement(nextPGElement)) {
                nextPGElementName = nextPGElement.getNodeName();
            }
            if (nextPGElementName.equalsIgnoreCase(PROPERTY_GROUP) && this.isNestedElement(nextPGElement)) {
                return nextPGElement;
            }
            ++i;
        }
        return null;
    }

    private void propertyElements(Map<String, String> defaults, Element propertyGroupElement) {
        String attrName = ID;
        String attrValue = DEFAULT;
        List<Element> children = TemplateEngine.getChildrenOfElement(propertyGroupElement);
        int i = 0;
        int l = children.size();
        while (i < l) {
            String persist;
            Element propertyElement = children.get(i);
            String key = propertyElement.getAttribute(attrName);
            String value = propertyElement.getAttribute(attrValue);
            if (key != null) {
                defaults.put(key, value);
            }
            if ((persist = propertyElement.getAttribute(PERSIST)) != null && persist.trim().equalsIgnoreCase(BOOL_TRUE)) {
                this.iPersistVector.add(key);
            }
            ++i;
        }
    }

    public Element getRootElement() {
        return this.rootElement;
    }

    public List<String> getPersistTrueIDs() {
        return this.iPersistVector;
    }
}

