/*
 * Decompiled with CFR 0.152.
 */
package com.symbian.cdt.templateengine;

import com.symbian.cdt.templateengine.Template;
import com.symbian.cdt.templateengine.TemplateEnginePlugin;
import com.symbian.cdt.templateengine.TemplateInfo;
import com.symbian.cdt.templateengine.process.ProcessFailureException;
import com.symbian.cdt.templateengine.shareddefaults.SharedDefaults;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateEngine {
    private static TemplateEngine TEMPLATE_ENGINE;
    private static String TEMPLATES_EXTENSION_ID;
    private Map<String, List<TemplateInfo>> iTemplateInfoMap = new HashMap<String, List<TemplateInfo>>();

    static {
        TEMPLATES_EXTENSION_ID = String.valueOf(TemplateEnginePlugin.getUniqueId()) + ".templates";
        TEMPLATE_ENGINE = new TemplateEngine();
    }

    private TemplateEngine() {
        this.initializeTemplateInfoMap();
    }

    public Template[] getAllTemplates() {
        ArrayList<TemplateInfo> infoList = new ArrayList<TemplateInfo>();
        for (List<TemplateInfo> templateInfos : this.iTemplateInfoMap.values()) {
            infoList.addAll(templateInfos);
        }
        ArrayList<Template> templates = new ArrayList<Template>(infoList.size());
        for (TemplateInfo info : infoList) {
            try {
                templates.add(Template.getTemplate(info));
            }
            catch (Throwable throwable) {}
        }
        return templates.toArray(new Template[templates.size()]);
    }

    public Template getFirstTemplate(String aWizardId, String aPattern, String aProjType) {
        TemplateInfo[] templateInfoArray = this.getTemplateInfos(aWizardId, aPattern, aProjType);
        int n = 0;
        int n2 = templateInfoArray.length;
        while (n < n2) {
            TemplateInfo templateInfo = templateInfoArray[n];
            try {
                return Template.getTemplate(templateInfo);
            }
            catch (Throwable throwable) {
                ++n;
            }
        }
        return null;
    }

    public Template[] getTemplates(String aWizardId, String sdkId, String aProjType) {
        TemplateInfo[] templateInfoArray = this.getTemplateInfos(aWizardId, sdkId, aProjType);
        ArrayList<Template> templatesList = new ArrayList<Template>();
        TemplateInfo[] templateInfoArray2 = templateInfoArray;
        int n = 0;
        int n2 = templateInfoArray2.length;
        while (n < n2) {
            TemplateInfo info = templateInfoArray2[n];
            try {
                templatesList.add(Template.getTemplate(info));
            }
            catch (Throwable throwable) {}
            ++n;
        }
        return templatesList.toArray(new Template[templatesList.size()]);
    }

    public Map<String, String> getSharedDefaults() {
        return SharedDefaults.getSharedDefaultsInstance().getSharedDefaultsMap();
    }

    public void updateSharedDefaults(Template template) {
        HashMap<String, String> tobePersisted = new HashMap<String, String>();
        Map<String, String> valueStore = template.getValueStore();
        for (String key : template.getPersistTrueIDs()) {
            tobePersisted.put(key, valueStore.get(key));
        }
        SharedDefaults.getSharedDefaultsInstance().updateShareDefaultsMap(tobePersisted);
    }

    public static TemplateEngine getTemplateEngine() {
        return TEMPLATE_ENGINE;
    }

    private void initializeTemplateInfoMap() {
        String location = null;
        String pluginId = null;
        String wizardId = null;
        String filterPattern = null;
        String projectType = null;
        IExtension[] iExtensionArray = Platform.getExtensionRegistry().getExtensionPoint(TEMPLATES_EXTENSION_ID).getExtensions();
        int n = 0;
        int n2 = iExtensionArray.length;
        while (n < n2) {
            IExtension extension = iExtensionArray[n];
            IConfigurationElement[] configElements = extension.getConfigurationElements();
            pluginId = extension.getNamespace();
            IConfigurationElement[] iConfigurationElementArray = configElements;
            int n3 = 0;
            int n4 = iConfigurationElementArray.length;
            while (n3 < n4) {
                IConfigurationElement config = iConfigurationElementArray[n3];
                location = config.getAttribute("location");
                wizardId = config.getAttribute("wizardId");
                filterPattern = config.getAttribute("filterPattern");
                projectType = config.getAttribute("projectType");
                TemplateInfo templateInfo = new TemplateInfo(wizardId, filterPattern, location, pluginId, projectType);
                if (!this.iTemplateInfoMap.containsKey(wizardId)) {
                    this.iTemplateInfoMap.put(wizardId, new ArrayList());
                }
                this.iTemplateInfoMap.get(wizardId).add(templateInfo);
                ++n3;
            }
            ++n;
        }
    }

    public TemplateInfo[] getTemplateInfos(String wizardId, String sdkId, String projType) {
        List<TemplateInfo> templateInfoList = this.iTemplateInfoMap.get(wizardId);
        ArrayList<TemplateInfo> matchedTemplateInfoList = new ArrayList<TemplateInfo>();
        if (templateInfoList != null) {
            for (TemplateInfo templateInfo : templateInfoList) {
                String filterPattern = templateInfo.getFilterPattern();
                String projectType = templateInfo.getProjectType();
                if (sdkId == null || filterPattern == null || filterPattern.trim().length() == 0) {
                    if (projectType == null || projectType.trim().length() == 0) {
                        matchedTemplateInfoList.add(templateInfo);
                        continue;
                    }
                    if (!projectType.equals(projType)) continue;
                    matchedTemplateInfoList.add(templateInfo);
                    continue;
                }
                if (sdkId == null || !sdkId.matches(filterPattern)) continue;
                if (projectType == null || projectType.trim().length() == 0) {
                    matchedTemplateInfoList.add(templateInfo);
                    continue;
                }
                if (!projectType.equals(projType)) continue;
                matchedTemplateInfoList.add(templateInfo);
            }
        }
        return matchedTemplateInfoList.toArray(new TemplateInfo[matchedTemplateInfoList.size()]);
    }

    public Map<String, List<TemplateInfo>> getTemplateInfoMap() {
        return this.iTemplateInfoMap;
    }

    public static void log(Throwable t) {
        if (t == null) {
            return;
        }
        if (t instanceof InvocationTargetException) {
            t = ((InvocationTargetException)t).getTargetException();
        }
        if (t instanceof CoreException) {
            ResourcesPlugin.getPlugin().getLog().log(((CoreException)t).getStatus());
        }
        if (t instanceof ProcessFailureException) {
            do {
                List<IStatus> statuses;
                if ((statuses = ((ProcessFailureException)t).getStatuses()) == null) continue;
                for (IStatus status : statuses) {
                    ResourcesPlugin.getPlugin().getLog().log(status);
                }
            } while ((t = t.getCause()) != null && t instanceof ProcessFailureException);
        } else {
            ResourcesPlugin.getPlugin().getLog().log((IStatus)new Status(4, TemplateEnginePlugin.getUniqueId(), 0, t.getMessage() == null ? t.toString() : t.getMessage(), t));
        }
    }

    public static void showError(String message, Throwable t) {
        Object status;
        TemplateEngine.log(t);
        if (t != null) {
            if (t instanceof ProcessFailureException) {
                List<IStatus> statuses = ((ProcessFailureException)t).getStatuses();
                if (statuses == null || statuses.isEmpty()) {
                    Throwable p = t;
                    do {
                        if ((p = p.getCause()) == null) continue;
                        statuses = ((ProcessFailureException)p).getStatuses();
                    } while ((statuses == null || statuses.isEmpty()) && p != null && p instanceof ProcessFailureException);
                    status = statuses == null || statuses.isEmpty() ? new Status(4, TemplateEnginePlugin.getUniqueId(), 4, t.getMessage(), t) : new MultiStatus(TemplateEnginePlugin.getUniqueId(), 4, statuses.toArray(new IStatus[statuses.size()]), t.getMessage(), t);
                } else {
                    status = new MultiStatus(TemplateEnginePlugin.getUniqueId(), 4, statuses.toArray(new IStatus[statuses.size()]), t.getMessage(), t);
                }
            } else if (t instanceof CoreException) {
                status = ((CoreException)t).getStatus();
                if (status != null && message.equals(status.getMessage())) {
                    message = null;
                }
            } else {
                status = new Status(4, TemplateEnginePlugin.getUniqueId(), -1, "Internal Error: " + message, t);
            }
        } else {
            status = new Status(4, TemplateEnginePlugin.getUniqueId(), -1, "Internal Error: " + message, null);
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
            window = windows[0];
        }
        ErrorDialog.openError((Shell)window.getShell(), (String)"Template Engine", (String)message, (IStatus)status);
    }

    public static void showStatusDialog(String message, IStatus status) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
            window = windows[0];
        }
        ErrorDialog.openError((Shell)window.getShell(), (String)"Template Engine", (String)message, (IStatus)status);
    }

    public URL getTemplateSchemaURL() throws IOException {
        return Platform.asLocalURL((URL)Platform.getBundle((String)TemplateEnginePlugin.getUniqueId()).getEntry("schema/TemplateDescriptorSchema.xsd"));
    }

    public static List<Element> getChildrenOfElement(Element elem) {
        ArrayList<Element> list = new ArrayList<Element>();
        NodeList children = elem.getChildNodes();
        int i = 0;
        int l = children.getLength();
        while (i < l) {
            Node child = children.item(i);
            if (child.getNodeType() == 1) {
                list.add((Element)child);
            }
            ++i;
        }
        return list;
    }

    public static List<Element> getChildrenOfElementByTag(Element elem, String tag) {
        ArrayList<Element> list = new ArrayList<Element>();
        NodeList children = elem.getChildNodes();
        int i = 0;
        int l = children.getLength();
        while (i < l) {
            Node child = children.item(i);
            if (child.getNodeType() == 1 && child.getNodeName().equals(tag)) {
                list.add((Element)child);
            }
            ++i;
        }
        return list;
    }
}

