/*
 * Decompiled with CFR 0.152.
 */
package com.symbian.cdt.templateengine;

import com.symbian.cdt.templateengine.Template;
import com.symbian.cdt.templateengine.TemplateEnginePlugin;
import com.symbian.cdt.templateengine.TemplateInfo;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;

public class TemplateEngineHelper {
    public static final String TEMPLATE_ENGINE_PLUGINID = "com.symbian.cdt.templateengine";
    public static final String OPEN_MARKER = "$(";
    public static final String CLOSE_MARKER = ")";
    public static final String LOGGER_FILE_NAME = "Process";
    public static final String PROJRESOURCE = "plugin.xml";
    public static final String BOOLTRUE = "true";
    public static final String ID = "Id";
    public static final String VALUE = "Value";
    public static final String SDLOG_FILE_NAME = "SharedDefaults";
    public static final String EXISTS = " Project already exists in workspace.";
    public static final String LOCATION = "location";
    public static final String WIZARD_ID = "wizardId";
    public static final String FILTER_PATTERN = "filterPattern";
    public static final String PROJECT_TYPE = "projectType";

    public static File getFileInPluginOfTemplateEngine(IPath aPath) {
        URL url = null;
        try {
            url = TemplateEnginePlugin.getDefault().find(aPath, null);
            url = Platform.asLocalURL((URL)url);
        }
        catch (Exception exception) {}
        return new File(url.getFile());
    }

    public static File getSharedDefaultLocation(String aSharedLocation) {
        File sharedXMLFile = TemplateEngineHelper.findLocation(aSharedLocation);
        return sharedXMLFile;
    }

    private static File findLocation(String fileLocation) {
        TemplateEnginePlugin plugin = TemplateEnginePlugin.getDefault();
        IPath stateLoc = Platform.getPluginStateLocation((Plugin)plugin);
        fileLocation = String.valueOf(stateLoc.toString()) + File.separator + fileLocation;
        File file = new File(fileLocation);
        return file;
    }

    public static File storeSharedDefaultLocation(String aSharedLocation) {
        File sharedXMLFile = TemplateEngineHelper.findLocation(aSharedLocation);
        try {
            TemplateEngineHelper.createNewFile(sharedXMLFile.getPath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sharedXMLFile;
    }

    public static void createNewFile(String aFileName) throws IOException {
        new File(aFileName).createNewFile();
    }

    public static IPath getWorkspacePath() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        Path workSpacePath = new Path(String.valueOf(root.getLocation().toString()) + File.separator);
        return workSpacePath;
    }

    public static String getFirstMarkerID(String aMarkerString) {
        String key = null;
        if (aMarkerString.contains(OPEN_MARKER)) {
            key = aMarkerString.substring(aMarkerString.indexOf(OPEN_MARKER) + OPEN_MARKER.length(), aMarkerString.indexOf(CLOSE_MARKER));
        }
        return key;
    }

    public static boolean checkDirectoryInWorkspace(String aDirectoryName) {
        boolean retVal = false;
        File file = null;
        try {
            file = new File(TemplateEngineHelper.getWorkspacePath() + aDirectoryName);
        }
        catch (Exception exception) {}
        if (file != null && file.exists() && file.isDirectory()) {
            retVal = true;
        }
        return retVal;
    }

    public static URL getTemplateResourceURL(String pluginId, String resourcePath) throws IOException {
        return Platform.asLocalURL((URL)Platform.getBundle((String)pluginId).getEntry(resourcePath));
    }

    public static URL getTemplateResourceURLRelativeToTemplate(Template template, String resourcePath) throws IOException {
        TemplateInfo templateInfo = template.getTemplateInfo();
        String path = templateInfo.getTemplatePath();
        int slash = path.lastIndexOf("/");
        path = slash == -1 ? resourcePath : String.valueOf(path.substring(0, slash + 1)) + resourcePath;
        URL entry = Platform.getBundle((String)templateInfo.getPluginId()).getEntry(path);
        if (entry == null) {
            return null;
        }
        return Platform.asLocalURL((URL)entry);
    }
}

