/*
 * Decompiled with CFR 0.152.
 */
package com.symbian.cdt.templateengine.process;

import com.symbian.cdt.templateengine.Template;
import com.symbian.cdt.templateengine.TemplateEngine;
import com.symbian.cdt.templateengine.TemplateEnginePlugin;
import com.symbian.cdt.templateengine.process.Process;
import com.symbian.cdt.templateengine.process.ProcessFailureException;
import com.symbian.cdt.templateengine.process.ProcessHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConditionalProcessGroup {
    private Template template;
    private Set<String> macros;
    private String conditionString;
    private String lValue;
    private String rValue;
    private Operator op;
    private List<Process> processes;
    private String id;

    public ConditionalProcessGroup(Template template, Element conditionElement, int id) {
        this.id = "Condition " + id;
        this.conditionString = conditionElement.getAttribute("condition");
        if (this.conditionString != null) {
            if (this.conditionString.trim().equals("")) {
                this.conditionString = null;
            } else {
                int op = this.conditionString.indexOf("==");
                if (op != -1) {
                    this.op = Operator.EQUALS;
                    this.lValue = this.conditionString.substring(0, op);
                    this.rValue = this.conditionString.substring(op + "==".length());
                } else {
                    op = this.conditionString.indexOf("!=");
                    if (op != -1) {
                        this.op = Operator.NOT_EQUALS;
                        this.lValue = this.conditionString.substring(0, op);
                        this.rValue = this.conditionString.substring(op + "!=".length());
                    }
                }
                this.collectMacros(this.lValue);
                this.collectMacros(this.rValue);
            }
        }
        this.createProcessObjects(template, TemplateEngine.getChildrenOfElementByTag(conditionElement, "process"));
    }

    private void collectMacros(String value) {
        if (value != null) {
            if (this.macros == null) {
                this.macros = new HashSet<String>();
            }
            this.macros.addAll(ProcessHelper.getReplaceKeys(value));
        }
    }

    public ConditionalProcessGroup(Template template, Element[] processElements) {
        this.id = "No Condition";
        this.createProcessObjects(template, Arrays.asList(processElements));
    }

    private void createProcessObjects(Template template, List<Element> processElements) {
        this.template = template;
        this.processes = new ArrayList<Process>(processElements.size());
        int j = 0;
        int l = processElements.size();
        while (j < l) {
            Element processElem = processElements.get(j);
            if (processElem.getNodeName().equals("process")) {
                String processId = String.valueOf(this.id) + "--> Process " + (j + 1) + " (" + processElem.getAttribute("type") + ")";
                this.processes.add(new Process(template, processElem, processId));
            }
            ++j;
        }
    }

    public boolean isReadyToProcess() {
        return this.areMacrosForConditionEvaluationExpandable() && this.isConditionValueTrue() && this.areProcessesReady();
    }

    private boolean areProcessesReady() {
        for (Process process : this.processes) {
            if (process.isReadyToProcess()) continue;
            return false;
        }
        return true;
    }

    private boolean areMacrosForConditionEvaluationExpandable() {
        if (this.macros != null) {
            Map<String, String> valueStore = this.template.getValueStore();
            for (String value : this.macros) {
                if (valueStore.get(value) != null) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isConditionValueTrue() {
        if (this.conditionString == null) {
            return true;
        }
        if (!this.areMacrosForConditionEvaluationExpandable()) {
            return false;
        }
        Map<String, String> valueStore = this.template.getValueStore();
        String lValue = this.lValue;
        String rValue = this.rValue;
        for (String value : this.macros) {
            lValue = lValue.replaceAll("$(" + value + ")", valueStore.get(value));
            rValue = rValue.replaceAll("$(" + value + ")", valueStore.get(value));
        }
        switch (this.op) {
            case EQUALS: {
                return lValue.equals(rValue);
            }
            case NOT_EQUALS: {
                return !lValue.equals(rValue);
            }
        }
        return false;
    }

    public List<IStatus> process() throws ProcessFailureException {
        if (!this.areMacrosForConditionEvaluationExpandable()) {
            throw new ProcessFailureException(this.getUnexpandableMacroMessage());
        }
        if (!this.isConditionValueTrue()) {
            ArrayList<IStatus> statuses = new ArrayList<IStatus>(1);
            statuses.add((IStatus)new Status(4, TemplateEnginePlugin.getUniqueId(), 1, "Condition block not executing: " + this.id, null));
            return statuses;
        }
        ArrayList<IStatus> statuses = new ArrayList<IStatus>(this.processes.size());
        for (Process process : this.processes) {
            try {
                statuses.add(process.process());
            }
            catch (ProcessFailureException e) {
                throw new ProcessFailureException(e.getMessage(), e, statuses);
            }
        }
        return statuses;
    }

    private String getUnexpandableMacroMessage() {
        if (this.macros != null) {
            Map<String, String> valueStore = this.template.getValueStore();
            for (String value : this.macros) {
                if (valueStore.get(value) != null) continue;
                return "Condition has an unexpandable macro: " + value;
            }
        }
        return null;
    }

    public Set<String> getMacros() {
        return this.macros;
    }

    public Set<String> getAllMacros() {
        HashSet<String> set = null;
        if (this.macros != null) {
            set = new HashSet<String>();
            set.addAll(this.macros);
        }
        for (Process process : this.processes) {
            Set<String> subSet = process.getMacros();
            if (subSet == null) continue;
            if (set == null) {
                set = new HashSet();
            }
            set.addAll(subSet);
        }
        return set;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Operator {
        EQUALS,
        NOT_EQUALS;

    }
}

