/*
 * Decompiled with CFR 0.152.
 */
package com.symbian.cdt.templateengine.process;

import com.symbian.cdt.templateengine.Template;
import com.symbian.cdt.templateengine.TemplateEngine;
import com.symbian.cdt.templateengine.TemplateEnginePlugin;
import com.symbian.cdt.templateengine.process.ProcessArgument;
import com.symbian.cdt.templateengine.process.ProcessFailureException;
import com.symbian.cdt.templateengine.process.ProcessParameter;
import com.symbian.cdt.templateengine.process.ProcessRunner;
import com.symbian.cdt.templateengine.process.ProcessRunnerFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Process {
    public static final String ELEM_TYPE = "type";
    private ProcessRunner processRunner;
    private ProcessArgument[] args;
    private Template template;
    private String id;
    private String processType;

    public Process(Template template, Element element, String id) {
        this.template = template;
        this.id = id;
        this.processType = element.getAttribute(ELEM_TYPE);
        this.processRunner = ProcessRunnerFactory.getDefault().getProcessRunner(this.processType);
        if (this.processRunner != null) {
            this.buildArgs(template, element);
        }
    }

    private void buildArgs(Template template, Element element) {
        List<Element> children = TemplateEngine.getChildrenOfElement(element);
        ProcessParameter[] params = this.processRunner.getProcessParameters();
        ArrayList<ProcessArgument> list = new ArrayList<ProcessArgument>(params.length);
        int i = 0;
        int l = children.size();
        ProcessParameter[] processParameterArray = params;
        int n = 0;
        int n2 = processParameterArray.length;
        while (n < n2) {
            Element child;
            ProcessParameter param = processParameterArray[n];
            Element element2 = child = i < l ? children.get(i) : null;
            if (param.isExternal() && (child == null || !param.getName().equals(child.getAttribute("name")))) {
                list.add(new ProcessArgument(template, param));
            } else if (i < l) {
                list.add(new ProcessArgument(template, child));
                ++i;
            }
            ++n;
        }
        while (i < l) {
            list.add(new ProcessArgument(template, children.get(i++)));
        }
        this.args = list.toArray(new ProcessArgument[list.size()]);
    }

    public boolean isReadyToProcess() {
        return this.processRunner != null && this.processRunner.areArgumentsMatchingRequiredParameters(this.args) && this.areAllMacrosExpandable();
    }

    private boolean areAllMacrosExpandable() {
        if (this.args != null) {
            ProcessArgument[] processArgumentArray = this.args;
            int n = 0;
            int n2 = processArgumentArray.length;
            while (n < n2) {
                ProcessArgument arg = processArgumentArray[n];
                if (!arg.areAllMacrosExpandable()) {
                    return false;
                }
                ++n;
            }
        }
        return true;
    }

    private String getFirstNonExpandableMacroMessage(ProcessArgument[] args2) {
        if (this.args != null) {
            ProcessArgument[] processArgumentArray = this.args;
            int n = 0;
            int n2 = processArgumentArray.length;
            while (n < n2) {
                ProcessArgument arg = processArgumentArray[n];
                String macro = arg.getFirstNonExpandableMacro();
                if (macro != null) {
                    return "Argument " + arg.getName() + " has an unexpandable macro: " + macro;
                }
                ++n;
            }
        }
        return null;
    }

    private String getProcessMessage(int code, String msg) {
        switch (code) {
            case 4: {
                return String.valueOf(this.id) + "-->Error: " + msg;
            }
            case 0: {
                return String.valueOf(this.id) + "-->Success: " + msg;
            }
        }
        return String.valueOf(this.id) + "-->Info: " + msg;
    }

    public IStatus process() throws ProcessFailureException {
        if (this.processRunner == null) {
            throw new ProcessFailureException("Unknown process: " + this.processType);
        }
        if (!this.processRunner.areArgumentsMatchingRequiredParameters(this.args)) {
            throw new ProcessFailureException(this.processRunner.getArgumentsMismatchMessage(this.args));
        }
        if (!this.areAllMacrosExpandable()) {
            throw new ProcessFailureException(this.getProcessMessage(4, this.getFirstNonExpandableMacroMessage(this.args)));
        }
        this.resolve();
        this.processRunner.process(this.template, this.args, this.id);
        return new Status(1, TemplateEnginePlugin.getUniqueId(), 0, this.getProcessMessage(0, "Executed successfully with args: " + Arrays.asList(this.args)), null);
    }

    private void resolve() {
        if (this.args != null) {
            ProcessArgument[] processArgumentArray = this.args;
            int n = 0;
            int n2 = processArgumentArray.length;
            while (n < n2) {
                ProcessArgument arg = processArgumentArray[n];
                if (!arg.isResolved()) {
                    arg.resolve();
                }
                ++n;
            }
        }
    }

    public Set<String> getMacros() {
        HashSet<String> set = null;
        if (this.args != null) {
            ProcessArgument[] processArgumentArray = this.args;
            int n = 0;
            int n2 = processArgumentArray.length;
            while (n < n2) {
                ProcessArgument arg = processArgumentArray[n];
                Set<String> subSet = arg.getMacros();
                if (subSet != null) {
                    if (set == null) {
                        set = new HashSet<String>();
                    }
                    set.addAll(subSet);
                }
                ++n;
            }
        }
        return set;
    }

    public String toString() {
        return this.id;
    }
}

