/*
 * Decompiled with CFR 0.152.
 */
package com.symbian.cdt.templateengine.process;

import com.symbian.cdt.templateengine.Template;
import com.symbian.cdt.templateengine.TemplateEngine;
import com.symbian.cdt.templateengine.process.ProcessHelper;
import com.symbian.cdt.templateengine.process.ProcessParameter;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessArgument {
    static final String ELEM_NAME = "name";
    private static final String ELEM_VALUE = "value";
    private static final String ELEM_ELEMENT = "element";
    private static final String ELEM_SIMPLE = "simple";
    private static final String ELEM_SIMPLE_ARRAY = "simple-array";
    private static final String ELEM_COMPLEX = "complex";
    private static final String ELEM_COMPLEX_ARRAY = "complex-array";
    private String name;
    private byte type;
    private String simpleValue;
    private String[] simpleValueArray;
    private ProcessArgument[] complexValue;
    private ProcessArgument[][] complexValueArray;
    private String resolvedSimpleValue;
    private String[] resolvedSimpleValueArray;
    private Template template;
    private Set<String> macros;
    private boolean resolved;
    private ProcessParameter externalParam;

    public ProcessArgument(Template template, Element elem) {
        block9: {
            String elemName;
            block11: {
                block10: {
                    block8: {
                        this.template = template;
                        this.name = elem.getAttribute(ELEM_NAME);
                        elemName = elem.getNodeName();
                        if (!elemName.equals(ELEM_SIMPLE)) break block8;
                        this.type = 1;
                        this.simpleValue = elem.getAttribute(ELEM_VALUE);
                        this.collectMacros(this.simpleValue);
                        break block9;
                    }
                    if (!elemName.equals(ELEM_SIMPLE_ARRAY)) break block10;
                    this.type = (byte)2;
                    List<Element> valueElements = TemplateEngine.getChildrenOfElementByTag(elem, ELEM_ELEMENT);
                    this.simpleValueArray = new String[valueElements.size()];
                    int i = 0;
                    int l = valueElements.size();
                    while (i < l) {
                        this.simpleValueArray[i] = valueElements.get(i).getAttribute(ELEM_VALUE);
                        this.collectMacros(this.simpleValueArray[i]);
                        ++i;
                    }
                    break block9;
                }
                if (!elemName.equals(ELEM_COMPLEX)) break block11;
                this.type = (byte)3;
                List<Element> children = TemplateEngine.getChildrenOfElement(elem);
                this.complexValue = new ProcessArgument[children.size()];
                int i = 0;
                int l = children.size();
                while (i < l) {
                    this.complexValue[i] = new ProcessArgument(template, children.get(i));
                    Set<String> subMacros = this.complexValue[i].getMacros();
                    if (this.macros == null) {
                        this.macros = new HashSet<String>();
                    }
                    if (subMacros != null) {
                        this.macros.addAll(subMacros);
                    }
                    ++i;
                }
                break block9;
            }
            if (!elemName.equals(ELEM_COMPLEX_ARRAY)) break block9;
            this.type = (byte)4;
            List<Element> valueElements = TemplateEngine.getChildrenOfElementByTag(elem, ELEM_ELEMENT);
            this.complexValueArray = new ProcessArgument[valueElements.size()][];
            int i = 0;
            int l = valueElements.size();
            while (i < l) {
                List<Element> children = TemplateEngine.getChildrenOfElement(valueElements.get(i));
                this.complexValueArray[i] = new ProcessArgument[children.size()];
                int j = 0;
                int l2 = children.size();
                while (j < l2) {
                    this.complexValueArray[i][j] = new ProcessArgument(template, children.get(j));
                    Set<String> subMacros = this.complexValueArray[i][j].getMacros();
                    if (subMacros != null) {
                        if (this.macros == null) {
                            this.macros = new HashSet<String>();
                        }
                        this.macros.addAll(subMacros);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public ProcessArgument(Template template, ProcessParameter param) {
        this.template = template;
        this.name = param.getName();
        this.type = param.getType();
        this.macros = new HashSet<String>();
        this.macros.add(this.name);
        this.simpleValue = ProcessHelper.getReplaceMarker(this.name);
        this.externalParam = param;
    }

    private void collectMacros(String value) {
        if (value == null) {
            return;
        }
        if (this.macros == null) {
            this.macros = new HashSet<String>();
        }
        this.macros.addAll(ProcessHelper.getReplaceKeys(value));
    }

    public String getName() {
        return this.name;
    }

    public byte getParameterType() {
        return this.type;
    }

    public String getSimpleValue() {
        return this.resolved ? this.resolvedSimpleValue : this.simpleValue;
    }

    public String[] getSimpleArrayValue() {
        return this.resolved ? this.resolvedSimpleValueArray : this.simpleValueArray;
    }

    public ProcessArgument[] getComplexValue() {
        return this.complexValue;
    }

    public ProcessArgument[][] getComplexArrayValue() {
        return this.complexValueArray;
    }

    public boolean isOfParameterType(ProcessParameter param) {
        if (param.getType() != this.type || !param.getName().equals(this.name)) {
            return false;
        }
        switch (this.type) {
            case 1: {
                return this.simpleValue != null || param.isNullable();
            }
            case 2: {
                return true;
            }
            case 3: {
                ProcessParameter[] params = param.getComplexChildren();
                if (params.length != this.complexValue.length) {
                    return false;
                }
                int i = 0;
                while (i < this.complexValue.length) {
                    if (!this.complexValue[i].isOfParameterType(params[i])) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            case 4: {
                ProcessParameter[] params = param.getComplexChildren();
                ProcessArgument[][] processArgumentArray = this.complexValueArray;
                int n = 0;
                int n2 = processArgumentArray.length;
                while (n < n2) {
                    ProcessArgument[] complexValue = processArgumentArray[n];
                    if (params.length != complexValue.length) {
                        return false;
                    }
                    int i = 0;
                    while (i < complexValue.length) {
                        if (!complexValue[i].isOfParameterType(params[i])) {
                            return false;
                        }
                        ++i;
                    }
                    ++n;
                }
                return true;
            }
        }
        return false;
    }

    public boolean areAllMacrosExpandable() {
        switch (this.type) {
            case 1: {
                if (this.externalParam != null) {
                    return this.externalParam.isNullable() || this.template.getValueStore().get(this.name) != null;
                }
            }
            case 2: {
                if (this.macros == null || this.macros.size() == 0) {
                    return true;
                }
                Map<String, String> valueStore = this.template.getValueStore();
                for (String macro : this.macros) {
                    if (valueStore.get(macro) != null) continue;
                    return false;
                }
                return true;
            }
            case 3: {
                ProcessArgument[] processArgumentArray = this.complexValue;
                int n = 0;
                int n2 = processArgumentArray.length;
                while (n < n2) {
                    ProcessArgument arg = processArgumentArray[n];
                    if (!arg.areAllMacrosExpandable()) {
                        return false;
                    }
                    ++n;
                }
                return true;
            }
            case 4: {
                ProcessArgument[][] processArgumentArray = this.complexValueArray;
                int n = 0;
                int n3 = processArgumentArray.length;
                while (n < n3) {
                    ProcessArgument[] complexValue;
                    ProcessArgument[] processArgumentArray2 = complexValue = processArgumentArray[n];
                    int n4 = 0;
                    int n5 = processArgumentArray2.length;
                    while (n4 < n5) {
                        ProcessArgument arg = processArgumentArray2[n4];
                        if (!arg.areAllMacrosExpandable()) {
                            return false;
                        }
                        ++n4;
                    }
                    ++n;
                }
                return true;
            }
        }
        return true;
    }

    public String getFirstNonExpandableMacro() {
        switch (this.type) {
            case 1: 
            case 2: {
                if (this.macros == null || this.macros.size() == 0) {
                    return null;
                }
                Map<String, String> valueStore = this.template.getValueStore();
                for (String macro : this.macros) {
                    if (valueStore.get(macro) != null) continue;
                    return macro;
                }
                return null;
            }
            case 3: {
                ProcessArgument[] processArgumentArray = this.complexValue;
                int n = 0;
                int n2 = processArgumentArray.length;
                while (n < n2) {
                    ProcessArgument arg = processArgumentArray[n];
                    String macro = arg.getFirstNonExpandableMacro();
                    if (macro != null) {
                        return macro;
                    }
                    ++n;
                }
                return null;
            }
            case 4: {
                ProcessArgument[][] processArgumentArray = this.complexValueArray;
                int n = 0;
                int n3 = processArgumentArray.length;
                while (n < n3) {
                    ProcessArgument[] complexValue;
                    ProcessArgument[] processArgumentArray2 = complexValue = processArgumentArray[n];
                    int n4 = 0;
                    int n5 = processArgumentArray2.length;
                    while (n4 < n5) {
                        ProcessArgument arg = processArgumentArray2[n4];
                        String macro = arg.getFirstNonExpandableMacro();
                        if (macro != null) {
                            return macro;
                        }
                        ++n4;
                    }
                    ++n;
                }
                return null;
            }
        }
        return null;
    }

    public Set<String> getMacros() {
        return this.macros;
    }

    public void resolve() {
        Map<String, String> valueStore = this.template.getValueStore();
        switch (this.type) {
            case 1: {
                if (this.externalParam != null) {
                    this.resolvedSimpleValue = this.template.getValueStore().get(this.name);
                    break;
                }
                this.resolvedSimpleValue = this.simpleValue;
                if (this.macros == null || this.macros.isEmpty()) break;
                this.resolvedSimpleValue = ProcessHelper.getValueAfterExpandingMacros(this.resolvedSimpleValue, this.macros, valueStore);
                break;
            }
            case 2: {
                this.resolvedSimpleValueArray = this.simpleValueArray;
                if (this.macros == null || this.macros.isEmpty()) break;
                int i = 0;
                while (i < this.resolvedSimpleValueArray.length) {
                    this.resolvedSimpleValueArray[i] = ProcessHelper.getValueAfterExpandingMacros(this.resolvedSimpleValueArray[i], this.macros, valueStore);
                    ++i;
                }
                break;
            }
            case 3: {
                ProcessArgument[] processArgumentArray = this.complexValue;
                int n = 0;
                int n2 = processArgumentArray.length;
                while (n < n2) {
                    ProcessArgument arg = processArgumentArray[n];
                    arg.resolve();
                    ++n;
                }
                break;
            }
            case 4: {
                ProcessArgument[][] processArgumentArray = this.complexValueArray;
                int n = 0;
                int n3 = processArgumentArray.length;
                while (n < n3) {
                    ProcessArgument[] complexValue;
                    ProcessArgument[] processArgumentArray2 = complexValue = processArgumentArray[n];
                    int n4 = 0;
                    int n5 = processArgumentArray2.length;
                    while (n4 < n5) {
                        ProcessArgument arg = processArgumentArray2[n4];
                        arg.resolve();
                        ++n4;
                    }
                    ++n;
                }
                break;
            }
        }
        this.resolved = true;
    }

    public boolean isResolved() {
        return this.resolved;
    }

    public String toString() {
        StringBuilder b = new StringBuilder(this.name);
        b.append(":");
        switch (this.type) {
            case 1: {
                return b.append(this.getSimpleValue()).toString();
            }
            case 2: {
                b.append("{");
                String[] stringArray = this.getSimpleArrayValue();
                int n = 0;
                int n2 = stringArray.length;
                while (n < n2) {
                    String s = stringArray[n];
                    b.append(s).append(", ");
                    ++n;
                }
                if (b.charAt(b.length() - 1) == ' ') {
                    b.replace(b.length() - 2, b.length(), "}");
                } else {
                    b.append("}");
                }
                return b.toString();
            }
            case 3: {
                b.append("{");
                ProcessArgument[] processArgumentArray = this.getComplexValue();
                int n = 0;
                int n3 = processArgumentArray.length;
                while (n < n3) {
                    ProcessArgument arg = processArgumentArray[n];
                    b.append(arg).append(", ");
                    ++n;
                }
                if (b.charAt(b.length() - 1) == ' ') {
                    b.replace(b.length() - 2, b.length(), "}");
                } else {
                    b.append("}");
                }
                return b.toString();
            }
            case 4: {
                b.append("{");
                ProcessArgument[][] processArgumentArray = this.getComplexArrayValue();
                int n = 0;
                int n4 = processArgumentArray.length;
                while (n < n4) {
                    ProcessArgument[] args = processArgumentArray[n];
                    b.append("{");
                    ProcessArgument[] processArgumentArray2 = args;
                    int n5 = 0;
                    int n6 = processArgumentArray2.length;
                    while (n5 < n6) {
                        ProcessArgument arg = processArgumentArray2[n5];
                        b.append(arg).append(", ");
                        ++n5;
                    }
                    if (b.charAt(b.length() - 1) == ' ') {
                        b.replace(b.length() - 2, b.length(), "}, ");
                    } else {
                        b.append("}, ");
                    }
                    ++n;
                }
                if (b.charAt(b.length() - 1) == ' ') {
                    b.replace(b.length() - 2, b.length(), "}");
                } else {
                    b.append("}");
                }
                return b.toString();
            }
        }
        return "";
    }
}

