/*
 * Decompiled with CFR 0.152.
 */
package com.symbian.cdt.templateengine.process;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.net.URL;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessHelper {
    public static final String CONDITION = "condition";
    public static final String START_PATTERN = "$(";
    public static final String END_PATTERN = ")";
    public static final String EQUALS = "==";
    public static final String NOT_EQUALS = "!=";

    public static void appendFile(String fileContents, File toFile) throws IOException {
        RandomAccessFile raf = null;
        if (!toFile.exists()) {
            throw new FileNotFoundException(" The specified destination file does not exists ");
        }
        try {
            raf = new RandomAccessFile(toFile, "rw");
            raf.skipBytes((int)raf.length());
            raf.writeBytes(fileContents);
        }
        finally {
            raf.close();
        }
    }

    public static Set<String> getReplaceKeys(String str) {
        int start = 0;
        int end = 0;
        HashSet<String> replaceStrings = new HashSet<String>();
        while ((start = str.indexOf(START_PATTERN, start)) >= 0) {
            end = str.indexOf(END_PATTERN, start);
            if (end == -1) continue;
            replaceStrings.add(str.substring(start + START_PATTERN.length(), end));
            start = end + START_PATTERN.length();
        }
        return replaceStrings;
    }

    public static String readFromFile(URL source) throws IOException {
        int c;
        char[] chars = new char[4092];
        InputStreamReader contentsReader = null;
        StringBuilder buffer = new StringBuilder();
        if (!new File(source.getFile()).exists()) {
            throw new FileNotFoundException("File not found: " + source.getFile());
        }
        contentsReader = new InputStreamReader(source.openStream());
        while ((c = contentsReader.read(chars)) != -1) {
            buffer.append(chars, 0, c);
            if (c != -1) continue;
        }
        contentsReader.close();
        return buffer.toString();
    }

    public static void copyBinaryFile(URL source, File dest) throws IOException {
        File file;
        byte[] bytes = new byte[4092];
        if (source != null && dest != null && (file = new File(source.getFile())).isFile()) {
            int ch;
            FileInputStream fis = new FileInputStream(file);
            FileOutputStream fos = new FileOutputStream(dest);
            while ((ch = fis.read(bytes)) != -1) {
                fos.write(bytes, 0, ch);
            }
        }
    }

    public static void mkdirs(IProject projectHandle, IFolder parentFolder) throws CoreException {
        if (parentFolder.getProjectRelativePath().equals((Object)projectHandle.getProjectRelativePath())) {
            return;
        }
        if (!parentFolder.getParent().exists()) {
            ProcessHelper.mkdirs(projectHandle, projectHandle.getFolder(parentFolder.getParent().getProjectRelativePath()));
        }
        parentFolder.create(true, true, null);
    }

    public static String getValueAfterExpandingMacros(String string, Set<String> macros, Map<String, String> valueStore) {
        for (String key : macros) {
            String value = valueStore.get(key);
            if (value == null) continue;
            string = string.replace(START_PATTERN + key + END_PATTERN, value);
        }
        return string;
    }

    public static String getReplaceMarker(String macro) {
        return START_PATTERN + macro + END_PATTERN;
    }
}

