/*
 * Decompiled with CFR 0.152.
 */
package com.symbian.cdt.templateengine.process;

import org.eclipse.core.runtime.IConfigurationElement;

public class ProcessParameter {
    public static final byte SIMPLE = 1;
    public static final byte SIMPLE_ARRAY = 2;
    public static final byte COMPLEX = 3;
    public static final byte COMPLEX_ARRAY = 4;
    private static final String ELEM_NAME = "name";
    private static final String ELEM_BASE_TYPE = "baseType";
    private static final String ELEM_SIMPLE = "simple";
    private static final String ELEM_SIMPLE_ARRAY = "simpleArray";
    private static final String ELEM_COMPLEX = "complex";
    private static final String ELEM_COMPLEX_ARRAY = "complexArray";
    private static final String ELEM_EXTERNAL = "external";
    private static final String ELEM_NULLABLE = "nullable";
    private String name;
    private byte type;
    private ProcessParameter[] complexChildren;
    private boolean external;
    private boolean nullable;

    public ProcessParameter(IConfigurationElement elem) {
        this.name = elem.getAttribute(ELEM_NAME);
        String elemName = elem.getName();
        if (elemName.equals(ELEM_SIMPLE)) {
            this.type = 1;
        } else if (elemName.equals(ELEM_SIMPLE_ARRAY)) {
            this.type = (byte)2;
        } else if (elemName.equals(ELEM_COMPLEX)) {
            this.type = (byte)3;
            IConfigurationElement[] children = elem.getChildren();
            this.complexChildren = new ProcessParameter[children.length];
            int i = 0;
            IConfigurationElement[] iConfigurationElementArray = children;
            int n = 0;
            int n2 = iConfigurationElementArray.length;
            while (n < n2) {
                IConfigurationElement child = iConfigurationElementArray[n];
                this.complexChildren[i++] = new ProcessParameter(child);
                ++n;
            }
        } else if (elemName.equals(ELEM_COMPLEX_ARRAY)) {
            this.type = (byte)4;
            IConfigurationElement baseType = elem.getChildren(ELEM_BASE_TYPE)[0];
            IConfigurationElement[] children = baseType.getChildren();
            this.complexChildren = new ProcessParameter[children.length];
            int i = 0;
            IConfigurationElement[] iConfigurationElementArray = children;
            int n = 0;
            int n3 = iConfigurationElementArray.length;
            while (n < n3) {
                IConfigurationElement child = iConfigurationElementArray[n];
                this.complexChildren[i++] = new ProcessParameter(child);
                ++n;
            }
        } else {
            throw new IllegalArgumentException();
        }
        String attribute = elem.getAttribute(ELEM_EXTERNAL);
        this.external = attribute == null ? false : Boolean.parseBoolean(attribute);
        attribute = elem.getAttribute(ELEM_NULLABLE);
        this.nullable = attribute == null ? false : Boolean.parseBoolean(attribute);
    }

    public String getName() {
        return this.name;
    }

    public byte getType() {
        return this.type;
    }

    public ProcessParameter[] getComplexChildren() {
        return this.complexChildren;
    }

    public boolean isExternal() {
        return this.external;
    }

    public boolean isNullable() {
        return this.nullable;
    }
}

