/*
 * Decompiled with CFR 0.152.
 */
package com.symbian.cdt.templateengine.process;

import com.symbian.cdt.templateengine.Template;
import com.symbian.cdt.templateengine.process.ProcessArgument;
import com.symbian.cdt.templateengine.process.ProcessFailureException;
import com.symbian.cdt.templateengine.process.ProcessParameter;

public abstract class ProcessRunner {
    private ProcessParameter[] params;

    void setProcessParameters(ProcessParameter[] params) {
        this.params = params;
    }

    public ProcessParameter[] getProcessParameters() {
        return this.params;
    }

    protected final boolean areArgumentsMatchingRequiredParameters(ProcessArgument[] args) {
        if (this.params == null && args != null || this.params != null && args == null) {
            return false;
        }
        if (this.params == null && args == null) {
            return true;
        }
        if (this.params.length != args.length) {
            return false;
        }
        int i = 0;
        while (i < this.params.length) {
            if (!args[i].isOfParameterType(this.params[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String getArgumentsMismatchMessage(ProcessArgument[] args) {
        if (this.params == null && args != null) {
            return "Unexpected arguments found.";
        }
        if (this.params != null && args == null) {
            return "Missing arguments.";
        }
        if (this.params == null && args == null) {
            return null;
        }
        if (this.params.length != args.length) {
            return "Missing arguments.";
        }
        int i = 0;
        while (i < this.params.length) {
            ProcessArgument arg = args[i];
            ProcessParameter param = this.params[i];
            if (!arg.isOfParameterType(param)) {
                return "Argument type mismatch: " + arg.getName();
            }
            ++i;
        }
        return null;
    }

    protected final String getProcessMessage(String processId, int code, String msg) {
        switch (code) {
            case 4: {
                return String.valueOf(processId) + "-->Error: " + msg;
            }
            case 0: {
                return String.valueOf(processId) + "-->Success: " + msg;
            }
        }
        return String.valueOf(processId) + "-->Info: " + msg;
    }

    public abstract void process(Template var1, ProcessArgument[] var2, String var3) throws ProcessFailureException;
}

