/*
 * Decompiled with CFR 0.152.
 */
package com.symbian.cdt.templateengine.process;

import com.symbian.cdt.templateengine.TemplateEngine;
import com.symbian.cdt.templateengine.TemplateEnginePlugin;
import com.symbian.cdt.templateengine.process.ProcessParameter;
import com.symbian.cdt.templateengine.process.ProcessRunner;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

public class ProcessRunnerFactory {
    private static final String EXTENSION_POINT_PROCESSES = String.valueOf(TemplateEnginePlugin.getUniqueId()) + ".processTypes";
    private static final String ELEM_NAME = "name";
    private static final String ELEM_PROCESS_RUNNER = "processRunner";
    private static ProcessRunnerFactory instance = new ProcessRunnerFactory();
    private Map<String, ProcessRunner> processRunnerMap;

    private ProcessRunnerFactory() {
        this.initializeProcessRunners();
    }

    private synchronized void initializeProcessRunners() {
        this.processRunnerMap = new HashMap<String, ProcessRunner>();
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(EXTENSION_POINT_PROCESSES);
        IExtension[] iExtensionArray = point.getExtensions();
        int n = 0;
        int n2 = iExtensionArray.length;
        while (n < n2) {
            IExtension extension = iExtensionArray[n];
            String prefix = String.valueOf(extension.getNamespace()) + ".";
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = 0;
            int n4 = iConfigurationElementArray.length;
            while (n3 < n4) {
                IConfigurationElement element = iConfigurationElementArray[n3];
                String processType = element.getAttribute(ELEM_NAME);
                if (processType != null) {
                    try {
                        ProcessRunner runner = (ProcessRunner)element.createExecutableExtension(ELEM_PROCESS_RUNNER);
                        ArrayList<ProcessParameter> params = null;
                        IConfigurationElement[] iConfigurationElementArray2 = element.getChildren();
                        int n5 = 0;
                        int n6 = iConfigurationElementArray2.length;
                        while (n5 < n6) {
                            IConfigurationElement paramElem = iConfigurationElementArray2[n5];
                            if (params == null) {
                                params = new ArrayList<ProcessParameter>();
                            }
                            params.add(new ProcessParameter(paramElem));
                            ++n5;
                        }
                        if (params != null) {
                            runner.setProcessParameters(params.toArray(new ProcessParameter[params.size()]));
                        }
                        this.processRunnerMap.put(String.valueOf(prefix) + processType, runner);
                    }
                    catch (CoreException e) {
                        TemplateEngine.showError(e.getMessage(), e);
                    }
                }
                ++n3;
            }
            ++n;
        }
    }

    public static ProcessRunnerFactory getDefault() {
        return instance;
    }

    public ProcessRunner getProcessRunner(String processType) {
        return this.processRunnerMap.get(processType);
    }
}

