/*
 * Decompiled with CFR 0.152.
 */
package com.symbian.cdt.templateengine.process;

import com.symbian.cdt.templateengine.Template;
import com.symbian.cdt.templateengine.TemplateDescriptor;
import com.symbian.cdt.templateengine.TemplateEngine;
import com.symbian.cdt.templateengine.process.ConditionalProcessGroup;
import com.symbian.cdt.templateengine.process.ProcessFailureException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateProcessHandler {
    private Template template;
    private List<ConditionalProcessGroup> conditionalProcessGroupList;

    public TemplateProcessHandler(Template template) {
        this.template = template;
        this.initialize();
    }

    private void initialize() {
        TemplateDescriptor desc = this.template.getTemplateDescriptor();
        Element root = desc.getRootElement();
        this.conditionalProcessGroupList = new ArrayList<ConditionalProcessGroup>();
        List<Element> nodeList = TemplateEngine.getChildrenOfElementByTag(root, "if");
        int j = 0;
        int l = nodeList.size();
        while (j < l) {
            this.conditionalProcessGroupList.add(new ConditionalProcessGroup(this.template, nodeList.get(j), j + 1));
            ++j;
        }
        nodeList = TemplateEngine.getChildrenOfElementByTag(root, "process");
        this.conditionalProcessGroupList.add(new ConditionalProcessGroup(this.template, nodeList.toArray(new Element[nodeList.size()])));
    }

    public IStatus[] processAll() throws ProcessFailureException {
        ArrayList<IStatus> allStatuses = new ArrayList<IStatus>();
        for (ConditionalProcessGroup process : this.conditionalProcessGroupList) {
            try {
                allStatuses.addAll(process.process());
            }
            catch (ProcessFailureException e) {
                throw new ProcessFailureException(e.getMessage(), e, allStatuses);
            }
        }
        return allStatuses.toArray(new IStatus[allStatuses.size()]);
    }

    public Set<String> getAllMacros() {
        HashSet<String> set = null;
        for (ConditionalProcessGroup process : this.conditionalProcessGroupList) {
            Set<String> subSet = process.getAllMacros();
            if (subSet == null) continue;
            if (set == null) {
                set = new HashSet<String>();
            }
            set.addAll(subSet);
        }
        return set;
    }
}

