/*
 * Decompiled with CFR 0.152.
 */
package com.symbian.cdt.templateengine.process.processes;

import com.symbian.cdt.templateengine.Template;
import com.symbian.cdt.templateengine.TemplateEngineHelper;
import com.symbian.cdt.templateengine.process.ProcessArgument;
import com.symbian.cdt.templateengine.process.ProcessFailureException;
import com.symbian.cdt.templateengine.process.ProcessHelper;
import com.symbian.cdt.templateengine.process.ProcessRunner;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;

public class AddFile
extends ProcessRunner {
    public void process(Template template, ProcessArgument[] args, String processId) throws ProcessFailureException {
        URL path;
        String projectName = args[0].getSimpleValue();
        ProcessArgument file = args[1];
        ProcessArgument[] fileMembers = file.getComplexValue();
        String fileSourcePath = fileMembers[0].getSimpleValue();
        String fileTargetPath = fileMembers[1].getSimpleValue();
        boolean replaceable = fileMembers[2].getSimpleValue().equals("true");
        IProject projectHandle = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        try {
            path = TemplateEngineHelper.getTemplateResourceURLRelativeToTemplate(template, fileSourcePath);
            if (path == null) {
                throw new ProcessFailureException(this.getProcessMessage(processId, 4, "Add File failure: template source not found: " + fileSourcePath));
            }
        }
        catch (IOException iOException) {
            throw new ProcessFailureException(this.getProcessMessage(processId, 4, "Add File failure: template source not found: " + fileSourcePath));
        }
        InputStream contents = null;
        if (replaceable) {
            String fileContents;
            try {
                fileContents = ProcessHelper.readFromFile(path);
            }
            catch (IOException iOException) {
                throw new ProcessFailureException(this.getProcessMessage(processId, 4, "Add File failure: cannot read template source: " + fileSourcePath));
            }
            fileContents = ProcessHelper.getValueAfterExpandingMacros(fileContents, ProcessHelper.getReplaceKeys(fileContents), template.getValueStore());
            contents = new ByteArrayInputStream(fileContents.getBytes());
        } else {
            try {
                contents = path.openStream();
            }
            catch (IOException iOException) {
                throw new ProcessFailureException(this.getProcessMessage(processId, 4, "Add File failure: cannot read template source: " + fileSourcePath));
            }
        }
        try {
            IFile iFile = projectHandle.getFile(fileTargetPath);
            if (!iFile.getParent().exists()) {
                ProcessHelper.mkdirs(projectHandle, projectHandle.getFolder(iFile.getParent().getProjectRelativePath()));
            }
            iFile.create(contents, true, null);
            iFile.refreshLocal(1, null);
            projectHandle.refreshLocal(2, null);
        }
        catch (CoreException e) {
            throw new ProcessFailureException(this.getProcessMessage(processId, 4, "Add File failure: " + e.getMessage()), e);
        }
    }
}

