/*
 * Decompiled with CFR 0.152.
 */
package com.symbian.cdt.templateengine.process.processes;

import com.symbian.cdt.templateengine.Template;
import com.symbian.cdt.templateengine.TemplateEngineHelper;
import com.symbian.cdt.templateengine.process.ProcessArgument;
import com.symbian.cdt.templateengine.process.ProcessFailureException;
import com.symbian.cdt.templateengine.process.ProcessHelper;
import com.symbian.cdt.templateengine.process.ProcessRunner;
import java.io.File;
import java.io.IOException;
import java.net.URL;

public class Append
extends ProcessRunner {
    public void process(Template template, ProcessArgument[] args, String processId) throws ProcessFailureException {
        ProcessArgument[][] processArgumentArray = args[0].getComplexArrayValue();
        int n = 0;
        int n2 = processArgumentArray.length;
        while (n < n2) {
            String fileContents;
            URL sourceURL;
            ProcessArgument[] file = processArgumentArray[n];
            String sourcePath = file[0].getSimpleValue();
            try {
                sourceURL = TemplateEngineHelper.getTemplateResourceURLRelativeToTemplate(template, sourcePath);
                if (sourceURL == null) {
                    throw new ProcessFailureException(this.getProcessMessage(processId, 4, "Add File failure: template source not found: " + sourcePath));
                }
            }
            catch (IOException iOException) {
                throw new ProcessFailureException("Copy failure: template source not found: " + sourcePath);
            }
            File targetFile = new File(file[1].getSimpleValue());
            boolean replaceable = file[2].getSimpleValue().equals("true");
            try {
                fileContents = ProcessHelper.readFromFile(sourceURL);
            }
            catch (IOException iOException) {
                throw new ProcessFailureException("Copy failure: cannot read template source: " + sourcePath);
            }
            if (replaceable) {
                fileContents = ProcessHelper.getValueAfterExpandingMacros(fileContents, ProcessHelper.getReplaceKeys(fileContents), template.getValueStore());
            }
            try {
                ProcessHelper.appendFile(fileContents, targetFile);
            }
            catch (IOException e) {
                throw new ProcessFailureException("Append failure: failed while trying to append contents.", e);
            }
            ++n;
        }
    }
}

