/*
 * Decompiled with CFR 0.152.
 */
package com.symbian.cdt.templateengine.process.processes;

import com.symbian.cdt.templateengine.Template;
import com.symbian.cdt.templateengine.process.ProcessArgument;
import com.symbian.cdt.templateengine.process.ProcessFailureException;
import com.symbian.cdt.templateengine.process.ProcessRunner;
import java.util.ArrayList;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.core.model.ISourceEntry;
import org.eclipse.cdt.internal.ui.util.CoreUtility;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class CreateSourceFolder
extends ProcessRunner {
    public void process(Template template, ProcessArgument[] args, String processId) throws ProcessFailureException {
        this.createSourceFolder(args[0].getSimpleValue(), args[1].getSimpleValue());
    }

    protected void createSourceFolder(String projectName, String targetPath) throws ProcessFailureException {
        IProject projectHandle = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (!projectHandle.exists()) {
            throw new ProcessFailureException("Create Source Folder failure: project does not exist: " + projectName);
        }
        IPath projPath = projectHandle.getFullPath();
        IFolder folder = projectHandle.getFolder(targetPath);
        if (!folder.exists()) {
            try {
                CoreUtility.createFolder((IFolder)folder, (boolean)true, (boolean)true, null);
            }
            catch (CoreException e) {
                throw new ProcessFailureException("Create Source Folder failure: " + e.getMessage(), e);
            }
        }
        try {
            ICProject cProject = CoreModel.getDefault().create(projectHandle);
            if (cProject != null) {
                IPathEntry[] entries = cProject.getRawPathEntries();
                ArrayList<Object> newEntries = new ArrayList<Object>(entries.length + 1);
                int projectEntryIndex = -1;
                IPath path = projPath.append(targetPath);
                int i = 0;
                while (i < entries.length) {
                    IPathEntry curr = entries[i];
                    if (curr.getEntryKind() == 8) {
                        if (path.equals((Object)curr.getPath())) {
                            throw new ProcessFailureException("Create Source Folder failure: folder already exists: " + targetPath);
                        }
                        if (projPath.equals((Object)curr.getPath())) {
                            projectEntryIndex = i;
                        }
                    }
                    newEntries.add(curr);
                    ++i;
                }
                ISourceEntry newEntry = CoreModel.newSourceEntry((IPath)path);
                if (projectEntryIndex != -1) {
                    newEntries.set(projectEntryIndex, newEntry);
                } else {
                    newEntries.add(CoreModel.newSourceEntry((IPath)path));
                }
                cProject.setRawPathEntries(newEntries.toArray(new IPathEntry[newEntries.size()]), null);
            }
        }
        catch (CModelException e) {
            throw new ProcessFailureException("Create Source Folder failure: " + e.getMessage(), e);
        }
    }
}

