/*
 * Decompiled with CFR 0.152.
 */
package com.symbian.cdt.templateengine.process.processes;

import com.symbian.cdt.core.SymbianProjectNature;
import com.symbian.cdt.templateengine.Template;
import com.symbian.cdt.templateengine.process.ProcessArgument;
import com.symbian.cdt.templateengine.process.ProcessFailureException;
import com.symbian.cdt.templateengine.process.ProcessRunner;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.core.ManagedCProjectNature;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedBuildInfo;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;

public class NewProject
extends ProcessRunner {
    public void process(Template template, ProcessArgument[] args, String processId) throws ProcessFailureException {
        String projectName = args[0].getSimpleValue();
        String projectTypeId = args[1].getSimpleValue();
        String location = args[2].getSimpleValue();
        String targetType = args[3].getSimpleValue();
        String configs = args[4].getSimpleValue();
        String uid2 = args[5].getSimpleValue();
        String uid3 = args[6].getSimpleValue();
        String vid = args[7].getSimpleValue();
        String sid = args[8].getSimpleValue();
        IProject projectHandle = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (!projectHandle.exists()) {
            try {
                this.createProject(projectHandle, projectTypeId, location, targetType, configs, uid2, uid3, vid, sid);
            }
            catch (CoreException e) {
                throw new ProcessFailureException("New Project failure: " + e.getMessage(), e);
            }
            catch (BuildException e) {
                throw new ProcessFailureException("New Project failure: " + e.getMessage(), e);
            }
        } else {
            throw new ProcessFailureException("New Project failure: project already existing in work space: " + projectName);
        }
    }

    private IManagedProject createProject(IProject projectHandle, String projectTypeId, String location, String targetType, String configIds, String uid2, String uid3, String vid, String sid) throws CoreException, BuildException {
        IPath locationPath;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceDescription workspaceDesc = workspace.getDescription();
        boolean autoBuilding = workspaceDesc.isAutoBuilding();
        workspaceDesc.setAutoBuilding(false);
        workspace.setDescription(workspaceDesc);
        IProjectDescription description = workspace.newProjectDescription(projectHandle.getName());
        if (location != null && !location.trim().equals("") && !(locationPath = Path.fromPortableString((String)location)).equals((Object)Platform.getLocation())) {
            description.setLocation(locationPath);
        }
        NullProgressMonitor monitor = new NullProgressMonitor();
        CCorePlugin.getDefault().createCProject(description, projectHandle, (IProgressMonitor)monitor, ManagedBuilderCorePlugin.MANAGED_MAKE_PROJECT_ID);
        CCorePlugin.getDefault().convertProjectFromCtoCC(projectHandle, (IProgressMonitor)monitor);
        ManagedCProjectNature.addManagedNature((IProject)projectHandle, (IProgressMonitor)monitor);
        ManagedCProjectNature.addManagedBuilder((IProject)projectHandle, (IProgressMonitor)monitor);
        SymbianProjectNature.addNature((IProject)projectHandle, (IProgressMonitor)monitor);
        ICDescriptor desc = CCorePlugin.getDefault().getCProjectDescription(projectHandle, true);
        desc.remove("org.eclipse.cdt.core.ScannerInfoProvider");
        desc.create("org.eclipse.cdt.core.ScannerInfoProvider", ManagedBuildManager.INTERFACE_IDENTITY);
        desc.saveProjectData();
        IProjectType projType = ManagedBuildManager.getProjectType((String)projectTypeId);
        ManagedBuildInfo info = ManagedBuildManager.createBuildInfo((IResource)projectHandle);
        IManagedProject newManagedProject = ManagedBuildManager.createManagedProject((IResource)projectHandle, (IProjectType)projType);
        ManagedBuildManager.setNewProjectVersion((IProject)projectHandle);
        IConfiguration defaultConfig = null;
        String[] stringArray = configIds.split(",");
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String configId = stringArray[n];
            IConfiguration config = projType.getConfiguration(configId);
            if (config != null) {
                IConfiguration newConfig = newManagedProject.createConfiguration(config, String.valueOf(config.getId()) + "." + ManagedBuildManager.getRandomNumber());
                newConfig.setArtifactName(newManagedProject.getDefaultArtifactName());
                if (defaultConfig == null) {
                    defaultConfig = newConfig;
                }
            }
            ++n;
        }
        ManagedBuildManager.setDefaultConfiguration((IProject)projectHandle, defaultConfig);
        ManagedBuildManager.setSelectedConfiguration((IProject)projectHandle, defaultConfig);
        IStatus status = ManagedBuildManager.initBuildInfoContainer((IResource)projectHandle);
        if (status.getCode() != 0) {
            ResourcesPlugin.getPlugin().getLog().log(status);
        }
        info.setValid(true);
        ManagedBuildManager.saveBuildInfo((IProject)projectHandle, (boolean)true);
        if (targetType != null) {
            IConfiguration[] iConfigurationArray = info.getManagedProject().getConfigurations();
            n2 = 0;
            int n3 = iConfigurationArray.length;
            while (n2 < n3) {
                IConfiguration config = iConfigurationArray[n2];
                IOption[] iOptionArray = config.getToolChain().getOptions();
                int n4 = 0;
                int n5 = iOptionArray.length;
                while (n4 < n5) {
                    IOption option = iOptionArray[n4];
                    switch (option.getValueType()) {
                        case 2: {
                            if (option.getId().toLowerCase().contains("uid2")) {
                                this.setOptionValue(config, option, uid2);
                                break;
                            }
                            if (option.getId().toLowerCase().contains("uid3")) {
                                this.setOptionValue(config, option, uid3);
                                break;
                            }
                            if (option.getId().toLowerCase().contains("vendorid")) {
                                this.setOptionValue(config, option, vid);
                                break;
                            }
                            if (!option.getId().toLowerCase().contains("secureid")) break;
                            this.setOptionValue(config, option, sid);
                            break;
                        }
                        case 1: {
                            if (!option.getId().toLowerCase().contains("targettype")) break;
                            String[] vals = option.getApplicableValues();
                            String val = null;
                            String[] stringArray2 = vals;
                            int n6 = 0;
                            int n7 = stringArray2.length;
                            while (n6 < n7) {
                                String value = stringArray2[n6];
                                String n8 = option.getEnumName(value);
                                if (n8.equalsIgnoreCase(targetType)) {
                                    val = value;
                                    break;
                                }
                                ++n6;
                            }
                            if (val == null) break;
                            config.setArtifactExtension(val);
                            this.setOptionValue(config, option, val);
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        info.setValid(true);
        ManagedBuildManager.saveBuildInfo((IProject)projectHandle, (boolean)true);
        workspaceDesc.setAutoBuilding(autoBuilding);
        workspace.setDescription(workspaceDesc);
        return newManagedProject;
    }

    private void setOptionValue(IConfiguration config, IOption option, String val) throws BuildException {
        if (val != null) {
            if (!option.isExtensionElement()) {
                option.setValue(val);
            } else {
                IOption newOption = config.getToolChain().createOption(option, String.valueOf(option.getId()) + "." + ManagedBuildManager.getRandomNumber(), option.getName(), false);
                newOption.setValue(val);
            }
        }
    }
}

