/*
 * Decompiled with CFR 0.152.
 */
package com.symbian.cdt.templateengine.process.processes;

import com.symbian.cdt.templateengine.Template;
import com.symbian.cdt.templateengine.process.ProcessArgument;
import com.symbian.cdt.templateengine.process.ProcessFailureException;
import com.symbian.cdt.templateengine.process.ProcessRunner;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOptionCategory;
import org.eclipse.cdt.managedbuilder.core.IResourceConfiguration;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;

public class SetMBSStringOptionValue
extends ProcessRunner {
    public void process(Template template, ProcessArgument[] args, String processId) throws ProcessFailureException {
        String projectName = args[0].getSimpleValue();
        IProject projectHandle = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceDescription workspaceDesc = workspace.getDescription();
        boolean autoBuilding = workspaceDesc.isAutoBuilding();
        workspaceDesc.setAutoBuilding(false);
        try {
            workspace.setDescription(workspaceDesc);
        }
        catch (CoreException coreException) {}
        ProcessArgument[][] resourcePathObjects = args[1].getComplexArrayValue();
        boolean modified = false;
        ProcessArgument[][] processArgumentArray = resourcePathObjects;
        int n = 0;
        int n2 = processArgumentArray.length;
        while (n < n2) {
            ProcessArgument[] resourcePathObject = processArgumentArray[n];
            String id = resourcePathObject[0].getSimpleValue();
            String value = resourcePathObject[1].getSimpleValue();
            String path = resourcePathObject[2].getSimpleValue();
            try {
                modified |= this.setOptionValue(projectHandle, id, value, path);
            }
            catch (BuildException e) {
                throw new ProcessFailureException("SetMBSStringOptionValue failure: " + e.getMessage(), e);
            }
            ++n;
        }
        if (modified) {
            ManagedBuildManager.saveBuildInfo((IProject)projectHandle, (boolean)true);
        }
        workspaceDesc.setAutoBuilding(autoBuilding);
        try {
            workspace.setDescription(workspaceDesc);
        }
        catch (CoreException coreException) {}
    }

    private boolean setOptionValue(IProject projectHandle, String id, String value, String path) throws BuildException, ProcessFailureException {
        IConfiguration[] projectConfigs = ManagedBuildManager.getBuildInfo((IResource)projectHandle).getManagedProject().getConfigurations();
        boolean resource = path != null && !path.equals("") && !path.equals("/");
        boolean modified = false;
        IConfiguration[] iConfigurationArray = projectConfigs;
        int n = 0;
        int n2 = iConfigurationArray.length;
        while (n < n2) {
            IOptionCategory tool;
            int n3;
            int n4;
            IOptionCategory[] iOptionCategoryArray;
            IConfiguration config = iConfigurationArray[n];
            IResourceConfiguration resourceConfig = null;
            if (resource) {
                resourceConfig = config.getResourceConfiguration(path);
                if (resourceConfig == null) {
                    IFile file = projectHandle.getFile(path);
                    if (file == null) {
                        throw new ProcessFailureException("SetMBSStringOptionValue failure: No such file exists: " + path);
                    }
                    resourceConfig = config.createResourceConfiguration(file);
                }
                iOptionCategoryArray = resourceConfig.getTools();
                n4 = 0;
                n3 = iOptionCategoryArray.length;
                while (n4 < n3) {
                    tool = iOptionCategoryArray[n4];
                    modified |= this.setOptionForResourceConfig(id, value, resourceConfig, tool);
                    ++n4;
                }
            } else {
                iOptionCategoryArray = config.getToolChain().getChildCategories();
                n4 = 0;
                n3 = iOptionCategoryArray.length;
                while (n4 < n3) {
                    IOptionCategory category = iOptionCategoryArray[n4];
                    modified |= this.setOptionForConfig(id, value, config, category);
                    ++n4;
                }
                iOptionCategoryArray = config.getTools();
                n4 = 0;
                n3 = iOptionCategoryArray.length;
                while (n4 < n3) {
                    tool = iOptionCategoryArray[n4];
                    modified |= this.setOptionForConfig(id, value, config, tool);
                    ++n4;
                }
            }
            ++n;
        }
        return modified;
    }

    private boolean setOptionForResourceConfig(String id, String value, IResourceConfiguration resourceConfig, IOptionCategory category) {
        boolean modified = false;
        Object[][] options = category.getOptions(resourceConfig);
        int i = 0;
        while (i < options.length) {
            IHoldsOptions holder = (IHoldsOptions)options[i][0];
            if (holder == null) break;
            IOption option = (IOption)options[i][1];
            if (option.getId().toLowerCase().matches(id)) {
                IOption setOption = ManagedBuildManager.setOption((IResourceConfiguration)resourceConfig, (IHoldsOptions)holder, (IOption)option, (String)value);
                if (setOption == null) {
                    setOption = option;
                }
                modified = true;
            }
            ++i;
        }
        IOptionCategory[] iOptionCategoryArray = category.getChildCategories();
        int n = 0;
        int n2 = iOptionCategoryArray.length;
        while (n < n2) {
            IOptionCategory category2 = iOptionCategoryArray[n];
            modified |= this.setOptionForResourceConfig(id, value, resourceConfig, category2);
            ++n;
        }
        return modified;
    }

    private boolean setOptionForConfig(String id, String value, IConfiguration config, IOptionCategory category) {
        IOptionCategory[] childCategories;
        boolean modified = false;
        Object[][] options = category.getOptions(config);
        int i = 0;
        while (i < options.length) {
            IHoldsOptions holder = (IHoldsOptions)options[i][0];
            if (holder == null) break;
            IOption option = (IOption)options[i][1];
            if (option.getId().toLowerCase().matches(id)) {
                IOption setOption = ManagedBuildManager.setOption((IConfiguration)config, (IHoldsOptions)holder, (IOption)option, (String)value);
                if (setOption == null) {
                    setOption = option;
                }
                modified = true;
            }
            ++i;
        }
        if ((childCategories = category.getChildCategories()) != null && childCategories.length > 0) {
            IOptionCategory[] iOptionCategoryArray = childCategories;
            int n = 0;
            int n2 = iOptionCategoryArray.length;
            while (n < n2) {
                IOptionCategory category2 = iOptionCategoryArray[n];
                modified |= this.setOptionForConfig(id, value, config, category2);
                ++n;
            }
        }
        return modified;
    }
}

